#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testauth.c,v 1.1.1.1 1995/06/16 21:10:52 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test authenticating yourself as a user to brimstone
 */

#include "sos.h"
#include "interface.h"
#include "readconf.h"

int verbose=0;

main(int argc,char *argv[])
{
  char sbuf1[EXTENDED_SIZE], sbuf2[EXTENDED_SIZE];
  int c, errflg = 0;
  int ret;
  u_int nextstate, req_input;
  sos_string inbuf, outbuf;
  extern char *optarg;
  extern int optind;

  inbuf.str = sbuf1;
  inbuf.len = EXTENDED_SIZE;
  outbuf.str = sbuf2;
  outbuf.len = EXTENDED_SIZE;

  while ((c = getopt(argc, argv, "d:v")) != -1)
    switch (c)
      {
      case 'd':
	bs_debug++;
	break;
      case 'v':
	verbose++;
	break;
      case '?':
        errflg++;
      }

  if (errflg || (argc - optind) != 1)
    {
      fprintf(stderr,"Usage: %s [-d] <user>\n",argv[0]);
      exit(5);
    }

  open_soslog("testauth" , 1);

  nextstate = 0;
  while(1)
    {
      req_input = BS_NO_INPUT;
      ret = BS_State(BS_GetChallenge, argv[optind], &nextstate, &req_input, &outbuf, &inbuf);
      if (outbuf.str[0])
	{
	  puts(outbuf.str);
	}
      if (req_input != BS_NO_INPUT)
	{
	  /* XXX - need to handle BS_NO_ECHO */
	  fflush(stdout);
	  fgets(inbuf.str, inbuf.len-1, stdin);
	}
      if (!nextstate)
	break;
    }
  if (ret != AUTH_SUCCEED)
    {
      if (verbose)
	{
	  fprintf(stderr,"User %s is not authenticated",argv[optind]);
	  fprintf(stderr,":  %s",bs_auth_extended);
	  fprintf(stderr,"\n");
	}
    }

  fflush(stdout);

  nextstate = 0;
  while(1)
    {
      req_input = BS_NO_INPUT;
      ret = BS_State(BS_Authenticate, argv[optind], &nextstate, &req_input, &outbuf, &inbuf);
      if (outbuf.str[0])
	puts(outbuf.str);
      if (req_input != BS_NO_INPUT)
	{
	  /* XXX - need to handle BS_NO_ECHO */
	  fflush(stdout);
	  fgets(inbuf.str, inbuf.len-1, stdin);
	}
      if (!nextstate)
	break;
    }
  if (ret != AUTH_SUCCEED)
    {
      fprintf(stderr,"User %s is not authenticated",argv[optind]);
      if (verbose)
	fprintf(stderr,":  %s",bs_auth_extended);
      fprintf(stderr,"\n");
      exit(1);
    }

  printf("User %s is authenticated!!\n",argv[optind]);

  BS_Cleanup(argv[optind]);
  exit(0);
}


