#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "genccard.c,v 1.1.1.1 1995/06/16 21:10:52 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Generate Cryptocard keys
 */

#include "sos.h"

sos_config_t config;


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int num = 1;

  while ((c = getopt(argc, argv, "n:")) != -1)
    switch (c)
      {
      case 'n':
	num = atoi(optarg);
	break;
      default:
	printf("Usage: %s\n",argv[0]);
	exit(1);
	break;
      }

  printf("To reset CCard:\n\t[On] 225371 [ENT]\n\t{start typing immediately after [On]--do not wait for anything}\n\n");
  printf("To program CCard:\n\t{Card Displays LOCKED}\n\t[ENT] 100->034->001->[ENT]\n\t{Card Displays Key1:  Replace # with numbers from CCard Key below}\n\t###->###->###->###->###->###->###->###->[ENT]\n\t{Verify number displayed with Verification column.}\n\t[ENT] 1111 [ENT] 1111 [ENT]\n\t{Should display \"CARD OK\"}\n\tPut BS Key in Aux info for user (remember to quote it!)\n\n");
  printf("Num BS Key            CCard Key                         Verification\n--- ----------------  --------------------------------  --------\n");

  for (;num;num--)
    {
      unsigned char buf[8], testbuf[8], key[17], bin[8], string[17];

      sos_get_rand(buf, sizeof(buf));

      printf("%03d ",num);
      for(c = 0; c < sizeof(buf); c++)
	{
	  printf("%02x",buf[c]&0xff);
	  sprintf(key+(c*2),"%02x",buf[c]&0xff);
	}
	  

      printf("  ");

      for(c = 0; c < sizeof(buf); c++)
	{
	  printf("%03o,",buf[c]&0xff);
	}

      memset(testbuf,0,sizeof(testbuf));
      ccard_calcResp(key, testbuf, string, bin);

      printf("  %s\n",string);
    }
  exit(0);
}
