#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testnull.c,v 1.1.1.1 1995/06/16 21:10:53 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test null config file
 */

#include "interface.h"
#include "readconf.h"

int verbose=0;

char *writefile = "./output1";



main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  int count = 1;
  char *configfile = NULL;

  while ((c = getopt(argc, argv, "dC:vW:n:")) != -1)
    switch (c)
      {
      case 'd':
	bs_debug++;
	break;
      case 'W':
	writefile = optarg;
	break;
      case 'v':
	verbose++;
	break;
      case '?':
        errflg++;
      }

  if (errflg || (argc - optind) != 0)
    {
      fprintf(stderr,"Usage: %s [-d] [-C config] [-v] [-W outputfile]\n",argv[0]);
      exit(5);
    }

  if (nullconfig() != AUTH_SUCCEED)
    {
      fprintf(stderr,"Read Failed");
      if (verbose)
        {
          fprintf(stderr,":  %s\n",bs_auth_extended);
        }
      fprintf(stderr,"\n");
      exit(5);
    }

  if (copyout(writefile) != AUTH_SUCCEED)
    {
      fprintf(stderr,"Write Failed");
      if (verbose)
	{
	  fprintf(stderr,":  %s\n",bs_auth_extended);
	}
      fprintf(stderr,"\n");
      exit(5);
    }

  printf("\nWrite succeeded to file %s\n",writefile);
}


