#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testdelete.c,v 1.1.1.1 1995/06/16 21:10:53 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test freeing of brimstone buffers (e.g. check for memory leaks)
 */


#include "interface.h"
#include "readconf.h"

#include <sys/resource.h>

#if defined(__sun__) && !defined(__svr4__) || defined(__bsdi__) || defined(__IRIX__)
#define HAVE_USAGE_INFO
#endif


int verbose=0;


int
main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  int count = 1;
  int first=1;
  char *configfile = NULL;
#ifdef HAVE_USAGE_INFO
  struct rusage rinit,rcur,rfirst;
#endif /* HAVE_USAGE_INFO */


  while ((c = getopt(argc, argv, "dC:vn:")) != -1)
    switch (c)
      {
      case 'd':
	bs_debug++;
	break;
      case 'C':
	configfile = optarg;
	break;
      case 'n':
	count = atoi(optarg);
	break;
      case 'v':
	verbose++;
	break;
      case '?':
        errflg++;
      }


  if (errflg || (argc - optind) != 0)
    {
      fprintf(stderr,"Usage: %s [-dv] [-C config] [-n count]\n",argv[0]);
      exit(5);
    }


#ifdef HAVE_USAGE_INFO
  getrusage(RUSAGE_SELF,&rinit);
#endif /* HAVE_USAGE_INFO */


  printf("Unlinking %d times\n",count);
  for (;count > 0;count--)
    {
#ifdef HAVE_USAGE_INFO
      getrusage(RUSAGE_SELF,&rcur);
      printf("%7.7d %7.7d %7.7d\n",count,rcur.ru_maxrss,rcur.ru_idrss);
      fflush(stdout);
#endif /* HAVE_USAGE_INFO */

      /* Read config file */
      if (readconfig(configfile) != AUTH_SUCCEED)
	{
	  fprintf(stderr,"Read Failed");
	  if (verbose)
	    {
	      fprintf(stderr,":  %s\n",bs_auth_extended);
	    }
	  fprintf(stderr,"\n");
	  exit(5);
	}

      /* Free config file */
      if (unlinkACL() != AUTH_SUCCEED)
	{
	  fprintf(stderr,"Unlink Failed");
	  if (verbose)
	    {
	      fprintf(stderr,":  %s\n",bs_auth_extended);
	    }
	  fprintf(stderr,"\n");
	  exit(5);
	}

      /* Delete the files hash table */
      if (unlinkFiles() != AUTH_SUCCEED)
	{
	  fprintf(stderr,"Unlink (files) Failed");
	  if (verbose)
	    {
	      fprintf(stderr,":  %s\n",bs_auth_extended);
	    }
	  fprintf(stderr,"\n");
	  exit(5);
	}

#ifdef HAVE_USAGE_INFO
      if (first)
	{
	  getrusage(RUSAGE_SELF,&rfirst);
	  first=0;
	}
#endif /* HAVE_USAGE_INFO */
    }

  printf("\n\nUnlink succeeded\n");

#ifdef HAVE_USAGE_INFO
  getrusage(RUSAGE_SELF,&rcur);
  printf("Memory grew %d %d since first init\n",
	 rcur.ru_maxrss-rfirst.ru_maxrss,
	 rcur.ru_idrss-rfirst.ru_idrss);
#endif /* HAVE_USAGE_INFO */
}


