#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "testconfig.c,v 1.1.1.1 1995/06/16 21:10:52 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test brimstone ACL restrictions on a user
 */

#include "interface.h"
#include "readconf.h"

int verbose = 0;

main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  struct tm date, *pdate;
  int epoch, ret;
  struct in_addr srcaddr, dstaddr;
  short srcserv, dstserv;

  memset((char *)&date, 0, sizeof(date));

  while ((c = getopt(argc, argv, "dv")) != -1)
    switch (c)
      {
      case 'd':
	bs_debug++;
	break;
      case 'v':
	verbose++;
	break;
      case '?':
        errflg++;
      }

  open_soslog("testconfig" , 1);

  if (errflg || (((argc - optind) != 7) && ((argc - optind) != 5)))
    {
      fprintf(stderr,"Usage: %s [-d] <user> [ <d/a/te> <ti:me> ] <srcaddr> <srcserv> <dstaddr> <dstserv>\n",argv[0]);
      exit(5);
    }

  if ((argc - optind) == 5)
    {
      ret = BS_CheckACL(argv[optind], argv[optind+1], argv[optind+2],
			argv[optind+3], argv[optind+4]);
    }
  else
    {
      sscanf(argv[optind+1],"%d/%d/%d",&(date.tm_mon),&(date.tm_mday),&(date.tm_year));
      sscanf(argv[optind+2],"%d:%d",&(date.tm_hour),&(date.tm_min));

      putenv("TZ=GMT");
      tzset();
      if (date.tm_year > 1900)
	date.tm_year -= 1900;
      date.tm_mon--;		/* 0-11, not 1-12 */
      date.tm_sec = 0;
      date.tm_wday = 0;
      date.tm_yday = 0;
      date.tm_isdst = 0;

      epoch = mktime(&date);
      epoch /= 86400;
      pdate = &date;

      if (sos_getabyfoo(argv[optind+3], &srcaddr) < 0)
	{
	  fprintf(stderr,"Error!  Invalid address %s\n",argv[optind+3]);
	  exit(5);
	}

      srcserv = sos_getsbyfoo(argv[optind+4]);
      if ((int)srcserv == -1)
	{
	  fprintf(stderr,"Error!  Service name %s is unknown\n",argv[optind+4]);
	  exit(5);
	}


      if (sos_getabyfoo(argv[optind+5], &dstaddr) < 0)
	{
	  fprintf(stderr,"Error!  Invalid address %s\n",argv[optind+3]);
	  exit(5);
	}

      dstserv = sos_getsbyfoo(argv[optind+6]);
      if ((int)dstserv == -1)
	{
	  fprintf(stderr,"Error!  Service name %s is unknown\n",argv[optind+4]);
	  exit(5);
	}

      printf("Checking for user %s, Day %d, Hour %d, Days %d, (%x,%d),(%x,%d)\n",
	     argv[optind],pdate->tm_wday,pdate->tm_hour,
	     epoch,srcaddr.s_addr,srcserv,dstaddr.s_addr,dstserv);

      ret = BS_CheckACL_Aux(argv[optind],pdate->tm_wday,pdate->tm_hour,
			    epoch,srcaddr,srcserv,dstaddr,dstserv);
    }

  printf ("Return value: %d\n", ret);
  switch (ret)
    {
    case AUTH_POS_MATCH:
      printf("Connection truly verified\n");
      exit (0);
      break;

    case AUTH_NEG_MATCH: 
      printf("Connection not allowed");
      if (verbose)
	{
	  printf(":  %s\n",bs_auth_extended);
	}
      printf("\n");
      exit(1);
      break;

    case AUTH_ERROR:
      printf("Failed");
      if (verbose)
	{
	  printf(":  %s\n",bs_auth_extended);
	}
      printf("\n");
      exit (5);
      break;

    default:
      printf("Bizzare return code\n");
      exit (4);
      break;
    }

  /* NOTREACHED */
}

