#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "rmconf.c,v 1.1.1.1 1995/06/16 21:10:47 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Clean up after core local mode Brimstone
 *
 * Appears to actually clear everything, according to Insight
 */

#include "interface.h"
#include "readconf.h"

static int unlinkSub(dict_h Tbl,int (*unlinkfun)(void *s));
static int unlinkUserSub(dict_h Tbl);
static int unlinkTime(void *t);
static int unlinkDate(void *t);
static int unlinkAddr(void *t);
static int unlinkServ(void *t);
static int unlinkGroup(void *t);



/*
 * Interface to deleting all ACL structures
 */
int
unlinkACL()
{
  int ret;

  if ((ret = unlinkSub(TimeTbl,unlinkTime)) != AUTH_SUCCEED)
    return (ret);
  TimeTbl = NULL;

  if ((ret = unlinkSub(DateTbl,unlinkDate)) != AUTH_SUCCEED)
    return (ret);
  DateTbl = NULL;

  if ((ret = unlinkSub(AddrTbl,unlinkAddr)) != AUTH_SUCCEED)
    return (ret);
  AddrTbl = NULL;

  if ((ret = unlinkSub(ServTbl,unlinkServ)) != AUTH_SUCCEED)
    return (ret);
  ServTbl = NULL;

  if ((ret = unlinkSub(GroupTbl,unlinkGroup)) != AUTH_SUCCEED)
    return (ret);
  GroupTbl = NULL;

  if ((ret = unlinkUserSub(UserTbl)) != AUTH_SUCCEED)
    return (ret);
  UserTbl = NULL;

  /* Free up info from lex */
  FreeIncludeFiles();

  resetconfiginit();
  return(AUTH_SUCCEED);
}



/*
 * Delete the standard linked lists
 */
static int unlinkSub(dict_h Tbl,int (*unlinkfun)(void *f))
{
  int ret;
  dict_obj htcur;
  dict_obj llcur;
  struct FirstLevel_t *f;
  struct element_t *e;

  /* We delete as we go along, so we are always at minimum */
  for(htcur = ht_minimum(Tbl);htcur != NULL;htcur = ht_minimum(Tbl))
    {
      f = (struct FirstLevel_t *)htcur;

      sprintf(bs_auth_extended,"Free(%s) error",f->key);

      /* MAGIC COOKIE */
      if (!strcmp(f->key,"ANY"))
	{
	  ht_delete(Tbl,htcur);
	  continue;
	}

      /* We delete as we go along, so we are always at maximum */
      for(llcur = dll_maximum(f->info);llcur != NULL;llcur = dll_maximum(f->info))
	{
	  e = (struct element_t *)llcur;

	  if (e->meta)
	    {
	      dll_delete(f->info,llcur);
	      free(e->ptr.meta);
	      free(e);
	      continue;
	    }
	  if ((ret = (*unlinkfun)((void *)e->ptr.generic)) != AUTH_SUCCEED)
	    {
	      return(ret);
	    }
	  dll_delete(f->info,llcur);
	  free(e);
	}

      ht_delete(Tbl,htcur);
      free(f->key);
      dll_destroy(f->info);
      free(f);
    }

  ht_destroy(Tbl);
  return(AUTH_SUCCEED);
}



/*
 * Delete the user ACL (user is different from standard)
 */
static int unlinkUserSub(dict_h Tbl)
{
  dict_obj htcur;
  struct userinfo_t *user;

  /* We delete as we go along, so we are always at minimum */
  for(htcur = ht_minimum(Tbl);htcur != NULL;htcur = ht_minimum(Tbl))
    {
      user = (struct userinfo_t *)htcur;

      sprintf(bs_auth_extended,"Free(%s) error",user->user);
      ht_delete(Tbl,htcur);
      free(user->user);
      free(user->auth);
      free(user->acode);
      free(user->group);
      free(user->contact);
      free(user->responsible);
      free(user->GCOS);
      free(user->comment);
      free(user);
    }

  ht_destroy(Tbl);
  return(AUTH_SUCCEED);
}



/*
 * Free everything relating to the time structure (including itself)
 */
static int unlinkTime(void *t)
{
  free(t);
  return(AUTH_SUCCEED);
}



/*
 * Free everything relating to the date structure (including itself)
 */
static int unlinkDate(void *t)
{
  free(t);
  return(AUTH_SUCCEED);
}



/*
 * Free everything relating to the address structure (including itself)
 */
static int unlinkAddr(void *t)
{
  free(t);
  return(AUTH_SUCCEED);
}



/*
 * Free everything relating to the service structure (including itself)
 */
static int unlinkServ(void *t)
{
  free(t);
  return(AUTH_SUCCEED);
}



/*
 * Free everything relating to the group structure (including itself)
 */
static int unlinkGroup(void *vt)
{
  struct groupinfo_t *t = (struct groupinfo_t *)vt;

  free(t->metatime);
  free(t->metadate);
  free(t->srcmetaaddr);
  free(t->srcmetaserv);
  free(t->dstmetaaddr);
  free(t->dstmetaserv);
  free(t);
  return(AUTH_SUCCEED);
}



/*
 * Unlink the files hash table
 */
int unlinkFiles()
{
  dict_obj htcur;
  struct fileinfo_t *f;

  /* We delete as we go along, so we are always at minimum */
  for(htcur = ht_minimum(FileTbl);htcur != NULL;htcur = ht_minimum(FileTbl))
    {
      f = (struct fileinfo_t *)htcur;

      ht_delete(FileTbl,htcur);

      free(f->file);
      free(f);
    }

  ht_destroy(FileTbl);
  FileTbl = NULL;

  return(AUTH_SUCCEED);
}
