#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "orderdll.c,v 1.1.1.1 1995/06/16 21:10:47 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Order a CLC DLL (for GUI)
 */

#include "interface.h"
#include "readconf.h"


/*
 * Order a DLL
 *
 * Takes a DLL head, the object to be moved, and the object which the
 * old object should be moved AFTER.
 *
 * NULL to be before everything (char *)-1 to be after everything.
 *
 * Note that the ordering I am talking about is DLL ordering.  Brimstone
 * ordering is frequently reversed.
 */
int orderdll(dict_h dll, dict_obj from, dict_obj to)
{
  dict_obj dllcur;
  dict_h new;

  if ((new = dll_create(NULL,NULL,DICT_UNORDERED,NULL)) == NULL)
    {
      sprintf(bs_auth_extended,"Cannot create temp list");
      return (AUTH_ERROR);
    }

  /* Make new list with correct ordering */
  if ((int)to == -1)
    dll_insert(new,from);
  for(dllcur = dll_maximum(dll);dllcur != NULL;dllcur = dll_maximum(dll))
    {
      /* We manually add from */
      if (dllcur != from)
	{
	  dll_insert(new,dllcur);

	  if (dllcur == to)
	    dll_insert(new,from);
	}
      dll_delete(dll,dllcur);
    }
  if (to == NULL)
    dll_insert(new,from);

  /* Copy list back to original location so pointers remain valid */
  for(dllcur = dll_maximum(new);dllcur != NULL;dllcur = dll_maximum(new))
    {
      dll_insert(dll,dllcur);
      dll_delete(new,dllcur);
    }

  dll_destroy(new);		/* Get rid of temp space. */
  return(AUTH_SUCCEED);
}
