/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Header file for local mode brimstone library.
 */

#ifndef _bs_interface_h
#define _bs_interface_h

#include <sos.h>

#define AUTH_ERROR	-1

#define AUTH_NEG_MATCH	0
#define AUTH_FAIL	AUTH_NEG_MATCH

#define AUTH_POS_MATCH	1
#define AUTH_SUCCEED	AUTH_POS_MATCH

#define AUTH_CONTINUE	2	/* Should not be returned to external routines */

#define EXTENDED_SIZE		1024

#define BS_MAXUSERSIZE		64
#define BS_RESPLEN		1024
#define BS_PASSLEN		256

extern int bs_debug;
extern char auth_extended[];	/* Extended diagnostic messages */

#define BS_ERROR	AUTH_ERROR
#define BS_LOSE		AUTH_NEG_MATCH
#define BS_LOST		AUTH_NEG_MATCH
#define BS_WIN		AUTH_POS_MATCH
#define BS_WON		AUTH_POS_MATCH
#define BS_NEXT		AUTH_CONTINUE

#define BS_IOLEN                512

/* Request for I/O */
#define BS_NO_INPUT		0
#define BS_SIMPLE_INPUT		1
#define BS_NOECHO_INPUT		2

#define BS_SPTP_INIT	"INITIALIZE"
#define BS_SPTP_AUTH	"AUTHENTICATE"
#define BS_SPTP_ACL	"ACL-AUTHENTICATE"
#define BS_SPTP_CMD	"COMMAND"
#define BS_SPTP_CONN	"CONNECTING"
#define BS_SPTP_RELAY	"RELAY"
#define BS_SPTP_EXIT	"EXIT"


extern char bs_auth_extended[];	/* Extended diagnostic messages */

extern int BS_GenDefChallenge(char *buf, int bufsize);
extern int bs_check_reload();
extern int bs_reload();

enum BS_MasterStates_t
  {
    BS_GetChallenge, BS_Authenticate, BS_Passwd
  };
typedef enum BS_MasterStates_t BS_MasterStates;

/* Extended authentication state engine */
extern int BS_State(BS_MasterStates MS, char *user, u_int * nextstate,
		u_int * req_input, sos_string * outbuf, sos_string * inbuf);

/* Cleaup routines */
extern void BS_Cleanup(char *user);

/*
 * Check the ACL to see if the specified connection
 * would be allowed for the preverified user
 */
extern int BS_CheckACL(char *user, char *srcip, char *srcservstr,
		       char *dstip, char *dstservstr);
extern int BS_CheckACL_Num(char *user,
			   struct in_addr srcaddr, unsigned short srcserv,
			   struct in_addr dstaddr, unsigned short dstserv);

/*
 * Long/complex form of above
 */
extern int BS_CheckACL_Aux(char *user, int wday, int hour, int epoch,
			   struct in_addr srcaddr, unsigned short srcserv,
			   struct in_addr dstaddr, unsigned short dstserv);

/*
 * Try to make a brimstone TCP connection with ACL checks
 */
int bs_make_conn(char *hoststring, int numport, int timeout_val, int socopts, char *username, struct sos_conninfo *sourceinfo, FILE *verbose);

/*
 * ProcTitle stuff
 */
int bs_initProcTitle(int argc, char ***argv, char ***envp, char **program);
int bs_setProcTitle(char *user, struct sos_conninfo *src, struct sos_conninfo *dst, char *phase);

#endif				/*!_bs_interface_h */
