#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "proctitle.c,v 1.1.1.1 1995/06/16 21:10:49 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Brimstone proctitle stuff
 */

#include "sos.h"
#include "interface.h"


static struct sos_conninfo unknown =
{ "Not.connected [0.0.0.0]", 0, { 0 }, -1 };



/*
 * Trivial wrapper for SOS IPT
 */
int
bs_initProcTitle(int argc, char ***argv, char ***envp, char **program)
{
  return(sos_initProcTitle(argc, argv, envp, program));
}



/*
 * Fairly trivial wrapper for SOS_SPT
 */
int
bs_setProcTitle(char *user, struct sos_conninfo *src, struct sos_conninfo *dst, char *phase)
{

  if (!user)
    user = "pending";

  if (!src)
    src = &unknown;

  if (!dst)
    dst = &unknown;

  if (!phase)
    phase = "Programmer is a moron";

  return(sos_setProcTitle("USER=%s: SRC=%s/%d: DST=%s/%d: %s",user, src->printhost, src->port, dst->printhost, dst->port, phase));
}
