%{
/*
 * (C)opyright 1997 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 *
 * $Id: iplang_l.l,v 2.0.2.8 1997/09/13 07:14:23 darrenr Exp $
 */

#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include "y.tab.h"

#ifndef	__P
# ifdef __STDC__
#  define	__P(x)	x
# else
#  define	__P(x)	()
# endif
#endif

int lineNum = 0, proto = 0, oldproto = 0, next = -1, laststate = 0;
int *prstack = NULL, numpr = 0, state = 0, token = 0;

void	push_proto __P((void));
void	pop_proto __P((void));
int	next_state __P((int, int));
int	next_item __P((int));
int	save_token __P((void));
void	swallow __P((void));
int	yylex __P((void));
%}

%%
[ \t\r]	;
\n	{ lineNum++; swallow(); }
interface |
iface	{ return next_state(IL_INTERFACE, -1); }
name |
ifname	{ return next_state(IL_IFNAME, IL_TOKEN); }
router	{ return next_state(IL_DEFROUTER, IL_TOKEN); }
mtu 	{ return next_state(IL_MTU, IL_NUMBER); }
eaddr	{ return next_state(IL_EADDR, IL_TOKEN); }
v4addr	{ return next_state(IL_V4ADDR, IL_TOKEN); }
ipv4	{ return next_state(IL_IPV4, -1); }
v	{ return next_state(IL_V4V, IL_TOKEN); }
proto	{ return next_state(IL_V4PROTO, IL_TOKEN); }
hl	{ return next_state(IL_V4HL, IL_TOKEN); }
id	{ return next_state(IL_V4ID, IL_TOKEN); }
ttl	{ return next_state(IL_V4TTL, IL_TOKEN); }
tos	{ return next_state(IL_V4TOS, IL_TOKEN); }
src	{ return next_state(IL_V4SRC, IL_TOKEN); }
dst	{ return next_state(IL_V4DST, IL_TOKEN); }
opt	{ return next_state(IL_OPT, -1); }
len	{ return next_state(IL_LEN, IL_TOKEN); }
off	{ return next_state(IL_OFF, IL_TOKEN); }
sum	{ return next_state(IL_SUM, IL_TOKEN); }
tcp	{ return next_state(IL_TCP, -1); }
sport	{ return next_state(IL_SPORT, IL_TOKEN); }
dport	{ return next_state(IL_DPORT, IL_TOKEN); }
seq	{ return next_state(IL_TCPSEQ, IL_TOKEN); }
ack	{ return next_state(IL_TCPACK, IL_TOKEN); }
flags	{ return next_state(IL_TCPFL, IL_TOKEN); }
urp	{ return next_state(IL_TCPURP, IL_TOKEN); }
win	{ return next_state(IL_TCPWIN, IL_TOKEN); }
udp	{ return next_state(IL_UDP, -1); }
send	{ return next_state(IL_SEND, -1); }
via	{ return next_state(IL_VIA, IL_TOKEN); }
arp	{ return next_state(IL_ARP, -1); }
data	{ return next_state(IL_DATA, -1); }
value	{ return next_state(IL_DVALUE, IL_TOKEN); }
file	{ return next_state(IL_DFILE, IL_TOKEN); }
nop	{ return next_state(IL_IPO_NOP, -1); }
eol	{ return next_state(IL_IPO_EOL, -1); }
rr	{ return next_state(IL_IPO_RR, -1);  }
zsu	{ return next_state(IL_IPO_ZSU, -1); }
mtup	{ return next_state(IL_IPO_MTUP, -1); }
mtur	{ return next_state(IL_IPO_MTUR, -1); }
encode	{ return next_state(IL_IPO_ENCODE, -1); }
ts	{ return next_state(IL_IPO_TS, -1); }
tr	{ return next_state(IL_IPO_TR, -1); }
sec	{ return next_state(IL_IPO_SEC, -1); }
secclass	{ return next_state(IL_IPO_SECCLASS, IL_TOKEN); }
lsrr	{ return next_state(IL_IPO_LSRR, -1); }
esec	{ return next_state(IL_IPO_ESEC, -1); }
cipso	{ return next_state(IL_IPO_CIPSO, -1); }
satid	{ return next_state(IL_IPO_SATID, -1); }
ssrr	{ return next_state(IL_IPO_SSRR, -1); }
addext	{ return next_state(IL_IPO_ADDEXT, -1); }
visa	{ return next_state(IL_IPO_VISA, -1); }
imitd	{ return next_state(IL_IPO_IMITD, -1); }
eip	{ return next_state(IL_IPO_EIP, -1); }
finn	{ return next_state(IL_IPO_FINN, -1); }
mss	{ return next_state(IL_TCPO_MSS, IL_TOKEN); }
wscale	{ return next_state(IL_TCPO_MSS, IL_TOKEN); }
reserv-4	{ return next_state(IL_IPS_RESERV4, -1); }
topsecret	{ return next_state(IL_IPS_TOPSECRET, -1); }
secret	{ return next_state(IL_IPS_SECRET, -1); }
reserv-3	{ return next_state(IL_IPS_RESERV3, -1); }
confid	{ return next_state(IL_IPS_CONFID, -1); }
unclass	{ return next_state(IL_IPS_UNCLASS, -1); }
reserv-2	{ return next_state(IL_IPS_RESERV2, -1); }
reserv-1	{ return next_state(IL_IPS_RESERV1, -1); }
\{	{ push_proto(); return next_item(IL_LBRACE); }
\}	{ pop_proto(); return next_item(IL_RBRACE); }
\.	{ return next_item(IL_DOT); }
;	{ return next_item(IL_SEMICOLON); }
[0-9]+	{ return next_item(IL_NUMBER); }
[0-9a-fA-F]	{ return next_item(IL_HEXDIGIT); }
:	{ return next_item(IL_COLON); }
#[^\n]*	{ return next_item(IL_COMMENT); }
[^ {}\n\t;]*	{ return next_item(IL_TOKEN); }
\"[^\"]*\"	{ return next_item(IL_TOKEN); }
%%
void push_proto()
{
	numpr++;
	if (!prstack)
		prstack = (int *)malloc(sizeof(int));
	else
		prstack = (int *)realloc((char *)prstack, numpr * sizeof(int));
	prstack[numpr - 1] = oldproto;
}


void pop_proto()
{
	numpr--;
	proto = prstack[numpr];
	if (!numpr) {
		free(prstack);
		prstack = NULL;
		return;
	}
	prstack = (int *)realloc((char *)prstack, numpr * sizeof(int));
}


int save_token()
{
	static char *buf = NULL;

	if (buf && (buf == yylval.str))
		free(buf);
	buf = yylval.str = strdup(yytext);
	return IL_TOKEN;
}


int next_item(nstate)
int nstate;
{
	if (next == IL_TOKEN) {
		next = -1;
		return save_token();
	}
	next = -1;
	if (nstate == IL_NUMBER)
		yylval.num = atoi(yytext);
	token++;
	return nstate;
}


int next_state(nstate, fornext)
int nstate, fornext;
{
	token++;

	if (next == IL_TOKEN) {
		next = -1;
		return save_token();
	}

	next = fornext;

	switch (nstate)
	{
	case IL_IPV4 :
	case IL_TCP :
	case IL_UDP :
	case IL_ICMP :
	case IL_DATA :
	case IL_INTERFACE :
	case IL_ARP :
		oldproto = proto;
		proto = nstate;
		break;
	case IL_SUM :
		if (proto == IL_IPV4)
			nstate = IL_V4SUM;
		else if (proto == IL_TCP)
			nstate = IL_TCPSUM;
		else if (proto == IL_UDP)
			nstate = IL_UDPSUM;
		break;
	case IL_OPT :
		if (proto == IL_IPV4)
			nstate = IL_V4OPT;
		else if (proto == IL_TCP)
			nstate = IL_TCPOPT;
		break;
	case IL_IPO_NOP :
		if (proto == IL_TCP)
			nstate = IL_TCPO_NOP;
		break;
	case IL_IPO_EOL :
		if (proto == IL_TCP)
			nstate = IL_TCPO_EOL;
		break;
	case IL_IPO_TS :
		if (proto == IL_TCP)
			nstate = IL_TCPO_TS;
		break;
	case IL_OFF :
		if (proto == IL_IPV4)
			nstate = IL_V4OFF;
		else if (proto == IL_TCP)
			nstate = IL_TCPOFF;
		break;
	case IL_LEN :
		if (proto == IL_IPV4)
			nstate = IL_V4LEN;
		else if (proto == IL_UDP)
			nstate = IL_UDPLEN;
		break;
	}
	return nstate;
}


void swallow()
{
	int c = input();

	if (c == '#') {
		while ((c != '\n') && (c != EOF))
			c = input();
	}
	unput(c);
}
