
Updated fix of the synchronous detector of Grundig
Satellit 500.
August 5, 1993



Grundig Satellit 500 is known for its inferior synchronous
detector. There are two problems with it: 
1) excessive distortion, especially in the SSB mode, and 
2) its synchronous SSB mode cannot be activated via the keyboard
   and processor. 
For the excessive distortion there are two reasons: 
1) too high DC voltage at the output of the detector chip CX857
   (this may have slight effect on normal AM also), and 
2) low frequency (50-200 Hz) feedback to the VCO of the first mixer
   (this affects only SSB).
The voltage at the outputs can be corrected in two ways. The easier 
way is to connect a 24-33 kohm resistor from each output (pins 7
and 8) to ground. If you don't have the service manual, the
correct points are positive pins of electrolytic capacitors C825
and C826. These capacitors can be found next to the larger
shielded box on the RF board, on the side close to the
loudspeaker. After installing these resistors the suppression of
the unwanted sideband improved in my receiver from 14 dB to
20-26 dB, and I think the distortion is reduced too.  

The correct way to do this would be to install two omitted
components: one 1N4148 diode in place of a jumper under the metal
shield of the detector, and one 33 kohm chip resistor from 
pin 7 of the chip to ground (there is a place for it on the
board). These will have similar effect, perhaps result in
slightly better unwanted sideband suppression in SSB mode
without additional balancing (as described later). These
components are shown on the factory test circuits of the chip
and also in the article on synchronous detection by Mike Gruber
in QEX, Sept. '92, pp. 9-16.

The feedback from the audio stages to the frequency of the first
mixer oscillator can be reduced by connecting a 2000 microfarad
or larger capacitor from the AM +3.5 V to ground (pin 11 in
connector A). This reduces also the hum in synch mode, when
operating off the mains. The better way could be building a
separate better 3.5 V regulator and switch it with AM +5V.
This could improve also the operation of the synch detector with
NiCads, which seem to have a bit too low voltage now.

For switching the detector to selectable sideband synchronous
mode the pin 3 of connector C on the RF board must be grounded and
the wire from the pin 4 of connector B must be disconnected.
This can be done with a switch with two groups of contacts. This
switch will then affect only the USB and LSB mode. With the
switch activated the SSB mode will mean synchronous SSB. The
ground connection can be done via 1 kohm resistor, this avoids
problems in case of false connection, and also reduces extra
interference from the processor. The detector circuit uses the
phasing method to select one sideband, and therefore the phase
noise of local oscillators creates clearly audible background
(about 20 dB below audio). Also, the shielded oscillators
exhibit strong microphone effect, resulting in audio feedback at
higher volume. 


Some hints for opening: the best screwdriver is Pozidrive #1.
Ordinary Phillips does not fit well, and the screws are quite
tight for the first few times to unscrew. The back cover should be
lifted at the bottom side, there are plastic hooks at the top
side. The RF board can be removed completely after unscrewing
the 5 screws and unplugging all connectors. There MAY be an
extra capacitor soldered between the RF board and the shield of
the processor unit, in the vicinity of the antenna socket. It
must be then unsoldered too.
The board is manufactured using surface mount components, so
certain caution and fine tipped soldering iron is necessary.
Care must be taken also when soldering the connector wires.
These wires go directly to the microprocrssor pins, so static
and other voltage differences between the tools and the radio
should be avoided. The simplest way is to disconnect the radio
from everything during soldering. 
The procedure should be undertaken only if you are sure that
your detector is defective too. This can be determined by
viewing the suppressed sideband signal of about 500 Hz with an
oscilloscope connected to line output, it must be severely
distorted  

The unwanted sideband rejection can be further improved, but
for this the service manual, a signal source (signal generator 
or a transmitter with clean carrier) and an AC voltage meter or
oscilloscope is needed. The procedure is balancing the summing
resistors after the audio phase shift circuits. Resistors in
question are CR834/CR832 for LSB and CR833/CR831 for USB.  
The results on my receiver are following (the frequency of the
best suppression depends on actual component values in the phase
shifters and is probably different for other units):

Freq. [kHz]    USB [dB]    LSB [dB]

 0.2            15          14
 0.5            16          15
 1.0            26          24
 1.6            48          42
 2.0            36          36
 2.5            29          28
 3.0            25          24
 3.6            22          20

For proper balance CR834 was reduced by 10% and CR833 by 20%,
but I am sure this is different on each sample. The best
suppression value says also something about the distortion.

WARNING: you repeat these procedures at your own risk. Any 
         warranty will be void after these modifications.

Ylo Mets,
ylo@osiris.kbfi.ee
Institute of Chemical Physics & Biophysics,
Ravala 10
EE-0001 Tallinn,
Estonia.


