//bounded_by.tpl

/*
If you use bounding shapes around any complex objects you can speed up the
rendering. Bounding shapes tell the ray tracer that the object is totally
enclosed by a simple shape. When tracing rays, the ray is first tested
against the simple bounding shape. If it strikes the bounding shape, then
the ray is further tested against the more complicated object inside.
Otherwise the entire complex shape is skipped, which greatly speeds
rendering.

To use bounding shapes, simply include the following lines in the
declaration of your object:

            bounded_by {
                 object { ... }
            }

       An example of a Bounding Shape:

            intersection {
                sphere {<0,0,0>, 2}
                plane  {<0,1,0>, 0}
                plane  {<1,0,0>, 0}
                bounded_by {sphere {<0,0,0>, 2}}
            }
*/


                bounded_by {                   }
