/********************************************************************
Source: RESETMAP.C - RESET MAP drives & search drives.
By    : Vitek Boruvka
Date  : 6/19/90      - original source
-----------------------------------------------------------------------
Purpose:
   demonstrate how mappings may be saved and restored for critical error
   recovery.  It shows how to save all relevant information for any
   mapped drive, including ROOT mappings and local drives,
   and how to restore them.
-----------------------------------------------------------------------
03/30/93 - vb converted RESETMAP.C to Client SDK...
04/06/93 - vb - using environment routines from NIT libs to speed things up.
               These api's are linked in and modify the ROOT environment only.
04/15/93 - vb - added environment manipulation code to get env vars.
05/04/93 - vb - updated to include server name in structure.
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <direct.h>
#include <dos.h>

/*-----------------------------------------------------------------------*/

#define NWDOS

#ifdef __cplusplus
extern "C" {
#endif

#include <nwcaldef.h>
#include <nwalias.h>
#include <nwmisc.h>
#include <nwdpath.h>
#include <nwserver.h>
#include <nwconnec.h>

#ifdef __cplusplus
}
#endif

/*-----------------------------------------------------------------------*/

#define DISPLAYSAVE          1
#define DISPLAYRESET         1

#define NW_SEARCHDRIVE       1
#define MAXMAPPINGS          32

/*-----------------------------------------------------------------------*/

/* Mapping Control Structure:
** Client SDK - use full paths with server name
** NOTE: the search drive order is not respect to the mapped drive indexes.
** they are essentially independant. */

struct {
   WORD           status;            // status type: used,network,local etc
   NWCONN_HANDLE  connHandle;        // server connection Handle
   char           serverName[48];    // server name
   BYTE           isSearch;          // 0 if nonsearch drive, non-0 otherwise
   char           search[256];       // search drives
   char           rootPath[256];     // root portion or rootPath (base)
   char           relativePath[256]; // path off of the base
   } mapDrive[MAXMAPPINGS];

NWCCODE     cCode;
BYTE        drivenum;
BYTE        dirhandlenum;
BYTE        sflags;
NWCONN_ID   connHandle;
char        thePath[256];
char        tmpPath[256];
char        serverName[50];

/********************************************************************/
// ENVIRONMENT specific definitions

#undef   MK_FP
#define  MK_FP(seg, ofs)  ((void far *) (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#undef   FP_OFF
#define  FP_OFF(fp)       ((unsigned)((unsigned long)(fp)))
#undef   FP_SEG
#define  FP_SEG(fp)       ((unsigned)((unsigned long)(fp) >> 16))

WORD        maxEnvSize;      // environment Size
char far    *masterEnvPntr;  // master environment pointer

/********************************************************************/

extern  void      SaveDriveMappings(void );
extern  void      ResetDriveMappings(void );
extern  void      DisplayMappings(void );
extern  char far *_GetMasterEnvPntr(WORD *);
extern  int       GetEnvironmentVar(char *, char *);
extern  int       PutEnvironmentVar(char far *, char far *, WORD );

/****************************************************************************/

char far *_GetMasterEnvPntr(WORD *maxEnvSize)
{
   int envSeg;

   asm {
      push    si
      push    di
	  mov     ah,0xba
	  int     0x21
      mov     ax,dx
      mov     envSeg, ax
      pop     di
      pop     si
      }

	if (maxEnvSize) {
		*maxEnvSize = *(WORD far *)MK_FP(envSeg - 1, 3);

      /* Only for DOS 2.00 & greater, size is one off */

		(*maxEnvSize)--;
		*maxEnvSize <<= 4;
      }

	return ((char *)MK_FP(envSeg, 0));
//    return (MK_FP(envSeg, 0));
} // GetMasterEnvPntr

/****************************************************************************/

int GetEnvironmentVar(char *name, char *value)
{
   char far *nextVar;
   char far *envVarPntr;

   *value = NULL;

   nextVar = masterEnvPntr = _GetMasterEnvPntr(&maxEnvSize);
   if (nextVar == (char far *)NULL)
      return (-2);

   for (; *nextVar != NULL; nextVar += strlen(nextVar) + 1) {
       for (envVarPntr = name;; envVarPntr++, nextVar++) {
           if ((*envVarPntr == (char)NULL) && (*nextVar == '='))
               goto Match;
           if (*envVarPntr != *nextVar)
               break;
        } // for 
    } // for
//   free(master);
   return (0);

Match:
    _fstrcpy((char far *)value, ++nextVar);

    return((int)( _fstrlen( ++nextVar ) ));
}

/****************************************************************************/

int PutEnvironmentVar(char far *variable, char far *environment, WORD envSize)
{
   char far *envBase, far *env, far *varBase, far *name;
   WORD varLen, oldVarSize;

   varLen = _fstrlen(variable) + 1;      /* Add one for the NULL */

   env = envBase = environment;

   /* check to see if new variable will fit */

   oldVarSize = 0;

   // loop until end of environment
   while (*env != 0) {
      // Find the environment variable
      for (varBase = env, name = variable;
           *name == *env && *name != '='; name++, env++);
      // the variable already exists, figure the size. Add 1 for NULL

      if (*name == '=' && *env == '=')
         oldVarSize += _fstrlen(varBase) + 1;

      env += _fstrlen(env) + 1;
      } // while

   // Add 1 for the EXTRA NULL for end of the Environment. Return -1 if
   // not enough room

   if (envSize - (env - envBase) + oldVarSize < varLen + 1)
      return(-1);

   /* delete old variable */
   env = envBase;
   while (*env != 0) {
      // Find the environment variable
      for (varBase = env, name = variable;
           *name == *env && *name != '='; name++, env++);

      // the variable already exists, delete it

      if (*name == '=' && *env == '=') {
         env += _fstrlen(env) + 1;
         _fmemcpy(varBase, env, envSize - (env - envBase));
         env = varBase;
         }
      else
         env += _fstrlen(env) + 1;      // Add one for the NULL
      }

   // add the new variable

   if (*(_fstrchr(variable, '=') + 1) != 0) {
      _fmemcpy(env, variable, varLen);
      env[varLen] = 0;                           /* NULL terminate */
      }
   return(0);
} // PutEnvironmentVar

/********************************************************************
** saves all mapped drives, placing respective information into the
** control structure
********************************************************************/
void SaveDriveMappings()
{
   int   drv, I;
   char  *pntr, *pntr2;

   // init the mapDrive struct

   _fmemset(&mapDrive,sizeof(mapDrive),0);

   for (drv = 0; drv < MAXMAPPINGS; drv++) {
      cCode = NWGetDriveStatus(drv + 1,
                               NW_FORMAT_NETWARE,
                               &mapDrive[drv].status,
                               &mapDrive[drv].connHandle,
                               (char NWFAR *)&mapDrive[drv].rootPath[0],
                               (char NWFAR *)&mapDrive[drv].relativePath[0],
                               tmpPath);
      NWGetFileServerName(mapDrive[drv].connHandle,mapDrive[drv].serverName);
/*
      printf("\n[%d] base=%s path=%s status %x connHandle %x\n\ttmppath=",
                               drv,
                               mapDrive[drv].rootPath,
                               mapDrive[drv].relativePath,
                               (int)mapDrive[drv].status,
                               mapDrive[drv].connHandle,
                               tmpPath);
*/
      } /* for */

   // use the PATH environment variable to obtain the
   // search drive order which also includes local search paths.

   GetEnvironmentVar("PATH",thePath);

   if (thePath[0] != NULL) {
      pntr = thePath;
	  for (drv = 0; (drv < MAXMAPPINGS) &&
                    (pntr = _fstrchr(pntr,':')); drv++ ) {
         pntr2 = _fstrchr(pntr,';');
         if (pntr2)
            _fmemcpy(mapDrive[drv].search, pntr - 1, (int)(pntr2 - pntr + 1));
         else
            _fstrcpy(mapDrive[drv].search, pntr - 1);

//         printf("\nSearch: %d: - %s",drv, mapDrive[drv].search);

         *pntr = ' ';

         // mark respective drive as a search drive if it's a netware drive

         if (mapDrive[*(BYTE *)(pntr - 1) - 'A'].connHandle) {
            mapDrive[*(BYTE *)(pntr - 1) - 'A'].isSearch = 1;
            }
         } /* while */
      }
} /* SaveDriveMappings */

/********************************************************************
** Restore the the drive mappings saved in the conrol structure
********************************************************************/
void ResetDriveMappings()
{
   int drv;
   char drvl, *pntr;

   // re-map all netware drives

   for (drv = 0; drv < MAXMAPPINGS; drv++) {

      // if connection ID specified for drive, then reset it, 
      // otherwise it's a local mapping only

      switch (mapDrive[drv].status) {
         case NW_UNMAPPED_DRIVE:   // do not need to handle this one 
                  break;

         case NW_LOCAL_DRIVE:      // map local drive
//                  printf("\nDrive:  %c := maps to local drive ",
//                         'A' + (char)drv);
                  break;

         case NW_NETWORK_DRIVE:    // redirected drive
//                  printf("\nDrive:  %c := Network redirected drive...not handled",
//                         'A' + drv);
         case NW_NETWARE_DRIVE:    // netware drive
//                  printf("\nDrive:   %c: = %s\\%s \\ %s",'A' + drv,
//                         serverName, mapDrive[drv].rootPath, mapDrive[drv].relativePath);
                  cCode = NWGetConnectionHandle(mapDrive[drv].serverName,
                                                0,
                                                &mapDrive[drv].connHandle,
                                                NULL);
                  if (cCode) {
                     printf("\n\tNWGetConnectionHandle: %c: - error %x",'A'+drv,cCode);
                     break;
                     }

                  cCode = NWSetDriveBase(drv + 1,
                                         mapDrive[drv].connHandle,
                                         NULL,
                                         mapDrive[drv].rootPath,
                                         0);
                  if (cCode) {
                     printf("\n\tNWSetDriveBase: %c: - error %x",'A'+drv,cCode);
                     break;
                     }

                  // if there is a path off of the base then 'cd' to it

                  if (mapDrive[drv].relativePath[0]) {
                    sprintf(tmpPath,"%c:%s",'A' + drv, mapDrive[drv].relativePath);
                    if (chdir(tmpPath)) {
                       printf("\n\tchdir: failed - %s (%d)",tmpPath, errno);
                       }
                    }
                  break;

         case NW_LITE_DRIVE:
//                  printf("\nDrive:  %c := NWLite drive...not handled",
//                         'A' + drv);
                  break;
         } // switch
      } // for

    // now resset the search drives & create the PATH variable

   thePath[0] = NULL;
   for (drv = 0; drv < MAXMAPPINGS && mapDrive[drv].search[0]; drv++)  {
      strcat(thePath,mapDrive[drv].search);
      strcat(thePath,";");
      } /* for */

   // update the root environments

   strcpy(tmpPath,"PATH=");
   strcat(tmpPath,thePath);
   PutEnvironmentVar(tmpPath, masterEnvPntr, maxEnvSize);
} /* ResetDriveMappings */

/***********************************************************************
** Displays the mappings saved in the control structure
***********************************************************************/
void DisplayMappings()
{
   BYTE drv, drv2;

   for (drv = 0; drv < MAXMAPPINGS; drv++) {
      if (mapDrive[drv].status & NW_LOCAL_FREE_DRIVE)
         printf("\nDrive %c: local drive",drv + 'A');
      } /* for */

   printf("\n-----");

   // re-map all drives

   for (drv = 0; drv < MAXMAPPINGS; drv++) {
      if (mapDrive[drv].connHandle &&
          !mapDrive[drv].isSearch  &&
          (mapDrive[drv].status & NW_NETWARE_DRIVE)) {
         NWGetFileServerName(mapDrive[drv].connHandle, serverName);
         printf("\nDrive:  %c := %s\\%s \\ %s",'A' + drv,serverName,
                mapDrive[drv].rootPath, mapDrive[drv].relativePath);
         } // if
      } // for

   printf("\n-----");

   // display search drive mappings

   for (drv = 0; (drv < MAXMAPPINGS) && mapDrive[drv].search[0]; drv++) {
      printf("\nSearch %2d: ",drv + 1);

      // from the drive letter determine the drive index into the struct.

      drv2 = mapDrive[drv].search[0] - 'A';

      // if there is a connection Handle then it is a netware drive,
      // otherwise, it's local and treat it as such

      if (mapDrive[drv2].connHandle) {
          NWGetFileServerName(mapDrive[drv2].connHandle, serverName);

          printf("%c := %s\\%s \\", mapDrive[drv].search[0],
                 serverName, mapDrive[drv2].rootPath);
          if (mapDrive[drv2].relativePath[0])
             printf(" %s ",mapDrive[drv2].relativePath);
          }
       else
          printf("%s", mapDrive[drv].search);
      } // for
} /* DisplayMappings */

/**************************************************************************/
void main()
{
   printf("\nRESETMAP: Client SDK - Saving/Restoring mapped drives...\n");

   SaveDriveMappings();

   DisplayMappings();

   printf("\n\n<Press Key to Restore the Drives> \n\n");

   getch();
   printf("\nRestoring drive MAPpings:\n");

   ResetDriveMappings();

}  /* main */

