
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dir.h>
#include <dirent.h>
#include "msg.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define flength(x) filelength(fileno(x))

char work_path[41];
char inbound_path[41];
char outbound_path[41];
char mail_path[41];
char arc_cmnd[41];
char dearc_cmnd[41];
int  h_zone,h_net,h_node,h_point;
int  s_zone,s_net,s_node,s_point;
char h_domain[21];
char s_domain[21];
char *arc_atmark,*arc_dolmark,*dearc_atmark,*dearc_dolmark;
char tbuf[2049],fname[65];
char *months[]={"Jan","Feb","Mar","Apr","May","Jun",\
                "Jul","Aug","Sep","Oct","Nov","Dec"};

FILE *fdmsg,*fdtdx,*pktfd=(FILE *)NULL;

struct _PHDR phdr;
struct _PHDR phdr2;
struct _PMHDR pmhdr;
struct _CNMHDR cnmhdr;
struct _CNMMHDR cnmmhdr;
struct _CNMTDX cnmtdx;
struct _CFG cfg;

int archives,packets,messages,maximum,days;
int zero=0;

void UnPack(void);
void Archive(void);
void ScanMail(void);
void freadnull(FILE *,char *);
void getaddress(char *,int *,int *,int *,int *);
void MkPacket(int);
long fcopy(char *,char *);
char *stristr(char *,char *);
int  UnArchive(char *);
int  WriteMsg(char *,char *,char *,char *,char *,char *,long,\
             char *,char *,char *,\
             int,int,int,int,char *,int);
void getcfg(void);


void main()
{
   FILE *fd;
   int i,done;
   char *p,dbuf[41];
   long start,elapsed;
   float rate;
   struct find_t fb;

   getcfg();
   strcpy(arc_cmnd,cfg.archive);
   strcpy(dearc_cmnd,cfg.unarchive);
   h_zone=cfg.b_zone;
   h_net=cfg.b_net;
   h_node=cfg.b_node;
   h_point=cfg.b_point;
   strcpy(h_domain,cfg.b_domain);
   s_zone=cfg.zone;
   s_net=cfg.net;
   s_node=cfg.node;
   s_point=cfg.point;
   strcpy(s_domain,cfg.domain);
   strcpy(inbound_path,".\\RCV\\");
   strcpy(outbound_path,".\\SEND\\");
   strcpy(work_path,".\\WORK\\");
   strcpy(mail_path,".\\MAIL\\");
   maximum=cfg.maximum;
   days=cfg.days;
   arc_atmark=strchr(arc_cmnd,'@');
   arc_dolmark=strchr(arc_cmnd,'$');
   *arc_atmark++=NULL;
   *arc_dolmark++=NULL;
   dearc_atmark=strchr(dearc_cmnd,'@');
   dearc_dolmark=strchr(dearc_cmnd,'$');
   *dearc_atmark++=NULL;
   *dearc_dolmark++=NULL;
   if(arc_atmark==(char *)NULL) {
      printf("\nMissing @ in archive command\n");
      exit(4);
   }
   if(arc_dolmark==(char *)NULL) {
      printf("\nMissing $ in archive command\n");
      exit(4);
   }
   if(dearc_atmark==(char *)NULL) {
      printf("\nMissing @ in de-archive command\n");
      exit(4);
   }
   if(dearc_dolmark==(char *)NULL) {
      printf("\nMissing $ in de-archive command\n");
      exit(4);
   }
   time(&start);
   archives=packets=messages=0;
   _setcursortype(_NOCURSOR);
   printf("\nCNToss v1.01 - (c)1993 Simon Ewins - "__DATE__" @ "__TIME__"\n");
   printf("\n InBound Archives: %s",inbound_path);
   printf("\nOutBound Archives: %s",outbound_path);
   printf("\nMessages Base Dir: %s",mail_path);
   printf("\n   Work Directory: %s",work_path);
   printf("\n         Archiver: %s",arc_cmnd);
   printf("\n      De-Archiver: %s",dearc_cmnd);
   printf("\n     BOSS Address: %d:%d/%d.%d@%s",h_zone,h_net,h_node,h_point,h_domain);
   printf("\n     Your Address: %d:%d/%d.%d@%s\n",s_zone,s_net,s_node,s_point,s_domain);

   /*-----------------11-12-93 05:48pm-----------------
    Unarchive any mail received from our BOSS.
    --------------------------------------------------*/
   archives+=UnArchive("mo?");
   archives+=UnArchive("tu?");
   archives+=UnArchive("we?");
   archives+=UnArchive("th?");
   archives+=UnArchive("fr?");
   archives+=UnArchive("sa?");
   archives+=UnArchive("su?");
   archives+=UnArchive("cnm");

   /*-----------------11-15-93 10:14pm-----------------
    Copy any raw .Pkt files to the work directory.
    --------------------------------------------------*/
   sprintf(fname,"%s*.Pkt",inbound_path);
   done=_dos_findfirst(fname,_A_NORMAL,&fb);
   while(!done) {
      sprintf(fname,"%s%s",inbound_path,fb.name);
      sprintf(dbuf,"%s%s",work_path,fb.name);
      printf("\nCopying %s to %s",fname,dbuf);
      if(fcopy(dbuf,fname)>0) {
         packets++;
         unlink(fname);
      }
      done=_dos_findnext(&fb);
   }

   /*-----------------11-12-93 05:48pm-----------------
    Toss the messages received from the .Pkt files into
    the local messages bases.
    --------------------------------------------------*/
   putchar('\n');
   UnPack();

   /*-----------------11-12-93 05:49pm-----------------
    Done Tossing.
    --------------------------------------------------*/
   elapsed=time(0L)-start;
   if(elapsed<1) elapsed=1;
   rate=(float)messages/(float)elapsed;
   printf("\n\nArchives UnPacked: %d",archives);
   printf("\n   Packets Tossed: %d",packets);
   printf("\n  Messages Tossed: %d [%5.2f/sec]\n\n",messages,rate);

   /*-----------------11-12-93 05:50pm------------------
    Now scan the message bases for any messages that are
    unsent and export them to our BOSS.
    ---------------------------------------------------*/
   time(&start);
   messages=0;
   ScanMail();

   /*-----------------11-12-93 05:51pm-----------------
    Archive any .Pkt files for our BOSS.
    --------------------------------------------------*/
   Archive();

   /*-----------------11-12-93 05:52pm-----------------
    Done Scanning.
    --------------------------------------------------*/
   elapsed=time(0L)-start;
   if(elapsed<1) elapsed=1;
   rate=(float)messages/(float)elapsed;
   printf("\n\nMessages Scanned: %d [%5.2f/sec]\n\nFinished\n",messages,rate);
   _setcursortype(_NORMALCURSOR);
}


void UnPack(void)
{
   int i,done,len;
   int ozone,onet,onode,opoint;
   FILE *fd;
   char sname[65];
   char fnme[65];
   char date[20];
   char to[36];
   char from[36];
   char subj[72];
   char tag[36];
   char odomain[21];
   char area[9];
   unsigned bufsize=65535;
   char *p,*text,*ctrl,*snby,*orig,*msgbuf=(char *)NULL;
   struct find_t fb;
   struct date dt;
   struct time tm;

   while(msgbuf==(char *)NULL && bufsize>10000) {
      msgbuf=(char *)malloc(bufsize);
      if(msgbuf==(char *)NULL)
         bufsize-=1024;
   }
   if(bufsize<10000 && msgbuf==(char *)NULL) {
      printf("\nCan't allocate message buffer memory");
      return;
   }
   sprintf(sname,"%s*.Pkt",work_path);
   done=_dos_findfirst(sname,_A_NORMAL,&fb);
   while(!done) {
      sprintf(fnme,"%s%s",work_path,fb.name);
      fd=fopen(fnme,"rb");
      if(fd) {
         printf("\n%s\n",fnme);
         packets++;
         fread(&phdr,sizeof(phdr),1,fd);
         fread(&pmhdr,sizeof(pmhdr),1,fd);
         while(!feof(fd)) {
            messages++;
            freadnull(fd,date);
            freadnull(fd,to);
            freadnull(fd,from);
            freadnull(fd,subj);
            freadnull(fd,msgbuf);
            while(!strnicmp(subj,"Re: ",4)) memmove(subj,&subj[4],strlen(subj)+1);
            p=msgbuf;
            len=strlen(msgbuf);
            while(*p) {   /* Strip linefeeds and soft cr's FAST */
               if(*p=='\x8d' || *p=='\n') {
                  memmove(p,&p[1],len-(unsigned int)((long)p-(long)msgbuf));
                  len--;
                  if(!len) break;
                  continue;
               }
               p++;
            }

            /*-----------------10-29-93 03:50pm-----------------
             Extract the FidoNet area tag name. If one not found
             then assume that it is a NetMail message.
             --------------------------------------------------*/
            text=msgbuf;
            if(!strncmp(text,"AREA:",5)) {
               text+=5;
               i=0;
               while(*text) {
                  if(*text=='\r') break;
                  tag[i++]=*text++;
               }
               tag[i]=NULL;
            } else {
               strcpy(tag,"NETMAIL");
            }
            strncpy(area,tag,8);
            area[8]=NULL;

            /*-----------------11-13-93 10:38am-----------------
             Default originating address to BOSS.
             --------------------------------------------------*/
            ozone=phdr.fdozone;
            onet=phdr.onet;
            onode=phdr.onode;
            opoint=phdr.fdopoint;
            odomain[0]=NULL;          /* not supported yet */

            /*-----------------10-29-93 03:51pm-----------------
             Skip any carriage-returns before the control lines.
             --------------------------------------------------*/
            while(*text=='\r' && *text)
               text++;

            /*-----------------10-29-93 03:52pm-----------------
             Determine the end of the control data lines.
             --------------------------------------------------*/
            p=ctrl=text;
            while(*p=='\01' && *p) {
               while(*p) {
                  if(*p=='\r') break;
                  p++;
               }
               p++;
            }
            text=p;
            if(ctrl!=text)
               *(p-1)=NULL;         /* terminate control string */
            else
               ctrl=(char *)&zero;  /* no control lines */

            /*-----------------11-03-93 02:11pm-----------------
             Determine start of SEEN-BY: (then ^APATH:) lines.
             --------------------------------------------------*/
            snby=strstr(text,"SEEN-BY:");
            if(snby) {
               *(snby-1)=NULL;
            } else {
               snby=strstr(text,"\01PATH");
               if(snby) {
                  *(snby-1)=NULL;
               } else {                      /* might be routed NetMail */
                  snby=stristr(text,"\01Via");
                  if(snby) {
                     *(snby-1)=NULL;
                  } else {
                     snby=(char *)&zero;  /* no trailer lines */
                  }
               }
            }

            /*-----------------10-29-93 03:51pm-----------------
             Strip leading carriage-returns from message body.
             --------------------------------------------------*/
            while(*text=='\r' && *text)
               text++;
            printf("\r%-8.8s %5d",area,messages);
            if(strlen(text)==0)
               text=(char *)&zero;  /* no message text */

            /*-----------------11-13-93 10:41am-----------------
             Try and determine the originating address using the
             ^MSGID: in the control block first, then the ^APATH
             trailer next or the ^Via string last (if NetMail).
             --------------------------------------------------*/
            orig=stristr(ctrl,"\01MSGID:");
            if(orig) {
               p=strchr(orig,' ');
               getaddress(p,&ozone,&onet,&onode,&opoint);
            } else {
               orig=stristr(snby,"\01PATH:");
               if(orig) {
                  p=strchr(orig,' ');
                  getaddress(p,&ozone,&onet,&onode,&opoint);
               } else {
                  orig=stristr(snby,"\01Via");
                  if(orig) {
                     p=strchr(orig,':');
                     getaddress(p,&ozone,&onet,&onode,&opoint);
                  }
               }
            }

            /*-----------------10-29-93 03:53pm-----------------
             Now convert the date to unix and the write the
             message to its appropriate file.
             --------------------------------------------------*/
            if(isalpha(date[0])) {
               memcpy(date,&date[4],16); /* this is for SEAdog format */
               strcat(date,":00");
            }
            dt.da_day=atoi(date);
            dt.da_year=atoi(&date[7]);
            dt.da_year+=dt.da_year<90?2000:1900;
            dt.da_mon=1;
            for(i=0;i<12;i++) {
               if(!strnicmp(&date[3],months[i],3)) {
                  dt.da_mon=i+1;
                  break;
               }
            }
            tm.ti_hour=atoi(&date[11]);
            tm.ti_min=atoi(&date[14]);
            tm.ti_sec=atoi(&date[17]);
            tm.ti_hund=0;
            WriteMsg(mail_path,area,tag,to,from,subj,dostounix(&dt,&tm),\
                     ctrl,text,snby,ozone,onet,onode,opoint,odomain,TRUE);

            /*-----------------10-29-93 03:55pm-----------------
             Get the next message.
             --------------------------------------------------*/
            fread(&pmhdr,sizeof(pmhdr),1,fd);
         }
         fclose(fd);

         /*-----------------11-12-93 05:59pm-------------------
          Kill the current packet now that we are done with it.
          ----------------------------------------------------*/
         unlink(fnme);
      }
      done=_dos_findnext(&fb);
   }
   free(msgbuf);
}


void getaddress(char *pp,int *ozone,int *onet,int *onode,int *opoint)
{
   char *tp,*p;

   if(pp==(char *)NULL) return;
   p=strdup(pp);
   if(*p==' ') p++;
   if(*p==':') p--;
   tp=strchr(p,':');
   if(tp) {
      *tp=NULL;
      *ozone=atoi(p);
      p=tp+1;
   }
   tp=strchr(p,'/');
   if(tp) {
      *tp=NULL;
      *onet=atoi(p);
      p=tp+1;
   }
   *onode=atoi(p);
   tp=strchr(p,'.');
   if(tp) {
      *tp++=NULL;
      *opoint=atoi(tp);
   }
}


int UnArchive(char *ext)
{
   int done,count=0;
   char buf[65],sname[65];
   struct find_t fb;

   sprintf(sname,"%s*.%s",inbound_path,ext);
   done=_dos_findfirst(sname,_A_NORMAL,&fb);
   while(!done) {
      sprintf(buf,"%s%s%s%s%s",\
                  dearc_cmnd,\
                  inbound_path,\
                  fb.name,\
                  dearc_atmark,\
                  work_path);
      if(system(buf)==0) {
         sprintf(sname,"%s%s",inbound_path,fb.name);
         unlink(sname);
         count++;
      }
      done=_dos_findnext(&fb);
   }
   return(count);
}


void Archive(void)
{
   char fnme[65];
   char snme[65];
   char cmnd[65];
   char ext[4];
   struct find_t fb;
   struct tm *tb;
   time_t ctme;
   int done;

   ctme=time(NULL);
   tb=localtime(&ctme);
   sprintf(fnme,"%s*.Pkt",outbound_path);
   done=_dos_findfirst(fnme,_A_NORMAL,&fb);
   while(!done) {
      sprintf(snme,"%s%s",outbound_path,fb.name);
      switch(tb->tm_wday) {
         case 0: strcpy(ext,"su0"); break;
         case 1: strcpy(ext,"mo0"); break;
         case 2: strcpy(ext,"tu0"); break;
         case 3: strcpy(ext,"we0"); break;
         case 4: strcpy(ext,"th0"); break;
         case 5: strcpy(ext,"fr0"); break;
         case 6: strcpy(ext,"sa0"); break;
      }
      sprintf(cmnd,"%s%s%02x%02x%02x%02x.%s%s%s%s%s",\
                     arc_cmnd,\
                     outbound_path,\
                     tb->tm_mon,\
                     tb->tm_mday,\
                     tb->tm_hour,\
                     tb->tm_min,\
                     ext,\
                     arc_atmark,\
                     outbound_path,\
                     fb.name,\
                     arc_dolmark);
      if(system(cmnd)==0) unlink(snme);
      done=_dos_findnext(&fb);
   }
}


void freadnull(FILE *fd,char *buf)
{
   char *p=buf;

   while(!feof(fd)) {
      *p=(char)fgetc(fd);
      if(*p==NULL) return;
      p++;
   }
}


int WriteMsg(char *path,\
             char *name,\
             char *tag,\
             char *to,\
             char *from,\
             char *subj,\
             long dt,\
             char *ctrl,\
             char *text,\
             char *snby,\
             int ozn,\
             int ont,\
             int ond,\
             int opt,\
             char *odm,\
             int sent)
{
   char fnme[65];
   char xnme[65];

   subj[35]=NULL;
   sprintf(fnme,"%s%s.Msg",path,name);
   sprintf(xnme,"%s%s.To",path,name);
   fdmsg=fopen(fnme,"r+b");
   if(!fdmsg) {
      fdmsg=fopen(fnme,"w+b");
      if(!fdmsg) return(FALSE);
      fdtdx=fopen(xnme,"w+b");
      if(!fdtdx) {
         fclose(fdmsg);
         unlink(fnme);
         return(FALSE);
      }
      fclose(fdtdx);
      memset(&cnmhdr,0,sizeof(cnmhdr));   /* clear out the header buffer */
      time(&cnmhdr.update);
      cnmhdr.messages=0;
      cnmhdr.lastread=0;
      cnmhdr.maximum=maximum;
      cnmhdr.days=days;
      strcpy(cnmhdr.tag,tag);
      cnmhdr.startmark=0L;                /* MUST be set to and left at 0 */
      fwrite(&cnmhdr,sizeof(cnmhdr),1,fdmsg);
      fseek(fdmsg,0L,SEEK_SET);
   }
   fdtdx=fopen(xnme,"r+b");

   fread(&cnmhdr,sizeof(cnmhdr),1,fdmsg); /* read the message file header */
   time(&cnmhdr.update);                  /* set the last update time */
   cnmhdr.messages++;                     /* bump the number of messages */

   memset(&cnmmhdr,0,sizeof(cnmmhdr));    /* clear out the message header */
   memset(&cnmtdx,0,sizeof(cnmtdx));      /* clear out the TO index buffer */

   cnmtdx.offset=flength(fdmsg);          /* set offset for the new message */
   strcpy(cnmtdx.to,to);                  /* set who this message is TO */

   /*-----------------11-02-93 11:39pm-----------------
    Now fill in the rest of the message header info and
    then write the control info and the message text
    followed by the offset as stored in cnmtdx.offset.
    --------------------------------------------------*/
   strcpy(cnmmhdr.from,from);
   strcpy(cnmmhdr.to,to);
   strcpy(cnmmhdr.subj,subj);
   cnmmhdr.wdate=dt;
   time(&cnmmhdr.adate);
   cnmmhdr.ozone=ozn;
   cnmmhdr.onet=ont;
   cnmmhdr.onode=ond;
   cnmmhdr.opoint=opt;
   strcpy(cnmmhdr.odomain,odm);
   cnmmhdr.dzone=s_zone;
   cnmmhdr.dnet=s_net;
   cnmmhdr.dnode=s_node;
   cnmmhdr.dpoint=s_point;
   strcpy(cnmmhdr.ddomain,s_domain);
   cnmmhdr.replyto=0;
   cnmmhdr.nextreply=0;
   cnmmhdr.control=strlen(ctrl)+1;     /* +1 in these three is for the NULL */
   cnmmhdr.length=strlen(text)+1;
   cnmmhdr.trailer=strlen(snby)+1;
   cnmmhdr.sent=sent;

   /*-----------------11-02-93 11:33pm-----------------
    Now we can write all the new data to disk.
    --------------------------------------------------*/
   fseek(fdmsg,0L,SEEK_END);                    /* end of message file */
   fwrite(&cnmmhdr,sizeof(cnmmhdr),1,fdmsg);    /* header */
   fwrite(ctrl,cnmmhdr.control,1,fdmsg);        /* control data */
   fwrite(text,cnmmhdr.length,1,fdmsg);         /* message text */
   fwrite(snby,cnmmhdr.trailer,1,fdmsg);        /* trailer */
   fwrite(&cnmtdx.offset,sizeof(long),1,fdmsg); /* header start position */
   fseek(fdmsg,0L,SEEK_SET);                    /* start of message file */
   fwrite(&cnmhdr,sizeof(cnmhdr),1,fdmsg);      /* updated header data */
   fclose(fdmsg);
   fseek(fdtdx,0L,SEEK_END);                    /* end of to index */
   fwrite(&cnmtdx,sizeof(cnmtdx),1,fdtdx);      /* updated to index data */
   fclose(fdtdx);
   return(TRUE);
}


void MkPacket(int net)
{
   char fnme[65];
   struct tm *tme;
   time_t ct;

   /*-----------------11-13-93 06:49pm-----------------
    If not NetMail and we already have an open packet
    then just return.
    --------------------------------------------------*/
   if(!net && pktfd) return;

   /*-----------------11-13-93 06:50pm-----------------
    If NetMail and we have an open packet then close it
    and create a new one.
    --------------------------------------------------*/
   if(net && pktfd) {
      fwrite(&zero,sizeof(int),1,pktfd);
      fclose(pktfd);
      pktfd=(FILE *)NULL;
   }

   /*-----------------11-13-93 06:49pm-----------------
    Delay enough to guarantee a unique file name for
    the packet in case we had one before and NetMail
    has interrupted it or in case this is NetMail and
    we were working on one previously.
    --------------------------------------------------*/
   delay(1100);

   /*-----------------11-13-93 06:54pm-----------------
    Create a packet.
    --------------------------------------------------*/
   time(&ct);
   tme=localtime(&ct);
   sprintf(fnme,"%s%02x%02x%02x%02x.Pkt",outbound_path,\
      tme->tm_mday,tme->tm_hour,tme->tm_min,tme->tm_sec);
   pktfd=fopen(fnme,"w+b");
   if(!pktfd) return;
   memcpy(&phdr2,&phdr,sizeof(phdr2));
   phdr2.password[0]=NULL;
   fwrite(&phdr2,sizeof(phdr2),1,pktfd);
}


void ScanMail(void)
{
   char fnme[65];
   char tag[36];
   char sdate[26];
   char *p;
   char *MMM=&sdate[4];
   char *dd=&sdate[8];
   char *hh=&sdate[11];
   char *YY=&sdate[22];
   FILE *tfd;
   struct find_t fb;
   struct tm *tb;
   time_t ctme;
   long opos;
   int done,i,c,net;

   pktfd=(FILE *)NULL;
   ctme=time(NULL);
   tb=localtime(&ctme);
   phdr.onode=s_node;
   phdr.dnode=h_node;
   phdr.year=tb->tm_year+1900;
   phdr.month=tb->tm_mon;   /* month # -1 */
   phdr.day=tb->tm_mday;
   phdr.hour=tb->tm_hour;
   phdr.minute=tb->tm_min;
   phdr.second=tb->tm_sec;
   phdr.baudrate=0;        /* always set to 0 */
   phdr.packet_ver=2;      /* set to 2 for this version */
   phdr.onet=s_net;
   phdr.dnet=h_net;
   phdr.product=0;         /* product code is 0 */
   phdr.password[0]=NULL;  /* for pickup (set to all 0's) */
   phdr.qmozone=s_zone;    /* as per QMail */
   phdr.qmdzone=h_zone;    /* as per QMail */
   phdr.BLANK=0;           /* extra unused bytes */
   phdr.cwvalid=256;       /* byte-swapped CapabilityWord (make 256) */
   phdr.prodcode=0;        /* product code (make 0) */
   phdr.cw=1;              /* CapabilityWord (make 1) */
   phdr.fdozone=s_zone;    /* as per FD */
   phdr.fddzone=h_zone;    /* as per FD */
   phdr.fdopoint=s_point;  /* as per FD */
   phdr.fddpoint=h_point;  /* as per FD */
   phdr.proddata=0L;       /* 4 bytes - product specific data */
   sprintf(fnme,"%s*.Msg",mail_path);
   done=_dos_findfirst(fnme,_A_NORMAL,&fb);
   while(!done) {
      sprintf(fnme,"%s%s",mail_path,fb.name);
      tfd=fopen(fnme,"r+b");
      if(tfd) {
         printf("\nScanning %12s:",fb.name);
         fread(&cnmhdr,sizeof(cnmhdr),1,tfd);
         opos=ftell(tfd);
         fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
         net=!strcmp(cnmhdr.tag,"NETMAIL")?TRUE:FALSE;
         while(!feof(tfd)) {
            if(!cnmmhdr.deleted && !cnmmhdr.sent) {
               MkPacket(net);
               if(pktfd) {
                  pmhdr.type=2;       /* message type (use 2) */
                  pmhdr.onode=s_node;
                  pmhdr.dnode=net?cnmmhdr.dnode:h_node;
                  pmhdr.onet=s_net;
                  pmhdr.dnet=net?cnmmhdr.dnet:h_net;
                  pmhdr.attribute=0;
                  pmhdr.cost=0;
                  fwrite(&pmhdr,sizeof(pmhdr),1,pktfd);
                  strcpy(sdate,ctime(&cnmmhdr.wdate));
                  sdate[24]=NULL;
                  sdate[19]=NULL;
                  sdate[10]=NULL;
                  sdate[7]=NULL;
                  sdate[3]=NULL;
                  fprintf(pktfd,"%s %s %s  %s",dd,MMM,YY,hh);
                  fputc('\0',pktfd);
                  fprintf(pktfd,"%s",cnmmhdr.to);
                  fputc('\0',pktfd);
                  fprintf(pktfd,"%s",cnmmhdr.from);
                  fputc('\0',pktfd);
                  fprintf(pktfd,"%s",cnmmhdr.subj);
                  fputc('\0',pktfd);
                  if(!net) {
                     fprintf(pktfd,"AREA:%s\r",cnmhdr.tag);
                     fprintf(pktfd,"\01MSGID: %d:%d/%d.%d %08lx\r",\
                        s_zone,s_net,s_node,s_point,time(0L));
                     fprintf(pktfd,"\01PID: CNMsg System\r");
                  } else {
                     fprintf(pktfd,"\01INTL %d:%d/%d %d:%d/%d\r",\
                        cnmmhdr.dzone,cnmmhdr.dnet,cnmmhdr.dnode,\
                        cnmmhdr.ozone,cnmmhdr.onet,cnmmhdr.onode);
                     if(cnmmhdr.dpoint)
                        fprintf(pktfd,"\01TOPT %d\r",cnmmhdr.dpoint);
                     if(cnmmhdr.opoint)
                        fprintf(pktfd,"\01FMPT %d\r",cnmmhdr.opoint);
                  }
                  fseek(tfd,(long)cnmmhdr.control,SEEK_CUR);
                  for(i=0;i<cnmmhdr.length-1;i++) {
                     c=fgetc(tfd);
                     fputc(c,pktfd);
                  }
                  if(!net)
                     fprintf(pktfd,"\nSEEN-BY: %d/%d\r\01PATH: %d/%d\r",\
                        s_net,s_node,s_net,s_node);
                  fputc('\0',pktfd);
                  messages++;
                  printf("\rScanning %12s: %d",fb.name,messages);
                  cnmmhdr.sent=TRUE;
                  fseek(tfd,opos,SEEK_SET);
                  fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                  if(net) {
                     fwrite(&zero,sizeof(int),1,pktfd);
                     fclose(pktfd);
                     pktfd=(FILE *)NULL;
                  }
               }
            }
            fseek(tfd,opos+(long)(sizeof(cnmmhdr)+cnmmhdr.control+cnmmhdr.length+cnmmhdr.trailer+sizeof(long)),SEEK_SET);
            opos=ftell(tfd);
            fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
         }
         fclose(tfd);
      }
      done=_dos_findnext(&fb);
   }
   if(pktfd) {
      fwrite(&zero,sizeof(int),1,pktfd);
      fclose(pktfd);
      pktfd=(FILE *)NULL;
   }
   putchar('\n');
}


char *stristr(char *t,char *s)
{
   char *t1;
   char *s1;

   while(*t) {
      t1=t;
      s1=s;
      while(*s1) {
         if(toupper(*s1)!=toupper(*t))
            break;
         else {
            s1++;
            t++;
         }
      }
      if(!*s1) return t1;
      t=t1+1;
   }
   return NULL;
}


long fcopy(char *dest,char *source)
{
   #define BUFFER_SIZE 1024
   FILE   *d,*s;
   char   *buffer;
   size_t incount;
   long   totcount=0L;

   s=fopen(source,"rb");
   if(s==NULL) return -1L;
   d=fopen(dest,"wb");
   if(d == NULL) {
      fclose(s);
      return -1L;
   }
   buffer=malloc(BUFFER_SIZE);
   if(buffer==NULL) {
      fclose(s);
      fclose(d);
      return -1L;
   }
   incount=fread(buffer,sizeof(char),BUFFER_SIZE,s);
   while(!feof(s)) {
      totcount+=(long)incount;
      fwrite(buffer,sizeof(char),incount,d);
      incount=fread(buffer,sizeof(char),BUFFER_SIZE, s);
   }
   totcount+=(long)incount;
   fwrite(buffer,sizeof(char),incount,d);
   free(buffer);
   fclose(s);
   fclose(d);
   return totcount;
}


void getcfg()
{
   static char *errmsg=" subdirectory not found\n";
   FILE *fd;
   DIR *d;

   fd=fopen("CNMsg.Cfg","rb");
   if(!fd) {
      printf("\nUnable to open CNMsg.Cfg");
      exit(1);
   }
   fread(&cfg,sizeof(cfg),1,fd);
   fclose(fd);
   d=opendir(".\\MAIL");
   if(!d) {
      printf("\nMAIL%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\SEND");
   if(!d) {
      printf("\nSEND%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\RCV");
   if(!d) {
      printf("\nRCV%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\WORK");
   if(!d) {
      printf("\nWORK%s",errmsg);
      exit(1);
   }
   closedir(d);
}


