
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dir.h>
#include <dirent.h>
#include "msg.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

struct _CNMHDR cnmhdr;
struct _CNMMHDR cnmmhdr;
struct _CNMMHDR cbuf;
struct _CNMTDX cnmtdx;
struct _CFG cfg;

typedef struct _SUBJ {
   char subj[36];
   long position;
   int  record;
} SUBJ;

SUBJ *s[5000];
int maxmsgs;
int cmpsubj(const void *,const void *);
void getcfg(void);


void main()
{
   char fnme[65];
   FILE *tfd;
   struct find_t fb;
   char *p;
   int done,i,crecord=0;

   getcfg();

   /*-----------------11-07-93 11:36pm------------------
    initialize an array of pointers to the subject index
    structure.
    ---------------------------------------------------*/
   for(maxmsgs=0;maxmsgs<5000;maxmsgs++) {
      s[maxmsgs]=(SUBJ *)malloc(sizeof(SUBJ));
      if(s[maxmsgs]==(SUBJ *)NULL) break;
   }
   _setcursortype(_NOCURSOR);
   printf("\nCNLink v1.01 - (c)1993 Simon Ewins - "__DATE__" @ "__TIME__"\n");
   sprintf(fnme,"%s*.Msg",".\\MAIL\\");

   /*-----------------11-07-93 11:38pm----------------
    Search the mail directory for each instance of the
    .Msg file type.
    -------------------------------------------------*/
   done=_dos_findfirst(fnme,_A_NORMAL,&fb);
   while(!done) {
      sprintf(fnme,"%s%s",".\\MAIL\\",fb.name);
      tfd=fopen(fnme,"r+b");
      if(tfd) {
         printf("\nLinking %12s: ",fb.name);

         /*-----------------11-07-93 11:38pm------------------
          Get the header for this message file and check for
          the number of messages being over the size of our
          array (array could be made larger than 5000, limited
          only by memory available.
          ---------------------------------------------------*/
         fread(&cnmhdr,sizeof(cnmhdr),1,tfd);
         if(cnmhdr.messages>maxmsgs) {
            printf(" [exceeds 5000 link maximum]");
         } else {
            fseek(tfd,0L,SEEK_CUR);       /* C idiosyncracy */
            crecord=0;                    /* initialize the counter */
            printf("SCAN\b\b\b\b");

            /*-----------------11-07-93 11:42pm-------------------
             Read a message header to get things rolling and keep
             reading until end-of-file reached. Add the needed
             information from the header to the next array element
             holding data for subject indexing.
             ----------------------------------------------------*/
            fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
            while(!feof(tfd)) {
               strcpy(s[crecord]->subj,cnmmhdr.subj);
               s[crecord]->record=crecord+1;
               s[crecord++]->position=ftell(tfd)-(long)sizeof(cnmmhdr);

               /*-----------------11-18-93 11:53pm-----------------
                Clear out the old links.
                --------------------------------------------------*/
               cnmmhdr.replyto=cnmmhdr.nextreply=0;
               fseek(tfd,-(long)sizeof(cnmmhdr),SEEK_CUR);
               fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);

               /*-----------------11-18-93 11:53pm-----------------
                Now jump to next message header.
                --------------------------------------------------*/
               fseek(tfd,(long)(cnmmhdr.control+cnmmhdr.length+cnmmhdr.trailer+sizeof(long)),SEEK_CUR);
               fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
            }

            /*-----------------11-07-93 11:43pm-------------------
             Reposition to first message header after file header.
             ----------------------------------------------------*/
            fseek(tfd,(long)sizeof(cnmmhdr),SEEK_SET);

            /*-----------------11-07-93 11:44pm-----------------
             Sort the subject data based on the subject.
             --------------------------------------------------*/
            printf("SORT\b\b\b\b");
            qsort(s,crecord,sizeof(SUBJ *),cmpsubj);

            /*-----------------11-07-93 11:44pm-------------------
             Read through the array and check for a common subject
             to the current message and the next one.
             ----------------------------------------------------*/
            for(i=0;i<crecord;i++) {
               printf("\rLinking %12s: %5d",fb.name,i+1);
               if(!stricmp(s[i+1]->subj,s[i]->subj)) {

                  /*-----------------11-07-93 11:45pm--------------------
                   Subjects match so get the header for the next message.
                   -----------------------------------------------------*/
                  fseek(tfd,s[i+1]->position,SEEK_SET);
                  fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);

                  /*-----------------11-07-93 11:46pm------------------
                   Set the replyto field in the next message to the
                   current message record number and rewrite the header
                   ---------------------------------------------------*/
                  cnmmhdr.replyto=s[i]->record;
                  fseek(tfd,s[i+1]->position,SEEK_SET);
                  fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);

                  /*-----------------11-07-93 11:47pm-----------------
                   Now read the header for the current message and set
                   the nextreply field to the next message's record
                   number and rewrite the message.
                   --------------------------------------------------*/
                  fseek(tfd,s[i]->position,SEEK_SET);
                  fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                  cnmmhdr.nextreply=s[i+1]->record;
                  fseek(tfd,s[i]->position,SEEK_SET);
                  fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
               }
            }
         }
         fclose(tfd);
      }
      done=_dos_findnext(&fb);
   }
   putchar('\n');
   _setcursortype(_NORMALCURSOR);
}


int cmpsubj(const void *a,const void *b)
{
   const SUBJ *aa=*(const void **)a;
   const SUBJ *bb=*(const void **)b;
   char testa[41];
   char testb[41];

   sprintf(testa,"%s%05d",aa->subj,aa->record);
   sprintf(testb,"%s%05d",bb->subj,bb->record);
   return(stricmp(testa,testb));
/*
   if(i<0) return(1);
   if(i>0) return(-1);
   return(0);

   return(stricmp(aa->subj,bb->subj));
*/
}


void getcfg()
{
   static char *errmsg=" subdirectory not found\n";
   FILE *fd;
   DIR *d;

   fd=fopen("CNMsg.Cfg","rb");
   if(!fd) {
      printf("\nUnable to open CNMsg.Cfg");
      exit(1);
   }
   fread(&cfg,sizeof(cfg),1,fd);
   fclose(fd);
   d=opendir(".\\MAIL");
   if(!d) {
      printf("\nMAIL%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\SEND");
   if(!d) {
      printf("\nSEND%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\RCV");
   if(!d) {
      printf("\nRCV%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\WORK");
   if(!d) {
      printf("\nWORK%s",errmsg);
      exit(1);
   }
   closedir(d);
}


