
#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <io.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <dir.h>
#include <dirent.h>
#include <swap.h>    /* SWAP300 - Copyright (c)1990 - by Marty Del Vecchio */
#include "msg.h"     /* is required if you wish to re-compile this code. */

#define TRUE 1
#define FALSE 0

#define MESSAGE    7,2
#define REPLYTO   15,2
#define NEXTREPLY 25,2
#define DELETED   43,2
#define SENT      56,2
#define DATE       7,3
#define FROM       7,4
#define ORIG      41,4
#define TO         7,5
#define DEST      41,5
#define SUBJECT    7,6
#define TEXT         8

#define MAXDIMS  1              /* Defines the maximum number of dimensions */
#define MAXSIZE  ((size_t) -1L) /* Maximum size of array */

#define F1        187
#define F2        188
#define F3        189
#define F4        190
#define F5        191
#define F6        192
#define F7        193
#define F8        194
#define F9        195
#define F10       196
#define HOME      199
#define UP        200
#define PGUP      201
#define BWD       203
#define FWD       205
#define END       207
#define DN        208
#define PGDN      209
#define INS       210
#define DEL       211
#define CTRL_HOME 247
#define CTRL_BWD  243
#define CTRL_FWD  244
#define CTRL_END  245
#define ESCAPE     27
#define ENTER      13
#define TAB         9
#define BKSPACE     8

struct _CNMTDX  cnmtdx;
struct _CNMHDR  cnmhdr;
struct _CNMMHDR cnmmhdr;
struct _CNMMHDR newhdr;
struct _CFG cfg;

typedef struct _AREAS {
   char   area[9];            /* area name */
   int    messages;           /* number of messages */
   int    lastread;           /* last message number read */
   long   update;             /* last date file updated */
} AREA;

char *data=(char *)NULL;
char *message[10000];
int  message_lines=0;
char *control[100];
int  control_lines=0;
char *trailer[100];
int  trailer_lines=0;

char fnme[65];
char xnme[65];
char path[36];
char sfind[23];
char uname[36];
char origin[51];
int  s_zone,s_net,s_node,s_point;
char s_domain[21];
int  h_zone,h_net,h_node,h_point;
char h_domain[21];
char editor[21];
char edit[31];
int  areacount=0,carea=0,crecord=0;
int  swap_return;                      /* used by swap routine */
unsigned char exec_return;             /* ditto */
unsigned char *comspec;                /* ditto */
unsigned int dos_ptr;                  /* ditto */
int net=FALSE;
AREA *areas;
FILE *tfd;
FILE *xfd;

char *stristr(char *,char *);
char *tabs(char *);
void select_area(void);
void list_messages(void);
void *amalloc(int,void *,int dims,...);
void hilite(int,int,int,int,unsigned char);
void scroll(int,int,int,int,int,int,int,int);
void help(void);
void shoheader(void);
void getheader(int);
void msgscreen(void);
void close_files(void);
void mbox(char *);
void dbox(char *,char *,int,int);
void box(int,int,int);
void linecolour(int);
void disp_array(char **,int);
void strppr(char *);
void WriteMsg(int,char *);
void getcfg(void);
int  fill_array(char **,int,int,char *);
int  cmparea(const void *,const void *);
int  get_record(int);
int  fmtin(char *,char *);


void main()
{
   int done,i,ch,topline,cline,bookmark=0,cfind=FALSE;
   char *p,tbuf[1024],*fbuf;
   FILE *fd;
   size_t datasize;
   unsigned int wtime;
   char aname[13],ibuf[41],ynbuf[4],fi,li;
   struct find_t fb;

   getcfg();
   clrscr();
   printf("\nCNRead v1.02 - (c)1993 Simon Ewins - "__DATE__" @ "__TIME__"\n\n");
   strcpy(path,".\\MAIL\\");
   strcpy(uname,cfg.uname);
   s_zone=cfg.zone;
   s_net=cfg.net;
   s_node=cfg.node;
   s_point=cfg.point;
   strcpy(s_domain,cfg.domain);
   h_zone=cfg.b_zone;
   h_net=cfg.b_net;
   h_node=cfg.b_node;
   h_point=cfg.b_point;
   strcpy(h_domain,cfg.b_domain);
   strcpy(editor,cfg.editor);
   strcpy(origin,cfg.origin);
   _setcursortype(_NOCURSOR);
   _wscroll=FALSE;
   sprintf(fnme,"%s*.Msg",path);
   done=_dos_findfirst(fnme,_A_NORMAL,&fb);
   while(!done) {
      areacount++;
      done=_dos_findnext(&fb);
   }
   if(areacount) {
      areas=(AREA *)amalloc(sizeof(AREA),NULL,1,areacount);
      if(areas!=(AREA *)NULL) {
         i=0;
         done=_dos_findfirst(fnme,_A_NORMAL,&fb);
         while(!done) {
            sprintf(fnme,"%s%s",path,fb.name);
            tfd=fopen(fnme,"rb");
            if(tfd) {
               fread(&cnmhdr,sizeof(cnmhdr),1,tfd);
               fclose(tfd);
               strcpy(aname,fb.name);
               p=strrchr(aname,'.');
               *p=NULL;
               strcpy(areas[i].area,aname);
               areas[i].messages=cnmhdr.messages;
               areas[i].lastread=cnmhdr.lastread;
               areas[i++].update=cnmhdr.update;
            }
            done=_dos_findnext(&fb);
         }
         qsort(areas,areacount,sizeof(AREA),cmparea);
         select_area();
         msgscreen();
         sprintf(fnme,"%s%s.Msg",path,areas[carea].area);
         sprintf(xnme,"%s%s.To",path,areas[carea].area);
         tfd=fopen(fnme,"r+b");
         xfd=fopen(xnme,"r+b");
         fread(&cnmhdr,sizeof(cnmhdr),1,tfd);
         crecord=bookmark=areas[carea].lastread;
         shoheader();
         topline=0;
         sfind[0]=sfind[1]=sfind[2]=ch=NULL;
         while(ch!=ESCAPE) {
            if((ch=getch())==0) ch=getch()|128;
            switch(ch) {

               /*-----------------11-12-93 01:11am-----------------
                Quit the Reader program.
                --------------------------------------------------*/
               case ESCAPE:
                  dbox("Quit (y/N)?",ynbuf,1,TRUE);
                  if(ynbuf[2]=='Y')
                     close_files();
                  else
                     ch=NULL;
                  break;
               case 'x':
               case 'q':
               case 'X':
               case 'Q':
                  close_files();
                  ch=ESCAPE;
                  break;

               /*-----------------11-12-93 01:12am-----------------
                Move to next message.
                --------------------------------------------------*/
               case FWD:
               case ENTER:
                  if(crecord<areas[carea].messages) {
                     crecord++;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:12am-----------------
                Move to next reply.
                --------------------------------------------------*/
               case CTRL_FWD:
                  if(cnmmhdr.nextreply) {
                     crecord=cnmmhdr.nextreply;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:13am-----------------
                Move to previous message.
                --------------------------------------------------*/
               case BWD:
                  if(crecord>1) {
                     crecord--;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:13am-----------------
                Move to previous reply.
                --------------------------------------------------*/
               case CTRL_BWD:
                  if(cnmmhdr.replyto) {
                     crecord=cnmmhdr.replyto;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:13am-----------------
                Move to first message in current area.
                --------------------------------------------------*/
               case CTRL_HOME:
                  crecord=1;
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:14am-----------------
                Move to last message in current area.
                --------------------------------------------------*/
               case CTRL_END:
                  crecord=areas[carea].messages;
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:14am-------------------
                Scroll message screen down (move up through message).
                ----------------------------------------------------*/
               case UP:
                  if(message_lines>18 && topline!=0) {
                     scroll(1,TEXT,80,25,FALSE,BLACK,LIGHTGRAY,FALSE);
                     topline--;
                     gotoxy(1,TEXT);
                     linecolour(topline);
                     cputs(tabs(message[topline]));
                  }
                  break;

               /*-----------------11-12-93 01:15am-------------------
                Scroll message screen up (move down through message).
                ----------------------------------------------------*/
               case DN:
                  if(message_lines>18 && topline!=message_lines-18) {
                     scroll(1,TEXT,80,25,TRUE,BLACK,LIGHTGRAY,FALSE);
                     topline++;
                     gotoxy(1,25);
                     linecolour(topline+17);
                     cputs(tabs(message[topline+17]));
                  }
                  break;

               /*-----------------11-12-93 01:15am-----------------
                Move up one page in the current message.
                --------------------------------------------------*/
               case PGUP:
                  topline-=18;

               /*-----------------11-12-93 01:16am-----------------
                Move to top of message. (Falls through from PGUP).
                --------------------------------------------------*/
               case HOME:
                  if(ch==HOME || topline<0)
                     topline=0;
                  scroll(1,TEXT,80,25,TRUE,BLACK,LIGHTGRAY,TRUE);
                  for(i=topline,cline=TEXT;i<message_lines;i++,cline++) {
                     gotoxy(1,cline);
                     linecolour(i);
                     cputs(tabs(message[i]));
                     if(cline-TEXT==17) break;
                  }
                  break;

               /*-----------------11-12-93 01:16am-----------------
                Move down one page in the current message.
                --------------------------------------------------*/
               case PGDN:
                  topline+=18;

               /*-----------------11-12-93 01:17am----------------------
                Move to last page of message. (Falls through from PGDN).
                -------------------------------------------------------*/
               case END:
                  if(ch==END || topline>message_lines-18) {
                     topline=message_lines-18;
                     if(topline<0) topline=0;
                  }
                  scroll(1,TEXT,80,25,TRUE,BLACK,LIGHTGRAY,TRUE);
                  for(i=topline,cline=TEXT;i<message_lines;i++,cline++) {
                     gotoxy(1,cline);
                     linecolour(i);
                     cputs(tabs(message[i]));
                     if(cline-TEXT==17) break;
                  }
                  break;

               /*-----------------11-12-93 01:18am-----------------
                Display commands and key functions list.
                --------------------------------------------------*/
               case F1:
                  help();
                  break;

               /*-----------------11-12-93 01:18am-----------------
                Execute a DOS shell, with swapping.
                --------------------------------------------------*/
               case F2:
                  swapcmnd("");
                  msgscreen();
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:18am-----------------
                Write current message to a text file.
                --------------------------------------------------*/
               case 'w':
               case 'W':
                  dbox("File Name:",ibuf,36,FALSE);
                  if(ibuf[1]>0) {
                     fd=fopen(&ibuf[2],"r+t");
                     if(fd) {
                        dbox("File exists. A)ppend O)verwrite Q)uit?",ynbuf,1,TRUE);
                        if(ynbuf[2]=='Q')
                           break;
                        if(ynbuf[2]=='A')
                           fseek(fd,0L,SEEK_END);
                        if(ynbuf[2]=='O') {
                           fclose(fd);
                           fd=fopen(&ibuf[2],"w+t");
                        }
                     } else {
                        fd=fopen(&ibuf[2],"w+t");
                     }
                     if(fd) {
                        fprintf(fd,"\n\n");
                        fprintf(fd,"Area: %s\n",areas[carea].area);
                        fprintf(fd,"Date: %s",ctime(&cnmmhdr.wdate));
                        fprintf(fd,"  To: %s\n",cnmmhdr.to);
                        fprintf(fd,"From: %s\n",cnmmhdr.from);
                        fprintf(fd,"Subj: %s\n",cnmmhdr.subj);
                        fprintf(fd,"\n");
                        for(i=0;i<message_lines;i++)
                           fprintf(fd,"%s\n",message[i]);
                        fprintf(fd,"\n");
                        fclose(fd);
                     } else {
                        mbox("File open/create error.");
                     }
                  }
                  break;

               /*-----------------11-12-93 01:19am-----------------
                Enter a new message in the current area.
                --------------------------------------------------*/
               case 'e':
               case 'E':
                  memset(&newhdr,0,sizeof(newhdr));
                  strcpy(newhdr.from,uname);
                  if(net) {
                     newhdr.dzone=h_zone;
                     newhdr.dnet=h_net;
                     newhdr.dnode=h_node;
                     newhdr.dpoint=h_point;
                     strcpy(newhdr.ddomain,h_domain);
                  }
                  getheader(net);
                  unlink("CNRead.Msg");
                  sprintf(edit,editor,"CNRead.Msg");
                  swapcmnd(edit);
                  fd=fopen("CNRead.Msg","rb");
                  if(fd) {
                     datasize=(size_t)filelength(fileno(fd));
                     if(datasize) {
                        sprintf(tbuf,"\r--- CNRead v1.02\r * Origin: %s (%d:%d/%d.%d)\r",\
                                    origin,s_zone,s_net,s_node,s_point);
                        datasize+=strlen(tbuf);
                        if(data) free(data);
                        p=data=(char *)malloc(datasize);
                        if(data) {
                           i=fgetc(fd);
                           while(!feof(fd)) {
                              if(i!=141 && i!=10) *p++=(char)i;
                              i=fgetc(fd);
                           }
                           sprintf(p,tbuf);     /* append origin line */
                           WriteMsg(0,data);
                           control_lines=trailer_lines=0;
                           message_lines=fill_array(message,0,datasize,data);
                           areas[carea].messages++;
                           crecord=areas[carea].messages;
                        }
                        fclose(fd);
                     }
                  }
                  msgscreen();
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:19am-----------------
                Reply to the SENDER of the current message. Quotes.
                --------------------------------------------------*/
               case 'f':
               case 'F':
                  memset(&newhdr,0,sizeof(newhdr));
                  strcpy(newhdr.from,uname);
                  strcpy(newhdr.to,cnmmhdr.from);
                  strcpy(newhdr.subj,cnmmhdr.subj);
                  if(net) {
                     newhdr.dzone=cnmmhdr.ozone;
                     newhdr.dnet=cnmmhdr.onet;
                     newhdr.dnode=cnmmhdr.onode;
                     newhdr.dpoint=cnmmhdr.opoint;
                     strcpy(newhdr.ddomain,cnmmhdr.odomain);
                  }
                  getheader(net);
                  li=fi=NULL;
                  fi=toupper(cnmmhdr.from[0]);
                  p=strrchr(cnmmhdr.from,' ');
                  if(p) li=toupper(*(p+1));
                  fd=fopen("CNRead.Msg","w+t");
                  if(fd) {
                     fprintf(fd," -=> On %s",ctime(&cnmmhdr.wdate));
                     fprintf(fd," -=> %s wrote to %s\n",cnmmhdr.from,cnmmhdr.to);
                     fprintf(fd," -=> about \"%s\"\n\n",cnmmhdr.subj);
                     for(i=0;i<message_lines;i++) {
                        if(strlen(message[i])) {
                           if(!memchr(message[i],'>',5))
                              fprintf(fd,"%c%c> ",fi,li);
                        }
                        fprintf(fd,"%s\n",message[i]);
                     }
                     fclose(fd);
                     _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                     wtime=fb.wr_time;
                  }
                  sprintf(edit,editor,"CNRead.Msg");
                  swapcmnd(edit);
                  _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                  if(wtime!=fb.wr_time) {
                     fd=fopen("CNRead.Msg","rb");
                     if(fd) {
                        datasize=(size_t)filelength(fileno(fd));
                        if(datasize) {
                           sprintf(tbuf,"\r--- CNRead v1.02\r * Origin: %s (%d:%d/%d.%d)\r",\
                                       origin,s_zone,s_net,s_node,s_point);
                           datasize+=strlen(tbuf);
                           if(data) free(data);
                           p=data=(char *)malloc(datasize);
                           if(data) {
                              i=fgetc(fd);
                              while(!feof(fd)) {
                                 if(i!=141 && i!=10) *p++=(char)i;
                                 i=fgetc(fd);
                              }
                              sprintf(p,tbuf);     /* append origin line */
                              cnmmhdr.nextreply=areas[carea].messages+1;
                              fseek(tfd,cnmtdx.offset,SEEK_SET);
                              fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                              WriteMsg(crecord,data);
                              control_lines=trailer_lines=0;
                              message_lines=fill_array(message,0,datasize,data);
                              areas[carea].messages++;
                              crecord=areas[carea].messages;
                           }
                           fclose(fd);
                        }
                     }
                  }
                  msgscreen();
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:19am------------------
                Reply to the TO name in the current message. Quotes.
                ---------------------------------------------------*/
               case 't':
               case 'T':
                  memset(&newhdr,0,sizeof(newhdr));
                  strcpy(newhdr.from,uname);
                  strcpy(newhdr.to,cnmmhdr.to);
                  strcpy(newhdr.subj,cnmmhdr.subj);
                  if(net) {
                     newhdr.dzone=cnmmhdr.ozone;
                     newhdr.dnet=cnmmhdr.onet;
                     newhdr.dnode=cnmmhdr.onode;
                     newhdr.dpoint=cnmmhdr.opoint;
                     strcpy(newhdr.ddomain,cnmmhdr.odomain);
                  }
                  getheader(net);
                  li=fi=NULL;
                  fi=toupper(cnmmhdr.from[0]);
                  p=strrchr(cnmmhdr.from,' ');
                  if(p) li=toupper(*(p+1));
                  fd=fopen("CNRead.Msg","w+t");
                  if(fd) {
                     fprintf(fd," -=> On %s",ctime(&cnmmhdr.wdate));
                     fprintf(fd," -=> %s wrote to %s\n",cnmmhdr.from,cnmmhdr.to);
                     fprintf(fd," -=> about \"%s\"\n\n",cnmmhdr.subj);
                     for(i=0;i<message_lines;i++) {
                        if(strlen(message[i])) {
                           if(!memchr(message[i],'>',5))
                              fprintf(fd,"%c%c> ",fi,li);
                        }
                        fprintf(fd,"%s\n",message[i]);
                     }
                     fclose(fd);
                     _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                     wtime=fb.wr_time;
                  }
                  sprintf(edit,editor,"CNRead.Msg");
                  swapcmnd(edit);
                  _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                  if(wtime!=fb.wr_time) {
                     fd=fopen("CNRead.Msg","rb");
                     if(fd) {
                        datasize=(size_t)filelength(fileno(fd));
                        if(datasize) {
                           sprintf(tbuf,"\r--- CNRead v1.02\r * Origin: %s (%d:%d/%d.%d)\r",\
                                       origin,s_zone,s_net,s_node,s_point);
                           datasize+=strlen(tbuf);
                           if(data) free(data);
                           p=data=(char *)malloc(datasize);
                           if(data) {
                              i=fgetc(fd);
                              while(!feof(fd)) {
                                 if(i!=141 && i!=10) *p++=(char)i;
                                 i=fgetc(fd);
                              }
                              sprintf(p,tbuf);     /* append origin line */
                              cnmmhdr.nextreply=areas[carea].messages+1;
                              fseek(tfd,cnmtdx.offset,SEEK_SET);
                              fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                              WriteMsg(crecord,data);
                              control_lines=trailer_lines=0;
                              message_lines=fill_array(message,0,datasize,data);
                              areas[carea].messages++;
                              crecord=areas[carea].messages;
                           }
                           fclose(fd);
                        }
                     }
                  }
                  msgscreen();
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:21am-----------------
                Change the header for the current message.
                --------------------------------------------------*/
               case 'h':
               case 'H':
                  if(cnmmhdr.sent || cnmmhdr.deleted) break;
                  memcpy(&newhdr,&cnmmhdr,sizeof(newhdr));
                  getheader(net);
                  fseek(tfd,cnmtdx.offset,SEEK_SET);
                  fwrite(&newhdr,sizeof(newhdr),1,tfd);
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:22am--------------------
                Change the header and the body of the current message.
                -----------------------------------------------------*/
               case 'c':
               case 'C':
                  if(cnmmhdr.sent || cnmmhdr.deleted) break;
                  memset(&newhdr,0,sizeof(newhdr));
                  strcpy(newhdr.from,cnmmhdr.from);
                  strcpy(newhdr.to,cnmmhdr.to);
                  strcpy(newhdr.subj,cnmmhdr.subj);
                  if(net) {
                     newhdr.dzone=cnmmhdr.dzone;
                     newhdr.dnet=cnmmhdr.dnet;
                     newhdr.dnode=cnmmhdr.dnode;
                     newhdr.dpoint=cnmmhdr.dpoint;
                     strcpy(newhdr.ddomain,cnmmhdr.ddomain);
                  }
                  getheader(net);
                  fd=fopen("CNRead.Msg","w+t");
                  if(fd) {
                     for(i=0;i<message_lines;i++) {
                        if(!strncmp(message[i],"---",3)) break;
                        fprintf(fd,"%s\n",message[i]);
                     }
                     fclose(fd);
                     _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                     wtime=fb.wr_time;
                  }
                  sprintf(edit,editor,"CNRead.Msg");
                  swapcmnd(edit);
                  _dos_findfirst("CNRead.Msg",_A_NORMAL,&fb);
                  if(wtime!=fb.wr_time) {
                     fd=fopen("CNRead.Msg","rb");
                     if(fd) {
                        datasize=(size_t)filelength(fileno(fd));
                        if(datasize) {
                           sprintf(tbuf,"\r--- CNRead v1.02\r * Origin: %s (%d:%d/%d.%d)\r",\
                                       origin,s_zone,s_net,s_node,s_point);
                           datasize+=strlen(tbuf);
                           if(data) free(data);
                           p=data=(char *)malloc(datasize);
                           if(data) {
                              i=fgetc(fd);
                              while(!feof(fd)) {
                                 if(i!=141 && i!=10) *p++=(char)i;
                                 i=fgetc(fd);
                              }
                              sprintf(p,tbuf);     /* append origin line */
                              cnmmhdr.deleted=cnmmhdr.sent=TRUE;
                              fseek(tfd,cnmtdx.offset,SEEK_SET);
                              fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                              WriteMsg(crecord,data);
                              control_lines=trailer_lines=0;
                              message_lines=fill_array(message,0,datasize,data);
                              areas[carea].messages++;
                              crecord=areas[carea].messages;
                           }
                           fclose(fd);
                        }
                     }
                  }
                  msgscreen();
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:23am-----------------
                Display the control data for current message.
                --------------------------------------------------*/
               case 'n':
               case 'N':
                  disp_array(control,control_lines);
                  break;

               /*-----------------11-12-93 01:23am--------------------
                Display the SEEN-BY and PATH data for current message.
                -----------------------------------------------------*/
               case 'b':
               case 'B':
                  disp_array(trailer,trailer_lines);
                  break;

               /*-----------------11-12-93 01:23am-----------------
                Select a new message area.
                --------------------------------------------------*/
               case 'a':
               case 'A':
                  close_files();
                  select_area();
                  msgscreen();
                  sprintf(fnme,"%s%s.Msg",path,areas[carea].area);
                  sprintf(xnme,"%s%s.To",path,areas[carea].area);
                  tfd=fopen(fnme,"r+b");
                  xfd=fopen(xnme,"r+b");
                  fread(&cnmhdr,sizeof(cnmhdr),1,tfd);
                  crecord=bookmark=areas[carea].lastread;
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-12-93 01:24am-----------------
                Skip to next personal message.
                --------------------------------------------------*/
               case 'p':
               case 'P':
                  for(i=crecord+1;i<=areas[carea].messages;i++) {
                     gotoxy(MESSAGE);
                     cprintf("%-5d",i);
                     fread(&cnmtdx,sizeof(cnmtdx),1,xfd);
                     if(!strnicmp(uname,cnmtdx.to,strlen(uname)))
                        break;
                  }
                  if(i>areas[carea].messages) {
                     mbox("No personal messages found after this message.");
                     gotoxy(MESSAGE);
                     textcolor(WHITE);
                     cprintf("%-5d",crecord);
                     textcolor(LIGHTGRAY);
                  } else {
                     crecord=i;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:24am-----------------
                Find text anywhere in a message.
                --------------------------------------------------*/
               case 's':
               case 'S':
               case ' ':
                  cfind=FALSE;
                  if(sfind[1]>0) {
                     if(ch==' ') cfind=TRUE;
                     else {
                        dbox("Continue last search?",ynbuf,1,TRUE);
                        if(ynbuf[2]=='Y') cfind=TRUE;
                     }
                  } else {
                     if(ch==' ') break;
                  }
                  if(!cfind) dbox("Search string:",sfind,20,FALSE);
                  if(sfind[1]>0) {
                     for(i=cfind?crecord+1:1;i<=areas[carea].messages;i++) {
                        gotoxy(MESSAGE);
                        cprintf("%-5d",i);
                        get_record(i);
                        if(stristr(cnmmhdr.to,&sfind[2]) || stristr(cnmmhdr.from,&sfind[2]) || stristr(cnmmhdr.subj,&sfind[2])) {
                           break;
                        } else {
                           fbuf=(char *)malloc(cnmmhdr.length);
                           if(fbuf) {
                              fseek(tfd,(long)cnmmhdr.control,SEEK_CUR);
                              fread(fbuf,cnmmhdr.length,1,tfd);
                              if(stristr(fbuf,&sfind[2]))
                                 break;
                              free(fbuf);
                           }
                        }
                        if(kbhit()) i=areas[carea].messages+1;
                     }
                     if(i>areas[carea].messages) {
                        mbox("Search string not found.");
                        sfind[0]=sfind[1]=sfind[2]=NULL;
                        gotoxy(MESSAGE);
                        textcolor(WHITE);
                        cprintf("%-5d",crecord);
                        textcolor(LIGHTGRAY);
                     } else {
                        crecord=i;
                        shoheader();
                        topline=0;
                     }
                  }
                  break;

               /*-----------------11-12-93 01:24am-----------------
                Jump to a message number.
                --------------------------------------------------*/
               case 'j':
               case 'J':
                  dbox("Message Number:",ibuf,5,FALSE);
                  i=atoi(&ibuf[2]);
                  if(i>0 && i<areas[carea].messages) {
                     crecord=i;
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-16-93 11:50am-----------------
                Go to the message value stored in bookmark.
                --------------------------------------------------*/
               case ',':
                  crecord=bookmark;
                  shoheader();
                  topline=0;
                  break;

               /*-----------------11-16-93 11:51am-----------------
                Set current message as bookmark.
                --------------------------------------------------*/
               case '.':
                  bookmark=crecord;
                  break;

               /*-----------------11-12-93 01:24am-----------------
                List messages in this area.
                --------------------------------------------------*/
               case 'l':
               case 'L':
                  if(crecord) {
                     list_messages();
                     msgscreen();
                     shoheader();
                     topline=0;
                  }
                  break;

               /*-----------------11-12-93 01:25am-----------------
                Delete or recall current message.
                --------------------------------------------------*/
               case 'd':
               case 'D':
                  cnmmhdr.deleted=cnmmhdr.deleted?FALSE:TRUE;
                  fseek(tfd,cnmtdx.offset,SEEK_SET);
                  fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
                  gotoxy(DELETED);
                  textcolor(WHITE);
                  cprintf("%-3s",cnmmhdr.deleted?"Yes":"No");
                  textcolor(LIGHTGRAY);
                  break;
            }
         }
         free(areas);
      } else {
         printf("\nError: Unable to allocate memory for message areas list");
         delay(2000);
      }
   } else {
      printf("\nError: No *.Msg files found in %s",path);
      delay(2000);
   }
   clrscr();
   _setcursortype(_NORMALCURSOR);
   exit(0);
}


char *tabs(char *s)
{
   static char lbuf[81];
   int len,i=0;

   if(!strchr(s,TAB)) return(s);
   while(*s && i<80) {
      if(*s==TAB) {
         len=9-(i%8);
         if(i+len>80) break;
         sprintf(&lbuf[i],"%*s",len,"");
         i+=len;
      } else
         lbuf[i++]=*s;
      s++;
   }
   lbuf[i]=NULL;
   return(lbuf);
}


void linecolour(int line)
{
   void *p1;
   int p2,p3;

   if(sfind[1]>0) {
      if(stristr(message[line],&sfind[2])) {
         textcolor(BLACK);
         textbackground(LIGHTGRAY);
         return;
      }
   }
   p1=memchr(message[line],'>',5);
   p2=strncmp(message[line],"---",3);
   p3=strncmp(message[line]," * Origin",9);
   if(p1 || !p2 || !p3) {
      textcolor(WHITE);
      textbackground(BLACK);
      return;
   }
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
}


void close_files(void)
{
   fseek(tfd,0L,SEEK_SET);
   cnmhdr.lastread=areas[carea].lastread=crecord;
   cnmhdr.messages=areas[carea].messages;
   time(&cnmhdr.update);
   time(&areas[carea].update);
   fwrite(&cnmhdr,sizeof(cnmhdr),1,tfd);
   fclose(tfd);
   fclose(xfd);
   if(data) {free(data); data=(char *)NULL;}
   message_lines=0;
   control_lines=0;
   trailer_lines=0;
}


void help(void)
{
   char sbuf[19*160];

   gettext(1,7,80,25,sbuf);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   window(1,7,80,25);
   box(18,80,TRUE);
   gotoxy(39,1);  putch('');
   gotoxy(3,2);   cputs("<F1> ....... Help                    <E> ... Enter New Message");
   gotoxy(3,3);   cputs("<F2> ....... DOS Shell               <F> ... Reply to FROM Name");
   gotoxy(3,4);   cputs("<Esc> ...... Quit                    <T> ... Reply to TO Name");
   gotoxy(3,5);   cputs("<Ctrl-Home>  First Message           <P> ... Personal Message Scan");
   gotoxy(3,6);   cputs("<Ctrl-End> . Last Message            <W> ... Write Message to File");
   gotoxy(3,7);   cputs("<Left> ..... Previous Message        <H> ... Change UnSent Header");
   gotoxy(3,8);   cputs("<Ctrl-Left>  Previous Thread         <C> ... Change UnSent Message");
   gotoxy(3,9);   cputs("<Right> .... Next Message            <N> ... Display Control Data");
   gotoxy(3,10);  cputs("<Ctrl-Right> Next Thread             <B> ... Display SEEN-BY: & PATH Data");
   gotoxy(3,11);  cputs("<Home> ..... Top of Message          <S> ... Search for Text in Message");
   gotoxy(3,12);  cputs("<End> ...... Bottom of Message       <L> ... List Messages");
   gotoxy(3,13);  cputs("<Up> ....... Scroll Message Up       <D> ... Delete/Recall Message");
   gotoxy(3,14);  cputs("<Down> ..... Scroll Message Down     <J> ... Jump to Message");
   gotoxy(3,15);  cputs("<PgUp> ..... Message Up 1 Page       <A> ... Select Message Area");
   gotoxy(3,16);  cputs("<PgDn> ..... Message Down 1 Page     <X,Q> . Quick Exit");
   gotoxy(1,17);  cputs("Ĵ <.> ... Set BookMark");
   gotoxy(3,18);  cputs("Press <Esc>...                       <,> ... Goto BookMark");
   gotoxy(39,19); putch('');
   while(getch()!=ESCAPE) ;
   puttext(1,7,80,25,sbuf);
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   window(1,1,80,25);
}


void getheader(int net)
{
   int ret=0;
   char nbuf[6];
   void netbox(int);

   _setcursortype(_NORMALCURSOR);
label1:
   gotoxy(TO);
   ret=fmtin("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!",newhdr.to);
   strppr(newhdr.to);
   gotoxy(TO);
   cprintf("%-35s",newhdr.to);
   if(ret==-UP) goto label3;
label2:
   gotoxy(FROM);
   ret=fmtin("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!",newhdr.from);
   strppr(newhdr.from);
   gotoxy(FROM);
   cprintf("%-35s",newhdr.from);
   if(ret==-UP) goto label1;
label3:
   gotoxy(SUBJECT);
   ret=fmtin("___________________________________",newhdr.subj);
   gotoxy(SUBJECT);
   cprintf("%-35s",newhdr.subj);
   if(ret==-UP) goto label2;
   if(ret==-DN) goto label1;
   if(net) {
      netbox(TRUE);     /* open a window for data collection */
label_zone:
      gotoxy(11,2);
      itoa(newhdr.dzone,nbuf,10);
      ret=fmtin("#####",nbuf);
      newhdr.dzone=atoi(nbuf);
      gotoxy(11,2);
      cprintf("%-5d",newhdr.dzone);
      if(ret==-UP) goto label_domain;
label_net:
      gotoxy(11,3);
      itoa(newhdr.dnet,nbuf,10);
      ret=fmtin("#####",nbuf);
      newhdr.dnet=atoi(nbuf);
      gotoxy(11,3);
      cprintf("%-5d",newhdr.dnet);
      if(ret==-UP) goto label_zone;
label_node:
      gotoxy(11,4);
      itoa(newhdr.dnode,nbuf,10);
      ret=fmtin("#####",nbuf);
      newhdr.dnode=atoi(nbuf);
      gotoxy(11,4);
      cprintf("%-5d",newhdr.dnode);
      if(ret==-UP) goto label_net;
label_point:
      gotoxy(11,5);
      itoa(newhdr.dpoint,nbuf,10);
      ret=fmtin("#####",nbuf);
      newhdr.dpoint=atoi(nbuf);
      gotoxy(11,5);
      cprintf("%-5d",newhdr.dpoint);
      if(ret==-UP) goto label_node;
label_domain:
      gotoxy(11,6);
      ret=fmtin("____________________",newhdr.ddomain);
      gotoxy(11,6);
      cprintf("%-20s",newhdr.ddomain);
      if(ret==-UP) goto label_point;
      if(ret==-DN) goto label_zone;
      netbox(FALSE);    /* close the window */
   }
   _setcursortype(_NOCURSOR);
}


void netbox(int open)
{
   static char sbuf[7*160];

   if(open) {
      gettext(40,4,72,11,sbuf);
      window(40,4,72,11);
      box(5,32,TRUE);
      gotoxy(6,1);
      cprintf("[ ");
      textcolor(WHITE);
      cprintf("Destination Address");
      textcolor(LIGHTGRAY);
      cprintf(" ]");
      gotoxy(3,2);   cprintf("@ Zone: %-5d",newhdr.dzone);
      gotoxy(6,3);   cprintf("Net: %-5d",newhdr.dnet);
      gotoxy(5,4);   cprintf("Node: %-5d",newhdr.dnode);
      gotoxy(4,5);   cprintf("Point: %-5d",newhdr.dpoint);
      gotoxy(3,6);   cprintf("Domain: %-20s",newhdr.ddomain);
   } else {
      puttext(40,4,72,11,sbuf);
      window(1,1,80,25);
   }
}


void shoheader(void)
{
   long pos;
   int i,found=FALSE,personal=FALSE;
   size_t datasize;

   if(!crecord && areas[carea].messages)
      crecord++;
   if(!crecord) {
      msgscreen();
      gotoxy(1,9);
      textcolor(BLINK+WHITE);
      textbackground(BLACK);
      cputs("No messages in this area...");
      textcolor(LIGHTGRAY);
      textbackground(BLACK);
   } else {
      if(crecord>areas[carea].messages)
         crecord=areas[carea].messages;
      if(!get_record(crecord)) {
         pos=filelength(fileno(xfd));
         crecord=(int)(pos/sizeof(cnmtdx));
         get_record(crecord);
      }
      textcolor(WHITE);
      textbackground(BLACK);
      gotoxy(MESSAGE);     cprintf("%-5d",crecord);
      gotoxy(REPLYTO);     cprintf("%5d",cnmmhdr.replyto);
      gotoxy(NEXTREPLY);   cprintf("%-5d",cnmmhdr.nextreply);
      gotoxy(DELETED);     cprintf("%-3s",cnmmhdr.deleted?"Yes":"No");
      gotoxy(SENT);        cprintf("%-3s",cnmmhdr.sent?"Yes":"No");
      gotoxy(DATE);        cprintf("%24.24s",ctime(&cnmmhdr.wdate));
      gotoxy(FROM);
      clreol();
      if(!strnicmp(uname,cnmmhdr.from,strlen(uname))) {
         textcolor(BLACK);
         textbackground(LIGHTGRAY);
         if(cfg.beep) putchar(7);
         personal=TRUE;
      }
      if(sfind[1]>0) {
         if(stristr(cnmmhdr.from,&sfind[2])) {
            textcolor(BLACK);
            textbackground(LIGHTGRAY);
            found=TRUE;
         }
      }
      cprintf("%-35s %d:%d/%d.%d",cnmmhdr.from,\
                  cnmmhdr.ozone,cnmmhdr.onet,cnmmhdr.onode,cnmmhdr.opoint);
      if(personal || found) {
         textcolor(WHITE);
         textbackground(BLACK);
         personal=FALSE;
         found=FALSE;
      }
      gotoxy(TO);
      clreol();
      if(!strnicmp(uname,cnmmhdr.to,strlen(uname))) {
         textcolor(BLACK);
         textbackground(LIGHTGRAY);
         if(cfg.beep) putchar(7);
         personal=TRUE;
      }
      if(sfind[1]>0) {
         if(stristr(cnmmhdr.to,&sfind[2])) {
            textcolor(BLACK);
            textbackground(LIGHTGRAY);
            found=TRUE;
         }
      }
      if(net)
         cprintf("%-35s %d:%d/%d.%d",cnmmhdr.to,\
                  cnmmhdr.dzone,cnmmhdr.dnet,cnmmhdr.dnode,cnmmhdr.dpoint);
      else
         cprintf("%-35s",cnmmhdr.to);
      if(personal || found) {
         textcolor(WHITE);
         textbackground(BLACK);
         personal=FALSE;
         found=FALSE;
      }
      gotoxy(SUBJECT);
      clreol();
      if(sfind[1]>0) {
         if(stristr(cnmmhdr.subj,&sfind[2])) {
            textcolor(BLACK);
            textbackground(LIGHTGRAY);
         }
      }
      cprintf("%-35s",cnmmhdr.subj);
      textcolor(LIGHTGRAY);
      textbackground(BLACK);
      datasize=cnmmhdr.control+cnmmhdr.length+cnmmhdr.trailer+1;
      if(data) free(data);
      data=(char *)malloc(datasize);
      if(data) {
         fread(data,datasize,1,tfd);

         /*-----------------11-10-93 11:19am-----------------
          Store the control data as an array of lines.
          --------------------------------------------------*/
         control_lines=fill_array(control,0,cnmmhdr.control,data);

         /*-----------------11-10-93 11:20am-----------------
          Store the message text as an array of lines.
          --------------------------------------------------*/
         message_lines=fill_array(message,cnmmhdr.control,cnmmhdr.length,data);

         /*-----------------11-10-93 11:19am-----------------
          Store the trailer data as an array of lines.
          --------------------------------------------------*/
         trailer_lines=fill_array(trailer,cnmmhdr.control+cnmmhdr.length,cnmmhdr.trailer,data);

         /*-----------------11-10-93 11:20am-----------------
          Display the first 17 lines of the message.
          --------------------------------------------------*/
         scroll(1,TEXT,80,25,TRUE,BLACK,LIGHTGRAY,TRUE);
         for(i=0;i<message_lines;i++) {
            gotoxy(1,TEXT+i);
            linecolour(i);
            cputs(tabs(message[i]));
            if(i==17) break;
         }
      }
   }
}


int fill_array(char **dest,int start,int length,char *source)
{
   int lines=0,col=0;
   char *lastsp,*csource,*cline;

   if(length>1) {
      lastsp=csource=cline=source+start;
      while(*csource) {
         if(*csource=='\r') {
            *csource=NULL;
            dest[lines++]=cline;
            cline=lastsp=csource+1;
            col=0;
         }
         if(*csource==' ')
            lastsp=csource;
         if(col>78) {
            *lastsp=NULL;
            dest[lines++]=cline;
            cline=lastsp+1;
            col=csource-lastsp+1;
         }
         col++;
         csource++;
      }
      dest[lines++]=cline;
   }
   return(lines);
}


void disp_array(char **ar,int size)
{
   int ch,i,cline,topline=0;
   char sbuf[12*160];

   gettext(1,10,80,20,sbuf);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   window(1,10,80,20);
   box(10,80,TRUE);
   for(i=0,cline=2;i<size;i++,cline++) {
      gotoxy(2,cline);
      if(ar[i][0]==1)
         cputs(ar[i]+1);
      else
         cputs(ar[i]);
      if(i==9) break;
   }
   topline=0;
   while(ch!=ESCAPE) {
      if((ch=getch())==0) ch=getch()|128;
      switch(ch) {
         case UP:
            if(size>10 && topline!=0) {
               scroll(2,11,78,19,FALSE,LIGHTGRAY,BLACK,FALSE);
               topline--;
               gotoxy(2,2);
               if(ar[topline][0]==1)
                  cputs(ar[topline]+1);
               else
                  cputs(ar[topline]);
            }
            break;
         case DN:
            if(size>10 && topline!=size-10) {
               scroll(2,11,78,19,TRUE,LIGHTGRAY,BLACK,FALSE);
               topline++;
               gotoxy(2,10);
               if(ar[topline+9][0]==1)
                  cputs(ar[topline+9]+1);
               else
                  cputs(ar[topline+9]);
            }
            break;
      }
   }
   puttext(1,10,80,20,sbuf);
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   window(1,1,80,25);
}


int get_record(int recno)
{
   long pos;

   pos=(long)((recno-1)*sizeof(cnmtdx));
   fseek(xfd,pos,SEEK_SET);
   if(ftell(xfd)!=pos) return(FALSE);
   fread(&cnmtdx,sizeof(cnmtdx),1,xfd);
   fseek(tfd,cnmtdx.offset,SEEK_SET);
   fread(&cnmmhdr,sizeof(cnmmhdr),1,tfd);
   return(TRUE);
}


void msgscreen(void)
{
   clrscr();
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   cprintf("    CNRead v1.02 - (c)1993 Simon Ewins   ::   Area: %-8s  Messages: %-5d    ",areas[carea].area,areas[carea].messages);
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   gotoxy(2,2);   cputs("Msg:");
   gotoxy(21,2);  cputs("<->");
   gotoxy(34,2);  cputs("Deleted:");
   gotoxy(50,2);  cputs("Sent:");
   gotoxy(1,3);   cputs("Date:");
   gotoxy(1,4);   cputs("From:");
   gotoxy(3,5);   cputs("To:");
   gotoxy(1,6);   cputs("Subj:");
   gotoxy(1,7);
   cputs("");
   net=strcmp(areas[carea].area,"NETMAIL")?FALSE:TRUE;
}


void select_area(void)
{
   int ch,i,row,col,tarea,trow,area=carea;

   clrscr();
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   gotoxy(1,1);
   cputs("            Area    Messages  Not Read           Updated                     ");
   gotoxy(1,25);
   cputs("  CNRead v1.02 - Message Area Selection - <Enter> selects, <Esc> keeps current  ");
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   col=1;
   row=2;
   for(i=carea;i<areacount;i++) {
      gotoxy(col,row);
      cprintf("%18s  %7d   %7d   %24.24s",\
               areas[i].area,\
               areas[i].messages,\
               areas[i].messages-areas[i].lastread,\
               ctime(&areas[i].update));
      row++;
      if(row>24) break;
   }
   ch=NULL;
   row=2;
   while(ch!=ENTER && ch!=ESCAPE) {
      hilite(col,row,col+79,row,(LIGHTGRAY<<4)+BLACK);
      if((ch=getch())==0) ch=getch()|128;
      hilite(col,row,col+79,row,(BLACK<<4)+LIGHTGRAY);
      switch(ch) {
         case ESCAPE:
            area=carea;
            break;
         case DN:
            row++;
            area++;
            if(area>areacount-1) {
               row--;
               area--;
            } else {
               if(row>24) {
                  scroll(1,2,80,24,TRUE,BLACK,LIGHTGRAY,FALSE);
                  row--;
                  gotoxy(col,row);
                  cprintf("%18s  %7d   %7d   %24.24s",\
                     areas[area].area,\
                     areas[area].messages,\
                     areas[area].messages-areas[area].lastread,\
                     ctime(&areas[area].update));
               }
            }
            break;
         case UP:
            row--;
            area--;
            if(area<0) {
               row++;
               area++;
            } else {
               if(row<2) {
                  scroll(1,2,80,24,FALSE,BLACK,LIGHTGRAY,FALSE);
                  row++;
                  gotoxy(col,row);
                  cprintf("%18s  %7d   %7d   %24.24s",\
                     areas[area].area,\
                     areas[area].messages,\
                     areas[area].messages-areas[area].lastread,\
                     ctime(&areas[area].update));
               }
            }
            break;
         case PGUP:
            if(area-44>0) {
               tarea=(area-(row-2))-22;
               trow=2;
               for(;tarea<areacount;tarea++) {
                  gotoxy(col,trow);
                  cprintf("%18s  %7d   %7d   %24.24s",\
                     areas[tarea].area,\
                     areas[tarea].messages,\
                     areas[tarea].messages-areas[tarea].lastread,\
                     ctime(&areas[tarea].update));
                  trow++;
                  if(trow>24) break;
               }
               area-=22;
               break;
            }
         case HOME:
            area=0;
            row=2;
            for(i=area;i<areacount;i++) {
               gotoxy(col,row);
               cprintf("%18s  %7d   %7d   %24.24s",\
                  areas[i].area,\
                  areas[i].messages,\
                  areas[i].messages-areas[i].lastread,\
                  ctime(&areas[i].update));
               row++;
               if(row>24) break;
            }
            row=2;
            break;
         case PGDN:
            if(area+44<areacount) {
               tarea=(area-(row-2))+22;
               trow=2;
               for(;tarea<areacount;tarea++) {
                  gotoxy(col,trow);
                  cprintf("%18s  %7d   %7d   %24.24s",\
                     areas[tarea].area,\
                     areas[tarea].messages,\
                     areas[tarea].messages-areas[tarea].lastread,\
                     ctime(&areas[tarea].update));
                  trow++;
                  if(trow>24) break;
               }
               area+=22;
               break;
            }
         case END:
            area=areacount-23;
            row=2;
            if(area<0) area=0;
            for(i=area;i<areacount;i++) {
               gotoxy(col,row);
               cprintf("%18s  %7d   %7d   %24.24s",\
                  areas[i].area,\
                  areas[i].messages,\
                  areas[i].messages-areas[i].lastread,\
                  ctime(&areas[i].update));
               row++;
               if(row>24) break;
            }
            area=areacount-1;
            row--;
            break;
      }
   }
   carea=area;
}


void list_messages(void)
{
   int ch,i,row,col,trow,trecord,record=crecord,totrecs=areas[carea].messages;

   clrscr();
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   gotoxy(1,1);
   cputs("  Msg#  To                    From                  Subject                  ");
   gotoxy(1,25);
   cputs("  CNRead v1.02 - Message List/Selection - <Enter> selects, <Esc> keeps current  ");
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   col=1;
   row=2;
   for(i=crecord;i<=totrecs;i++) {
      gotoxy(col,row);
      get_record(i);
      cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
         i,\
         cnmmhdr.to,\
         cnmmhdr.from,\
         cnmmhdr.subj);
      row++;
      if(row>24) break;
   }
   ch=NULL;
   row=2;
   while(ch!=ENTER && ch!=ESCAPE) {
      hilite(col,row,col+79,row,(LIGHTGRAY<<4)+BLACK);
      if((ch=getch())==0) ch=getch()|128;
      hilite(col,row,col+79,row,(BLACK<<4)+LIGHTGRAY);
      switch(ch) {
         case ESCAPE:
            record=crecord;
            break;
         case DN:
            row++;
            record++;
            if(record>totrecs) {
               row--;
               record--;
            } else {
               if(row>24) {
                  scroll(1,2,80,24,TRUE,BLACK,LIGHTGRAY,FALSE);
                  row--;
                  gotoxy(col,row);
                  get_record(record);
                  cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                     record,\
                     cnmmhdr.to,\
                     cnmmhdr.from,\
                     cnmmhdr.subj);
               }
            }
            break;
         case UP:
            row--;
            record--;
            if(record<1) {
               row++;
               record++;
            } else {
               if(row<2) {
                  scroll(1,2,80,24,FALSE,BLACK,LIGHTGRAY,FALSE);
                  row++;
                  gotoxy(col,row);
                  get_record(record);
                  cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                     record,\
                     cnmmhdr.to,\
                     cnmmhdr.from,\
                     cnmmhdr.subj);
               }
            }
            break;
         case PGUP:
            if(record-44>1) {
               trecord=(record-(row-2))-22;
               trow=2;
               for(;trecord<=totrecs;trecord++) {
                  gotoxy(col,trow);
                  get_record(trecord);
                  cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                     trecord,\
                     cnmmhdr.to,\
                     cnmmhdr.from,\
                     cnmmhdr.subj);
                  trow++;
                  if(trow>24) break;
               }
               record-=22;
               break;
            }
         case HOME:
            record=1;
            row=2;
            for(i=record;i<=totrecs;i++) {
               gotoxy(col,row);
               get_record(i);
               cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                  i,\
                  cnmmhdr.to,\
                  cnmmhdr.from,\
                  cnmmhdr.subj);
               row++;
               if(row>24) break;
            }
            row=2;
            break;
         case PGDN:
            if(record+44<totrecs) {
               trecord=(record-(row-2))+22;
               trow=2;
               for(;trecord<=totrecs;trecord++) {
                  gotoxy(col,trow);
                  get_record(trecord);
                  cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                     trecord,\
                     cnmmhdr.to,\
                     cnmmhdr.from,\
                     cnmmhdr.subj);
                  trow++;
                  if(trow>24) break;
               }
               record+=22;
               break;
            }
         case END:
            record=totrecs-22;
            row=2;
            if(record<1) record=1;
            for(i=record;i<=totrecs;i++) {
               gotoxy(col,row);
               get_record(i);
               cprintf("%6d  %-20.20s  %-20.20s  %-24.24s",\
                  i,\
                  cnmmhdr.to,\
                  cnmmhdr.from,\
                  cnmmhdr.subj);
               row++;
               if(row>24) break;
            }
            record=totrecs;
            row--;
            break;
      }
   }
   crecord=record;
}


void hilite(int tc,int tr,int bc,int br,unsigned char attr)
{
   unsigned char *cbuf;
   int i,size=(((br-tr)+1)*((bc-tc)+1))*2;

   cbuf=(unsigned char *)malloc(size);
   if(cbuf) {
      gettext(tc,tr,bc,br,cbuf);
      for(i=1;i<size;i+=2) cbuf[i]=attr;
      puttext(tc,tr,bc,br,cbuf);
      free(cbuf);
   }
}


void scroll(int tc,int tr,int bc,int br,int dir,int bg,int fg,int clear)
{
   union REGS rg;

   rg.h.ah=dir?6:7;
   rg.h.al=clear?0:1;
   rg.h.bh=(bg<<4)+fg;
   rg.h.cl=tc-1;
   rg.h.ch=tr-1;
   rg.h.dl=bc-1;
   rg.h.dh=br-1;
   int86(16,&rg,&rg);
}


void mbox(char *ermsg)
{
   int lf=(80-max(strlen(ermsg)+2,15))/2;
   int rt=lf+max(strlen(ermsg)+1,15);
   char sbuf[4*160];

   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   gettext(lf,11,rt,14,sbuf);
   window(lf,11,rt,14);
   box(4,(rt-lf)+1,FALSE);
   gotoxy(2,2);
   cputs(ermsg);
   gotoxy(2,3);
   cputs("Press <Esc>...");
   while(getch()!=ESCAPE) ;
   puttext(lf,11,rt,14,sbuf);
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   window(1,1,80,25);
}


void dbox(char *pr,char *buf,int len,int u)
{
   int lf=(80-(strlen(pr)+len+2))/2;
   int rt=lf+(strlen(pr)+len+2);
   char sbuf[3*160];

   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   gettext(lf,11,rt,13,sbuf);
   window(lf,11,rt,13);
   box(3,(rt-lf)+1,TRUE);
   gotoxy(2,2);
   cprintf("%s ",pr);
   *buf=len+1;
   _setcursortype(_NORMALCURSOR);
   cgets(buf);
   _setcursortype(_NOCURSOR);
   puttext(lf,11,rt,13,sbuf);
   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   window(1,1,80,25);
   if(u) strupr(&buf[2]);
}


void box(int height,int width,int dbl)
{
   #define NW     ''
   #define SW     ''
   #define NE     ''
   #define SE     ''
   #define SIDE   ''
   #define LINE   ''
   #define DNW    ''
   #define DSW    ''
   #define DNE    ''
   #define DSE    ''
   #define DSIDE  ''
   #define DLINE  ''
   char line1[81],line2[81];
   int y=1;

   setmem(line1+1,width-1,dbl?DLINE:LINE);
   setmem(line2+1,width-1,' ');
   *line1=dbl?DNW:NW;
   line1[width-1]=dbl?DNE:NE;
   line1[width]='\0';
   *line2=dbl?DSIDE:SIDE;
   line2[width-1]=dbl?DSIDE:SIDE;
   line2[width]='\0';
   line1[width]=line2[width]='\0';
   gotoxy(1,y++);
   cputs(line1);
   while(height--) {
      gotoxy(1,y++);
      cputs(line2);
   }
   *line1=dbl?DSW:SW;
   line1[width-1]=dbl?DSE:SE;
   gotoxy(1,y);
   cputs(line1);
}


int cmparea(const void *a,const void *b)
{
   const AREA *aa=a;
   const AREA *bb=b;

   return(stricmp(aa->area,bb->area));
}


char *stristr(char *t,char *s)
{
   char *t1;
   char *s1;

   while(*t) {
      t1=t;
      s1=s;
      while(*s1) {
         if(toupper(*s1)!=toupper(*t))
            break;
         else {
            s1++;
            t++;
         }
      }
      if(!*s1) return t1;
      t=t1+1;
   }
   return NULL;
}


/*

   The following code was written as credited below and is used with thanks.


   AMALLOC - multi-dimensional malloc()

   Allocates a multidimensional array dynamically, at runtime, so that
      1: its elements can be accessed using multiple indirection
      2: it can be deallocated using a call to the standard free() function
   Note: On PC's the max array size is 64K

   Paul Schlyter, 1992-02-09.  Released to the public domain.

*/


void *amalloc( int esiz, void *initval, int dims, ... )
/*
 *  Input:   esiz     size of each array elements, as given by sizeof
 *           initval  pointer to initial value. NULL ==> zero fill
 *           dims     number of dimensions: 1..MAXDIMS (5)
 *           ...      number of elements in each dimension (int's)
 *
 *  Returns:  NULL    error: out of memory, or illegal parameters
 *                    otherwise base pointer to array
 */
{
      unsigned int dim[MAXDIMS], accdim[MAXDIMS];
      va_list ap;
      int i, j;
      long int totsiz;
      void **q;
      char *p, *r, *s;

      if (dims < 1  ||  dims > MAXDIMS)
            return NULL;

      memset(dim, 0, sizeof(dim));          /* Read dimension numbers */
      memset(accdim, 0, sizeof(accdim));
      va_start(ap, dims);
      dim[0] = accdim[0] = va_arg(ap,int);
      for (i = 1; i < dims; i++)
      {
            dim[i] = va_arg(ap,int);
            accdim[i] = accdim[i-1] * dim[i];
      }
      va_end(ap);

                                            /* Compute total array size */
      totsiz = esiz * accdim[dims-1];       /* Data size */

      for (i = 0; i < dims - 1; i++ )       /* Add space for pointers */
            totsiz += sizeof(void *) * accdim[i];

      if (totsiz > MAXSIZE)                 /* Exit if totsiz too large */
            return NULL;

      p = malloc((size_t) totsiz);          /* Allocate memory */
      if (p == NULL)                        /* Out-of-memory   */
            return NULL;
      memset(p, 0, (unsigned int) totsiz);  /* Zero out allocated memory */
      q = (void **) p;

      if (dims == 1)
            r = (char *) q + esiz * accdim[0];

      for (i = 1; i < dims; i++)            /* Fill in pointers */
      {
            int siz;
            int accd = accdim[i-1], d = dim[i];

            siz =  i == dims-1 ? esiz : sizeof(void *);

            r = (char *) q + sizeof(void *) * accd;
            for (j = 0; j < accd; j++)
            {
                  *q++ = r;
                  r += siz * d;
            }
      }

      if (initval != NULL)
      {
            for (s = (char *) q; s < r; s += esiz)
                  memcpy(s, initval, esiz);
      }

      return (void *)p;

      /*-----------------11-05-93 09:34am--------------------
       Void pointer cast added (was originally just return p)
       to avoid a compiler warning about 'suspicious pointer'
       conversion - since p is a char * and the function is a
       void *. - SJE
       -----------------------------------------------------*/

}  /* amalloc */


int swapcmnd(char *cmd)
{
   char cmnd[128];

   textcolor(LIGHTGRAY);
   textbackground(BLACK);
   clrscr();
   if(!xms_installed()) printf("No ");
   printf("XMS driver detected.\n");

   if(!ems4_installed()) printf("No ");
   printf("EMS 4.0 driver detected.\n");

   if(strlen(cmd)==0) {
      cmnd[0]=NULL;
      printf("\n** Type EXIT to return to CNRead **\n");
   } else
      sprintf(cmnd,"/C %s",cmd);

   comspec=getenv("COMSPEC");
   _setcursortype(_NORMALCURSOR);
   swap_return=swap(comspec,cmnd,&exec_return,"CNRead.Swp");
   _setcursortype(_NOCURSOR);
   switch(swap_return) {
      case SWAP_NO_SHRINK:
         printf("Unable to shrink DOS memory block.\n");
         break;
      case SWAP_NO_SAVE:
         printf("Unable to save program to memory or disk.\n");
         break;
      case SWAP_NO_EXEC:
         printf("DOS EXEC call failed.  Error is %d: ",(int)exec_return);
         switch(exec_return) {
            case BAD_FUNC:
               printf("Bad function.\n"); break;
            case FILE_NOT_FOUND:
               printf("Program file not found.\n"); break;
            case ACCESS_DENIED:
               printf("Access to program file denied.\n"); break;
            case NO_MEMORY:
               printf("Insufficient memory to run program.\n"); break;
            case BAD_ENVIRON:
               printf("Bad environment.\n"); break;
            case BAD_FORMAT:
               printf("Bad format.\n"); break;
            default:
               printf("Unexpected error code #%d (decimal).\n",(int)exec_return);
               printf("Consult DOS technical reference manual.\n");
               break;
         }
   }
   return (0);
}


/*-----------------11-14-93 07:51pm------------------
 Get string s formatted like string fs, returns 0 if
 no entry, else returns the number of characters that
 were entered. Starting string passed as ov.

 format characters are:

 # = digits 0123456789
 _ = any legal character (as is)
 ! = any legal character (forced to upper)
 @ = any legal character (forced to lower)
 --------------------------------------------------*/
int fmtin(char *fs,char *s)
{
   int j,c,ch,row=wherey(),col=wherex(),i=0;
   char *p,*ov=strdup(s);
   void shofmt(char *);

   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   shofmt(fs);
   gotoxy(col,row);
   while(TRUE) {
      if(fs[i]!=NULL) {
         p=strchr("!@#_",fs[i]);
         if(!p) {
            putch(fs[i]);
            s[i]=fs[i];
            ++i;
            continue;
         }
      }
      if(*ov) ungetch(*ov++);
      if((c=getch())==0) c=getch()|128;
      switch(c) {
         case UP:
         case DN:
         case ENTER:
            for(j=i;j<=strlen(fs);j++) s[j]=NULL;
            textcolor(LIGHTGRAY);
            textbackground(BLACK);
            free(ov);
            if(c==UP) return(-UP);
            if(c==DN) return(-DN);
            return(i);
         case BKSPACE:
            if(!i) {
               putchar(7);
               break;
            }
            ch=fs[i-1];
            if(ch=='!' || ch=='@' || ch=='_' || ch=='#') ch=' ';
            gotoxy(col+(--i),row);
            putch(ch);
            while(fs[i]!='_' && fs[i]!='!' && fs[i]!='#' && fs[i]!='@' && i) {
               ch=fs[i-1];
               if(ch=='!' || ch=='@' || ch=='_' || ch=='#') ch=' ';
               s[i]=NULL;
               gotoxy(col+(--i),row);
               putch(ch);
            }
            gotoxy(col+i,row);
            break;
         default:
            if(!isprint(c)) {
               putchar(7);
               break;
            }
            if(fs[i]==NULL) {
               putchar(7);
               break;
            }
            if(fs[i]=='#' && !isdigit(c)) {
               putchar(7);
               break;
            }
            if(fs[i]=='@') c=tolower(c);
            if(fs[i]=='!') c=toupper(c);
            s[i++]=c;
            putch(c);
            break;
      }
   }
}


void shofmt(char *s)
{
   while(*s) {
      if(*s=='!' || *s=='@' || *s=='_' || *s=='#')
         putch(' ');
      else
         putch(*s);
      s++;
   }
}


/*-----------------11-14-93 09:28pm------------------
 Converts a string to 'proper' case, handles Mc, Mac,
 D'Arcy, O'Brien etc.
 --------------------------------------------------*/
void strppr(char *strng)
{
   char *stg,*p;

   stg=strng;
   strlwr(stg);
   *stg=toupper(*stg);
loop1:
   p=strchr(stg,' ');
   if(p==NULL) goto nospc;
   ++p;
   stg=p;
   *stg=toupper(*stg);
   if(*stg=='M') {
      ++stg;
      if(*stg=='a')
         ++stg;
      if(*stg=='c') {
         ++stg;
         *stg=toupper(*stg);
      }
   }
   goto loop1;
nospc:
   stg=strng;
loop2:
   p=strchr(stg,39);
   if(p==NULL) return;
   ++p;
   stg=p;
   *stg=toupper(*stg);
   goto loop2;
}


void WriteMsg(int reply,char *text)
{
   int zero=0;

   time(&cnmhdr.update);
   cnmhdr.messages++;
   memset(&cnmmhdr,0,sizeof(cnmmhdr));    /* clear out the message header */
   memset(&cnmtdx,0,sizeof(cnmtdx));      /* clear out the TO index buffer */
   cnmtdx.offset=filelength(fileno(tfd)); /* set offset for the new message */
   strcpy(cnmtdx.to,newhdr.to);           /* set who this message is TO */

   /*-----------------11-02-93 11:39pm-----------------
    Now fill in the rest of the message header info and
    then write the control info and the message text
    followed by the offset as stored in cnmtdx.offset.
    --------------------------------------------------*/
   strcpy(cnmmhdr.from,newhdr.from);
   strcpy(cnmmhdr.to,newhdr.to);
   strcpy(cnmmhdr.subj,newhdr.subj);
   time(&cnmmhdr.wdate);
   time(&cnmmhdr.adate);
   cnmmhdr.ozone=s_zone;
   cnmmhdr.onet=s_net;
   cnmmhdr.onode=s_node;
   cnmmhdr.opoint=s_point;
   strcpy(cnmmhdr.odomain,s_domain);
   cnmmhdr.dzone=newhdr.dzone;
   cnmmhdr.dnet=newhdr.dnet;
   cnmmhdr.dnode=newhdr.dnode;
   cnmmhdr.dpoint=newhdr.dpoint;
   strcpy(cnmmhdr.ddomain,newhdr.ddomain);
   cnmmhdr.replyto=reply;
   cnmmhdr.control=1;             /* +1 in these three is for the NULL */
   cnmmhdr.length=strlen(text)+1;
   cnmmhdr.trailer=1;

   /*-----------------11-02-93 11:33pm-----------------
    Now we can write all the new data to disk.
    --------------------------------------------------*/
   fseek(tfd,0L,SEEK_END);                      /* end of message file */
   fwrite(&cnmmhdr,sizeof(cnmmhdr),1,tfd);      /* header */
   fwrite(&zero,cnmmhdr.control,1,tfd);         /* control data */
   fwrite(text,cnmmhdr.length,1,tfd);           /* message text */
   fwrite(&zero,cnmmhdr.trailer,1,tfd);         /* trailer */
   fwrite(&cnmtdx.offset,sizeof(long),1,tfd);   /* header start position */
   fseek(tfd,0L,SEEK_SET);                      /* start of message file */
   fwrite(&cnmhdr,sizeof(cnmhdr),1,tfd);        /* updated header data */
   fseek(xfd,0L,SEEK_END);                      /* end of to index */
   fwrite(&cnmtdx,sizeof(cnmtdx),1,xfd);        /* updated to index data */
}


void getcfg()
{
   static char *errmsg=" subdirectory not found\n";
   FILE *fd;
   DIR *d;

   fd=fopen("CNMsg.Cfg","rb");
   if(!fd) {
      printf("\nUnable to open CNMsg.Cfg");
      exit(1);
   }
   fread(&cfg,sizeof(cfg),1,fd);
   fclose(fd);
   d=opendir(".\\MAIL");
   if(!d) {
      printf("\nMAIL%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\SEND");
   if(!d) {
      printf("\nSEND%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\RCV");
   if(!d) {
      printf("\nRCV%s",errmsg);
      exit(1);
   }
   closedir(d);
   d=opendir(".\\WORK");
   if(!d) {
      printf("\nWORK%s",errmsg);
      exit(1);
   }
   closedir(d);
}


