/* unique.c */

#include <windows.h>
#include <time.h>
#include "unique.h"

static LPSTR Months[12] = {"JAN","FEB","MAR","APR","MAY","JUN",
                           "JUL","AUG","SEP","OCT","NOV","DEC"};

/*
** Encode [0..50653] as 3 base-37 digits.
** The base-37 char set is [0..9,@,A..Z].
*/

void Base37(unsigned int Value, LPSTR Buffer)
{int Digit;
 /* compute coefficient of 37^2 */
 Digit = Value / (37*37);
 if(Digit<=9)  *Buffer++ = '0' + Digit;
 else *Buffer++ = '@' + (Digit-10);
 Value -= (37*37*Digit);
 /* compute coefficient of 37^1 */
 Digit = Value / 37;
 if(Digit<=9)  *Buffer++ = '0' + Digit;
 else *Buffer++ = '@' + (Digit-10);
 Value -= (37*Digit);
 /* compute coefficient of 37^0 */
 Digit = Value;
 if(Digit<=9)  *Buffer++ = '0' + Digit;
 else *Buffer++ = '@' + (Digit-10);
 *Buffer = '\0';
}

/* construct unique (one per sec) filename */

void unique(LPSTR Buffer)
{unsigned int Value;
 time_t TheTime;
 struct tm *Ptr;
 char AmPm;
 char Temp[8];
 /* get local time */
 TheTime = time(NULL);
 Ptr = localtime(&TheTime);
 if(Ptr->tm_hour>12)
   {AmPm = 'P';
    Ptr->tm_hour -= 12;
   }
 else AmPm = 'A';
 /* compute time value */
 Value = (60*60) * (Ptr->tm_hour) + 60*(Ptr->tm_min) + (Ptr->tm_sec);
 /* convert to printable base-37 */
 Base37(Value, (LPSTR)Temp);
 /* construct unique file name */
 wsprintf((LPSTR)Buffer,"%d%s%d%c.%s", Ptr->tm_mday,
          (LPSTR)Months[Ptr->tm_mon], Ptr->tm_year,
          AmPm, (LPSTR)Temp);
}
                                                                                                                                                                         
