//
// JUN97.CPP
//
// This program demonstrates a code generation problem
// in Microsoft Visual C++ 4.2.  If you compile this
// with the following command line:
//
//  cl /Fc /Ox /GX jun97.cpp
//
// you will get an executable that crashes with a GPF.
// The problem is that the file pointer, fgif, in
// Gif::Load() is corrupted immediately after jumping
// over the first exception call.  Consequently, the
// next call to fgetc() is made with a bogus file pointer,
// resulting in a crash.
//
// The code that first illuminated the problem was part
// of a Gif class.  I've stripped as much code as possible
// to simplify, so don't try to make too much sense of
// what's left!
//

#include <stdio.h>

struct Pixel {
    Pixel() : m_value( 0 ) {};
    unsigned char m_value;
};

struct Gif {
    void Load();
    Pixel *m_pPixels;
    void Init() {
        m_pPixels  = new Pixel[ 20 ];
    }
};

void Gif::Load()
{
    FILE *fgif = fopen( "jun97.cpp", "rb" );

    if ( fgif ) {
        Init();
        for ( int i = 0 ; i < 10 ; i++ )
            m_pPixels[ i ].m_value = fgetc( fgif );
        if ( feof( fgif ) || ferror( fgif ) )
            throw "Error reading global color table";
    }
    //
    // At this point, the code generator has loaded esi
    // with a bogus value, but it gets passed to fgetc()
    // as if it were a valid pointer to fgif
    //
    int type;
    while( ( type = fgetc( fgif ) ) > 0 ) {
        if ( type == 0x3B )
            break;
        throw "Unknown or invalid construct";
    }
    if ( type == 0 )
        throw "No images in GIF file!";
    fclose( fgif );
}

int main()
{
    Gif gif;
    gif.Load();
    return 0;
}

