{*************************************************************************}
{ ReportPrinter/SoftSector BarCode Component version 1.02                 }
{ Copyright (c), 1996, Nevrona Designs, all rights reserved               }
{                                                                         }
{ This component is only useful if you own fully liscensed copies of both }
{ ReportPrinter Pro and ssBarcode.  See RPSSBC.TXT for more information   }
{ on the usage of this component and how to get more info on ssBarcode or }
{ ReportPrinter Pro.                                                      }
{*************************************************************************}

unit RPSSBC;

interface

uses
  Classes, SysUtils, Graphics, SSBC, RPDefine, RPBase;

type
  TRPSSBarCode = class(TSSBarCode)
  protected
    BaseReport: TBaseReport;

    procedure CanvasMoveTo(Canvas: TCanvas;
                           X,Y: integer); override;
    procedure CanvasLineTo(Canvas: TCanvas;
                           X,Y: integer); override;
    procedure CanvasTextOutRotate(Canvas: TCanvas;
                                  TheFont: TFont;
                                  TheX,TheY: integer;
                                  Angle: longint;
                                  Text: string); override;
  public
    procedure PrintBarCode(ReportPrinter: TBaseReport;
                           PrintX,PrintY: double;
                           Height: double);
  end; { TRPSSBarCode }

var
  OutFile: text;

  procedure Register;

implementation

  procedure Register;

  begin { Register }
    RegisterComponents('Report',[TRPSSBarcode]);
  end;  { Register }


  procedure TRPSSBarCode.CanvasMoveTo(Canvas: TCanvas;
                                      X,Y: integer);

  begin
    If Painting then begin
      inherited CanvasMoveTo(Canvas,X,Y);
    end else begin
      With BaseReport do begin
        MoveTo(XD2U(X),YD2U(Y));
        Writeln(OutFile,'M:',X,',',Y,'-',XD2U(X),',',YD2U(Y));
      end; { with }
    end; { else }
  end;


  procedure TRPSSBarCode.CanvasLineTo(Canvas: TCanvas;
                                      X,Y: integer);

  begin
    If Painting then begin
      inherited CanvasLineTo(Canvas,X,Y);
    end else begin
      With BaseReport do begin
        LineTo(XD2U(X),YD2U(Y));
        Writeln(OutFile,'L:',X,',',Y,'-',XD2U(X),',',YD2U(Y));
      end; { with }
    end; { else }
  end;


  procedure TRPSSBarCode.CanvasTextOutRotate(Canvas: TCanvas;
                                             TheFont: TFont;
                                             TheX,TheY: integer;
                                             Angle: longint;
                                             Text: string);

  begin
    If Painting then begin
      inherited CanvasTextOutRotate(Canvas,TheFont,TheX,TheY,Angle,Text);
    end else begin
      With BaseReport do begin
        PushFont;
        Canvas.Font := TheFont;
        FontRotation := Angle;
        FontTop := YD2U(TheY);
        PrintLeft(Text,XD2U(TheX));
        PopFont;
      end; { with }
    end; { else }
  end;


  procedure TRPSSBarCode.PrintBarCode(ReportPrinter: TBaseReport;
                                      PrintX,PrintY: double;
                                      Height: double);

  var
    I1: integer;

  begin { PrintBarCode }
    AssignFile(OutFile,'RPSSBC.DAT');
    Rewrite(OutFile);
    With ReportPrinter as TBaseReport do begin
      CodeHeight := Round(YU2I(Height) * YDPI);
      DataBits := CreateDatabits(XDPI);
      AODataBits := CreateAODatabits(XDPI);
      For I1 := 0 to StrLen(DataBits) do begin
        Write(OutFile,DataBits[I1]);
      end; { for }
      Writeln(OutFile);
      BaseReport := ReportPrinter;
      DrawBarCode(Canvas,XU2D(PrintX),YU2D(PrintY),XDPI);
      BaseReport := nil;
    end; { with }
    CloseFile(OutFile);
  end;  { PrintBarCode }


end.
