' DIR.BAS
' based on a program by Joe Negron
' Modified by Tika Carr to show color directory listings
'
' Donated to the public domain
' No warranties or guarantees are expressed or implied.
'
' Start QuickBasic with: QB /L QB.QLB
'
'Function Description:
'
'This function can be used in one of two ways:
'
'1. Pass the file name as a parameter to check if the file exists. If
'   the file does not exist, then the length of DIR$(FileSpec$) will be
'   zero (0).
'
'2. Pass a path such as C:\WINDOWS\*.* to get a directory listing,
'   including the list of directories.
'-----------------------------------------------------------------------

DECLARE FUNCTION DIR$ (FileSpec$)
'$INCLUDE: 'QB.BI'

'Variables needed
DIM SHARED InRegs AS RegType, OutRegs AS RegType
DIM SHARED DTA AS STRING * 44
DIM SHARED FileSpec$
CONST DOS = &H21
CONST SetDTA = &H1A00
CONST FindFirst = &H4E00, FindNext = &H4F00

CLS

'** Find a file
IF LEN("C:\AUTOEXEC.BAT") = 0 THEN
    PRINT "C:\AUTOEXEC.BAT Not Found"
ELSE
    PRINT "Found C:\AUTOEXEC.BAT"
END IF
PRINT : PRINT
'** Get a listing of a directory:
'    Files are in Yellow, Directories are in Lt. Green
FileSpec$ = "C:\*.*"
Found$ = DIR$(FileSpec$)
DO WHILE LEN(Found$)
    COLOR 7
    IF ASC(MID$(DTA, 22, 1)) = 32 THEN COLOR 14     'Files
    IF ASC(MID$(DTA, 22, 1)) = 16 THEN COLOR 10     'Directories
    PRINT Found$,
    Found$ = DIR$("")
LOOP
COLOR 7

FUNCTION DIR$ (FileSpec$) STATIC
Null$ = CHR$(0)

InRegs.ax = SetDTA
InRegs.dx = VARPTR(DTA)
Interrupt DOS, InRegs, OutRegs

IF LEN(FileSpec$) THEN
FileSpecZ$ = FileSpec$ + Null$

InRegs.ax = FindFirst
InRegs.cx = &H30
InRegs.dx = SADD(FileSpecZ$)
ELSE
InRegs.ax = FindNext
END IF

Interrupt DOS, InRegs, OutRegs

IF OutRegs.flags AND 1 THEN
DIR$ = ""
ELSE
Null = INSTR(31, DTA, Null$)
DIR$ = MID$(DTA, 31, Null - 30)
END IF
END FUNCTION

