' PRINTER.BI
' by Tika Carr
' November 11, 1996
'
' Donated to the Public Domain
' No guarantees or warranties are expressed or implied.
'
' Purpose: Epson Dot Matrix B/W & Color Printer Emulation
'
'Use these strings to control an Epson dot matrix color or black & white
'printer. Read the comments for instructions and descriptions.

esc$ = CHR$(27)

'**** Font Pitch ****
Normal$ = esc$ + "~10"      'Normal
DblH$ = esc$ + "~11"        'Double Height
QuadH$ = esc$ + "~12"       'Quadruple Height
DblW$ = esc$ + "~13"        'Double Width
QuadW$ = esc$ + "~14"       'Quadruple Width
Double$ = esc$ + "~15"      'Double Size
Quad$ = esc$ + "~16"        'Quadruple Size
Subscript$ = esc$ + "S1"    'Subscript (small below-the-line)
Superscript$ = esc$ + "S0"  'Superscript (small above-the-line)
SSModeOff$ = esc$ + "T"     'Turns off Superscript or Subscript Mode

'**** Font Type ****
CondOn$ = CHR$(18)          'Condensed Mode On
CondOff$ = CHR$(15)         'Condensed Mode Off
UndlnOn$ = esc$ + "-1"      'Underline Mode On
UndlnOff$ = esc$ + "-0"     'Underline Mode Off
ItalicOn$ = esc$ + "4"      'Italics Mode On
ItalicOff$ = esc$ + "5"     'Italics Mode Off
BoldOn$ = esc$ + "G"        'Bold On
BoldOff$ = esc$ + "H"       'Bold Off
ReverseOn$ = esc$ + "~21"   'Reverse Print (Draft Mode Only)
ReverseOff$ = esc$ + "~20"  'Reverse Print Mode Off
Slash0On$ = esc$ + "~41"    'Print 0s with a slash through them.
Slash0Off$ = esc$ + "~40"   'Print 0s as Os (no slash)

'**** NLQ/Draft Font Modes ****
Draft$ = esc$ + "x0"        'Default Draft Mode
Roman$ = esc$ + "k0"        'Roman NLQ Font
SanSerif$ = esc$ + "k1"     'Sans Serif NLQ Font
Courier$ = esc$ + "k2"      'Courier NLQ Font

'**** Margin, Justification and Tabs ****
LMargin$ = esc$ + "l"       'Set Left Margin (See NOTES below)
RMargin$ = esc$ + "0"       'Set Right Margin (See NOTES below)
SetTab$ = esc$ + "e" + CHR$(0)  'Set Tab (See NOTES below)
LJustify$ = esc$ + "a0"     'Left Justify (default)
RJustify$ = esc$ + "a2"     'Right Justify
FJustify$ = esc$ + "a3"     'Full Justification
Center$ = esc$ + "a1"       'Center each line

'**** Printer Movement Control ****
MoveHead$ = esc$ + "f" + CHR$(0) 'Move Print Head to Right (See NOTES below)
TAB$ = CHR$(9)              'Move print head to next tab stop
CR$ = CHR$(13)              'Carriage Return
LF$ = CHR$(10)              'Line Feed
FF$ = CHR$(12)              'Form Feed
BS$ = CHR$(8)               'Backspace
PgLenLn$ = esc$ + "C" + CHR$(0)     'Set page length in lines (See NOTES)
PgLenIn$ = esc$ + "C"               'Set page length in inches (See NOTES)

'** NOTES:
'
'The commands noted above take a 3rd arguement, to set the amount of
'spaces to move. For example, to move the print head 10 spaces:
'
'LPRINT MoveHead$ + STR$(10)

'**** Printer Control Codes ****
PrinterOn$ = CHR$(19)       'Allow printer to accept data from computer
PrinterOff$ = CHR$(17)      'Printer ignores data sent from computer
Bell$ = CHR$(7)             'Sound Printer beep (some printers may not have
                            'a speaker, and therefore no sound will be made.
SensorOn$ = esc$ + "9"      'Turn on paper-out sensor
SensorOff$ = esc$ + "8"     'Turn off paper-out sensor

'**** Color Selection (AVAILABLE ONLY ON 7-COLOR PRINTERS) ****
Black$ = esc$ + "r0"        'Black (default)
Red$ = esc$ + "r1"
Blue$ = esc$ + "r2"
Purple$ = esc$ + "r3"
Yellow$ = esc$ + "r4"
Orange$ = esc$ + "r5"
Green$ = esc$ + "r6"

'**** Country Character Sets ****
'These let you use special characters in your printing. See your printer
'manual for more details. If its not found in the manual, then your printer
'may not support special Country character sets (although most printers
'do support it).

USA$ = esc$ + "R0"
France$ = esc$ + "R1"
Germany$ = esc$ + "R2"
UK$ = esc$ + "R3"
Denmark1$ = esc$ + "R4"
Sweden$ = esc$ + "R5"
Italy$ = esc$ + "R6"
Spain1$ = esc$ + "R7"
Japan$ = esc$ + "R8"
Norway$ = esc$ + "R9"
Denmark2$ = esc$ + "R10"
Spain2$ = esc$ + "R11"
LatAmer$ = esc$ + "R12"

