' CALENDAR.BAS
' by Tika Carr & others (I think Dave Shea was it?) in QUIK_BAS Echo
' (date unknown)
'
' Donated to the public domain
' No warranties or guarantees are expressed or implied.
'
' Purpose: Prints out a calendar to the printer, screen or a file.

'Mode$ is "SCRN:" for screen, "LPTx:" for Printer and "FIL:" for file
'If file, provide filename to save to. Ex: FILCALENDAR.TXT saves it
'to CALENDAR.TXT in current directory. x for LPTx: is port your printer is
'on. Usually its "LPT1:"



DECLARE SUB Calendar (Month%, Year%, Mode$, form%)
DEFINT A-Z

DATA January, 31, February, 28, March, 31
DATA April, 30, May, 31, June, 30, July, 31, August, 31
DATA September, 30, October, 31, November, 30, December, 31
TYPE MonthType
   Number AS INTEGER
   MName AS STRING * 9
END TYPE


Calendar 12, 1996, "12_96.txt", 0: RESTORE
Calendar 1, 1998, "1_98.txt", 0
FOR Count = 1 TO 12
  RESTORE
  IF Count < 10 THEN X$ = "0" ELSE X$ = ""
  F$ = "FIL:" + X$ + LTRIM$(STR$(Count)) + "_97.txt"
  Calendar Count, 1997, F$, 0
NEXT
END

SUB Calendar (Month, Year, Mode$, form)

IF form = 0 THEN
  Frm$ = " S  M  T  W  T  F  S": U$ = "## "
ELSE
  Frm$ = "Su    M   Tu    W   Th    F   Sa" + CHR$(13): U$ = "##   "
END IF
DIM MonthData(1 TO 12) AS MonthType
FOR I = 1 TO 12
   READ MonthData(I).MName, MonthData(I).Number
NEXT
NumDays = 0
FOR I = 1899 TO Year - 1
    IF (I MOD 4 = 0 AND I MOD 100 <> 0) OR (I MOD 400 = 0) THEN
        NumDays = NumDays + 366 MOD 7
    ELSE NumDays = NumDays + 365 MOD 7
    END IF
NEXT
FOR I = 1 TO Month - 1: NumDays = NumDays + MonthData(I).Number: NEXT
TotalDays = MonthData(Month).Number
Mode$ = UCASE$(Mode$): IF Mode$ = "" THEN Mode$ = "SCRN:"
IF LEFT$(Mode$, 3) = "LPT" THEN LPort = VAL(MID$(Mode$, 4, 1))
IF (Year MOD 4 = 0 AND Year MOD 100 <> 0) OR (Year MOD 400 = 0) THEN
    IF Month > 2 THEN
        NumDays = NumDays + 1
    ELSEIF Month = 2 THEN TotalDays = TotalDays + 1
    END IF
END IF
StartDay = NumDays MOD 7
IF Mode$ = "SCRN:" THEN CLS
Header$ = RTRIM$(MonthData(Month).MName) + "," + STR$(Year)
IF form = 0 THEN TLen = 23 ELSE TLen = 35
LeftMargin = (TLen - LEN(Header$)) \ 2
IF LEFT$(Mode$, 4) = "FIL:" THEN
    FileName$ = RIGHT$(Mode$, LEN(Mode$) - 4)
    Mode$ = "FIL:"
ELSE FileName$ = Mode$
END IF
OPEN FileName$ FOR OUTPUT AS #1
PRINT #1, TAB(LeftMargin); Header$: PRINT #1, ""
PRINT #1, Frm$
LeftMargin = 5 * StartDay + 1: P = LeftMargin
IF form = 0 THEN LeftMargin = StartDay * 3 + 1
PRINT #1, TAB(LeftMargin);
FOR I = 1 TO TotalDays
    PRINT #1, USING U$; I;
    P = P + 5
    IF P > 32 THEN PRINT #1, "": P = 0
NEXT
PRINT #1, "": CLOSE #1

END SUB

