' BINARY.BAS
' by Tika Carr & Allen Huffman
' October 25, 1996
'
' Free for use as long as authors get credit for these two routines
' No warranties or guarantees are expressed or implied.
'
' Purpose: Convert between binary and decimal values

DECLARE FUNCTION BIN2DEC! (binary$)
DECLARE FUNCTION DEC2BIN$ (decimal!)

INPUT "Binary Value"; B$
PRINT BIN2DEC!(B$)

INPUT "decimal value"; D!
PRINT DEC2BIN$(D!)

FUNCTION BIN2DEC! (binary$)
bit = 1: xbit = 0
FOR i = LEN(binary$) TO 1 STEP -1
    IF MID$(binary$, i, 1) = "1" THEN
        xbit! = xbit! + bit
    END IF
    bit = bit * 2
NEXT
BIN2DEC! = xbit!
END FUNCTION

FUNCTION DEC2BIN$ (decimal!)
x! = decimal!: bit! = 1: BitCount = 1
WHILE x! > 1: x! = x! \ 2: bit! = bit! * 2: BitCount = BitCount + 1: WEND
WHILE LEN(xbit$) < BitCount
    IF decimal! >= bit! THEN
        xbit$ = xbit$ + "1"
    ELSE
        xbit$ = xbit$ + "0"
    END IF
    IF decimal! >= bit! THEN decimal! = decimal! - bit!
    bit! = bit! - (bit! / 2)
WEND
DEC2BIN$ = xbit$
END FUNCTION

