/****************************************
  Ver 1.01 : compiled w/ qlib making it 32bit
      1.01a : compiled w/ PMODE/w v1.31
      1.01b : updated usage()
      1.01c : all warning removed
      1.01d : recompiled after major bug in QLIB fixed
****************************************/

#include <qlib.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>

void usage(void) {
  printf("  Usage : FS infile outfile1 outfile2 [length]\n");
  printf("   infile = file to split into 2\n");
  printf("   outfile1 = 1st part\n");
  printf("   outfile2 = 2nd part\n");
  printf("   length = size of outfile1 [default=1/2 sizeof(infile)]\n");
  exit(0);
}

void error(byte *m){
  printf("Error:");
  printf(m);
  exit(0);
};

#define bufsiz 4096

word main(byte argc,byte **args) {
  sword hi,ho1,ho2;
  sdword len,toread,a,b;
  byte buf[bufsiz];

  printf("File Splitter v1.01d  32bit   by:Peter Quiring\n");
  if ((argc>5)||(argc<4)) usage();
  hi=open(args[1],O_RDONLY|O_BINARY);
  if (hi==-1) error("Opening infile");
  a=filelength(hi);
  if (argc==5) {
    len=atoi(args[4]);
    if (len>a) error("Invalid length");
  } else len=(int)(a / 2);
  ho1=creat(args[2],FA_ARCH);
  if (ho1==-1) error("Opening outfile1");
  ho2=creat(args[3],FA_ARCH);
  if (ho2==-1) error("Opening outfile2");
  a=0;
  do{
    toread = ((len-a)>bufsiz) ? bufsiz : len-a;
    b=read(hi,buf,toread);
    if ((b==-1)||(b!=toread)) error("Reading infile (1)");
    b=write(ho1,buf,b);
    if ((b!=(toread))||(b==-1)) error("Writing outfile1");
    a+=b;
  }while (a<len);
  close(ho1);
  while (!eof(hi)) {
    b=read(hi,buf,bufsiz);
    if ((b==-1)||(!b)) error("Reading infile (2)");
    a=write(ho2,buf,b);
    if ((a==-1)||(a!=b)) error("Writing outfile2");
  };
  close(ho2);
  close(hi);
  return 0;
}
