'Determine Mouse Type
'by Martijn van de Streek
'March 5, 1997

'Here's a program determining
'1. What IRQ the mouse uses
'2. The type of mouse (Serial, PS/2, etc)
'3. The driver version

REM $INCLUDE: 'qb.bi'

DIM Reg AS RegType
DIM Types$(5)
DIM Type2$(7)

PRINT
Types$(1) = "Bus"
Types$(2) = "Serial"
Types$(3) = "InPort"
Types$(4) = "PS/2"
Types$(5) = "HP"

Type2$(0) = "PS/2 Port"
Type2$(2) = "IRQ 2"
Type2$(3) = "IRQ 3"
Type2$(4) = "IRQ 4"
Type2$(5) = "IRQ 5"
Type2$(6) = "IRQ 6"
Type2$(7) = "IRQ 7"

CALL INTERRUPT(&H33, Reg, Reg)
Reg.AX = &H24
CALL INTERRUPT(&H33, Reg, Reg)
IF Reg.AX <> &HFFFF THEN
				BH = (Reg.BX AND &HFF00) / 256
				BL = (Reg.BX AND &HFF)
				CH = (Reg.CX AND &HFF00) / 256
				CL = (Reg.CX AND &HFF)
				PRINT "Driver version: "; BH; "."; BL
				PRINT "Mouse Type:     "; Types$(CH)
				PRINT "IRQ #:          "; Type2$(CL)
ELSE
				PRINT "An error occured !"
END IF

