DEFINT A-Z

'LedDisplay() routine Original Author: Scott Pessoni - August 1995
'---> Modified by Jonathan Leger <---

'All other code, including InitLedDisplay() and InitLedBar(), written
'by Jonathan Leger (leger@mail.dtx.net).

DECLARE SUB LedDisplay (x%, y%, c0%, c1%, digits%, n#)
DECLARE SUB LedBar (x%, y%, c1%, c0%, e%, m%, n#)

SCREEN 7

'****** LedBar x%, y%, c1%, c0%, e%, m%, n#
' x, y is pixel location to place LED Bar
' c0 is the color of the LEDs when turned off*
' c1 is the color of the LEDs when turned on*
' e is the number of LEDs to put in the bar
' m is the maximum number of LEDs lit when bar is at 100%
' n is the number of LEDs to light up
' * This screen mode in the demo uses the standard 16 colors 0 - 15.

'LedBar  x,   y,  c1,c0,  e,  m, n#
 LedBar 100, 100, 10, 8, 10, 10, 4      'Audio Bar?

'****** LedDisplay (x%, y%, c0%, c1%, digits%, n#)
' x, y is pixel location to place LED Bar
' c0 is the color of the LEDs when turned off*
' c1 is the color of the LEDs when turned on*
' digits is the number of LED units to show (total)
' n what number you would like the LED to show
' * This screen mode in the demo uses the standard 16 colors 0 - 15.

'LedDisplay  x,   y, c0, c1, digits, n#)
 LedDisplay 100, 60, 8, 12, 3, 27
'The above set up a 3 digit display showing the number 27 in red (lit)

Pause$ = INPUT$(1): SCREEN 0: WIDTH 80: COLOR 7, 0: CLS : END

SUB LedBar (x%, y%, c1%, c0%, e%, m%, n#)
'LedBar: A simulated Led Bargraph

IF n# < 0 THEN
  FOR i = 1 TO e% * 2 STEP 2
    LINE (x% + i, y%)-(x% + i, y% + 5), c0%
  NEXT
  EXIT SUB
END IF
j = INT(n# * e% / m%): IF j > e% THEN j = e%
FOR i = 1 TO j * 2 STEP 2
  LINE (x% + i, y%)-(x% + i, y% + 5), c1%
NEXT
FOR i = j * 2 + 1 TO e% * 2 STEP 2
  LINE (x% + i, y%)-(x% + i, y% + 5), c0%
NEXT

END SUB

SUB LedDisplay (x%, y%, c0%, c1%, digits%, n#)
'LedDisplay: Generates a simulated Digital Led Display.

n# = FIX(n#): n# = VAL(LEFT$(STR$(n#), digits% + 1)): p = x%
IF LEN(STR$(n#)) - 1 < digits% THEN  'Clear Unused digits
  FOR ced = 1 TO digits% - (LEN(STR$(n#)) - 1)
    LINE (p + 1, y%)-(p + 5, y%), c0%: LINE (p, y% + 1)-(p, y% + 5), c0%
    LINE (p + 6, y% + 1)-(p + 6, y% + 5), c0%
    LINE (p + 1, y% + 6)-(p + 5, y% + 6), c0%
    LINE (p, y% + 7)-(p, y% + 11), c0%
    LINE (p + 6, y% + 7)-(p + 6, y% + 11), c0%
    LINE (p + 1, y% + 12)-(p + 5, y% + 12), c0%: p = p + 8
  NEXT ced
END IF
FOR t = 1 TO LEN(STR$(n#)) - 1
  w$ = MID$(STR$(n#), t + 1, 1)
  SELECT CASE w$ 'Find and select which elements to turn on
    CASE "0"
      E1 = c1%: E2 = c1%: E3 = c1%: E4 = c0%: E5 = c1%: E6 = c1%: E7 = c1%
    CASE "1"
      E1 = c0%: E2 = c0%: E3 = c1%: E4 = c0%: E5 = c0%: E6 = c0%: E7 = c1%
    CASE "2"
      E1 = c0%: E2 = c1%: E3 = c1%: E4 = c1%: E5 = c1%: E6 = c1%: E7 = c0%
    CASE "3"
      E1 = c0%: E2 = c1%: E3 = c1%: E4 = c1%: E5 = c0%: E6 = c1%: E7 = c1%
    CASE "4"
      E1 = c1%: E2 = c0%: E3 = c1%: E4 = c1%: E5 = c0%: E6 = c0%: E7 = c1%
    CASE "5"
      E1 = c1%: E2 = c1%: E3 = c0%: E4 = c1%: E5 = c0%: E6 = c1%: E7 = c1%
    CASE "6"
      E1 = c1%: E2 = c0%: E3 = c0%: E4 = c1%: E5 = c1%: E6 = c1%: E7 = c1%
    CASE "7"
      E1 = c0%: E2 = c1%: E3 = c1%: E4 = c0%: E5 = c0%: E6 = c0%: E7 = c1%
    CASE "8"
      E1 = c1%: E2 = c1%: E3 = c1%: E4 = c1%: E5 = c1%: E6 = c1%: E7 = c1%
    CASE "9"
      E1 = c1%: E2 = c1%: E3 = c1%: E4 = c1%: E5 = c0%: E6 = c0%: E7 = c1%
  END SELECT
  LINE (p, y% + 1)-(p, y% + 5), E1: LINE (p + 1, y%)-(p + 5, y%), E2
  LINE (p + 6, y% + 1)-(p + 6, y% + 5), E3
  LINE (p + 1, y% + 6)-(p + 5, y% + 6), E4: LINE (p, y% + 7)-(p, y% + 11), E5
  LINE (p + 1, y% + 12)-(p + 5, y% + 12), E6
  LINE (p + 6, y% + 7)-(p + 6, y% + 11), E7: p = p + 8
NEXT t

END SUB

