' DOW.BAS
'
' Donated to the public domain
' No warranties or guarantees are expressed or implied.
'
' Purpose: Outputs the date, including day of week in full text format.

DECLARE FUNCTION DOW$ ()

'$INCLUDE: 'qb.bi'      'load qb with the /L switch

PRINT "Today is "; DOW$

FUNCTION DOW$
DIM InRegs AS RegType, OutRegs AS RegType, Day$(7), Month$(12)

'Days of the week
Day$(0) = "Sunday": Day$(1) = "Monday": Day$(2) = "Tuesday"
Day$(3) = "Wednesday": Day$(4) = "Thursday": Day$(5) = "Friday"
Day$(6) = "Saturday"

'Month Names
Month$(1) = "January": Month$(2) = "February": Month$(3) = "March"
Month$(4) = "April": Month$(5) = "May": Month$(6) = "June"
Month$(7) = "July": Month$(8) = "August": Month$(9) = "September"
Month$(10) = "October": Month$(11) = "November": Month$(12) = "December"

'Interrupt 21 Function 2AH - get date
InRegs.ax = &H2A * 256   '2Ah in ah
CALL INTERRUPT(&H21, InRegs, OutRegs)

' cx is the year, dh is the month, dl is the date, al is the day
year% = OutRegs.cx
monthnum% = OutRegs.dx \ 256
dt% = OutRegs.dx MOD 256
dayofweek% = OutRegs.ax MOD 256

'Return the Date String as, for example: Wednesday, October 9, 1996
DOW$ = Day$(dayofweek%) + ", " + Month$(monthnum%) + STR$(dt%) + "," + STR$(year%)

END FUNCTION

