UNIT unixdate;
{ Unix format (secs since 1/1-1970) <=> YYMMDDHHMMSS conversion    }
{ Based on PibTerm source               04-may-88 Kristian Ottosen }
{                                                                  }
{$I POPDEFS.INC}

INTERFACE

USES Use32;

FUNCTION GetUnixDate(Year, Month, Day, Hour, Mins, Secs : Word) : LongInt;
PROCEDURE UnpackUnix(Date           : LongInt;
                     VAR Year       : Word;
                     VAR Month      : Word;
                     VAR Day        : Word;
                     VAR Hour       : Word;
                     VAR Mins       : Word;
                     VAR Secs       : Word);

IMPLEMENTATION

{$IFDEF DateDebug}
USES LogFile, OpString;
{$ENDIF}

CONST
  DaysPerMonth   : ARRAY[1..12] OF Byte = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
  SecsPerYear     = 31536000;
  SecsPerLeapYear = 31622400;
  SecsPerDay      = 86400;
  SecsPerHour     = 3600;
  SecsPerMinute   = 60;

  FUNCTION GetUnixDate;
  VAR
    Date : LongInt;
    t    : LongInt;
    i    : Word;
  BEGIN
    Date := 0;
    FOR i := 1970 TO (Year - 1) DO
    BEGIN
      IF (i MOD 4) = 0 THEN
        t := SecsPerLeapYear
      ELSE
        t := SecsPerYear;
      Inc(Date, t);
    END;
    IF (Year MOD 4) = 0 THEN
      DaysPerMonth[2] := 29
    ELSE
      DaysPerMonth[2] := 28;
    FOR i := 1 TO (Month - 1) DO
      Inc(Date, LongInt(DaysPerMonth[i] * SecsPerDay));
    Inc(Date, LongInt(LongInt(Day-1)*SecsPerDay+LongInt(Hour)*SecsPerHour+LongInt(Mins)*SecsPerMinute+Secs));
    GetUnixDate := Date;
  END;

  PROCEDURE UnpackUnix;
  VAR
    RDate : LongInt;
    t     : LongInt;
  BEGIN
    Year := 1970;
    Month := 1;
    RDate := Date;
    t:=0;
    WHILE (RDate > 0) DO
    BEGIN
      IF (Year MOD 4) = 0 THEN
        t := SecsPerLeapYear
      ELSE
        t := SecsPerYear;
      Dec(RDate, t);
      Inc(Year);
    END;
    Inc(RDate, t);
    Dec(Year);
    IF (Year MOD 4) = 0 THEN
      DaysPerMonth[2] := 29
    ELSE
      DaysPerMonth[2] := 28;
    t:=0;
    WHILE (RDate > 0) DO
    BEGIN
      t := LongInt(DaysPerMonth[Month]) * SecsPerDay;
      Dec(RDate, t);
      Inc(Month);
    END;
    Inc(RDate, t);
    Dec(Month);
    Day := LongInt(RDate + SecsPerDay - 1) DIV SecsPerDay;
    Dec(RDate, ((Day-1) * SecsPerDay));
    Hour := RDate DIV SecsPerHour;
    Dec(RDate, (LONGINT(Hour) * LONGINT(SecsPerHour)));
    Mins := RDate DIV SecsPerMinute;
    Secs := RDate - (Mins * SecsPerMinute);
{$IFDEF DateDebug}
if Year>1994 then addlog('!','Unixdate error: '+Long2str(Date)+' = '+Long2str(day)+'/'+long2str(month)+'-'+long2str(year));
{$ENDIF}
  END;

END.
