UNIT PopStatu;
{ͻ}
{ Shows status of other Portal's on network     Last changed: 26.06.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE PortalStatus;

IMPLEMENTATION

USES OpCrt, OpWindow, OpString, OpKey, ApTimer,
     PoPTypes, Globals, Util, MTask, KeyBoard, InterCom, OproUtil, Com,
     StrUtil;

  PROCEDURE PortalStatus;
  VAR
    StatWin : WindowPtr;
    i : Byte;
    ICR: TInterCom;
    Ch : Char;
    t : EventTimer;
  BEGIN
    MyWin(StatWin,1,2,80,ScreenHeight,2,'Portal multiline status',false);
    REPEAT
      ClrScr;
      WriteLn(' Task  Address           Status');
      FOR i:=0 TO GetMaxLines DO
      BEGIN
        IF GetInterCom(i,ICR) And (ICR.Status<>ICUnused) And (ICR.MyAddress.Zone<>0) THEN
        BEGIN
          IF i=Cfg.TaskNumber THEN Ch:='*' ELSE Ch:=' ';
          WITH ICR DO
            WriteLn(ch,i:4,'  ',Pad(Address2Str(MyAddress),16),'  ',ICStatusStr(ICR));
        END;
      END;
      NewTimerSecs(t, 6);
      WHILE Not TimerExpired(t) and Not PopKeyPressed And Not ComPort^.KeyPressed DO
        GiveUpTime;
    UNTIL PopKeyPressed OR ComPort^.KeyPressed;
    KillWindow(StatWin);
  END;

END.
