UNIT Opus_173;
{ͻ}
{ Opus 1.73+ support routiner                   Last changed: 20.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                          Birger  Kristensen                              }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, Dos, OproUtil, PoPTypes;

TYPE
  Version7NlType = RECORD
                     Zone,
                     Net,
                     Node,
                     HubNode:   Integer;
                     CallCost,         { phone company's charge }
                     MsgFee,           { Amount charged to user for a message }
                     NodeFlags: Word;  { set of flags (see below) }
                     ModemType,        { RESERVED for modem type }
                     Phone_Len,
                     Password_Len,
                     BName_Len,
                     SName_Len,
                     CName_Len,
                     Pack_Len,
                     BaudRate:  Byte;   { baud rate divided by 300 }
                   END;

(*
#define B_hub    0x0001  /* node is a net hub     0000 0000 0000 0001 */
#define B_host   0x0002  /* node is a net host    0000 0000 0000 0010 */
#define B_region 0x0004  /* node is region coord  0000 0000 0000 0100 */
#define B_zone   0x0008  /* is a zone gateway     0000 0000 0000 1000 */
#define B_CM     0x0010  /* runs continuous mail  0000 0000 0001 0000 */
#define B_res1   0x0020  /* reserved by Opus      0000 0000 0010 0000 */
#define B_res2   0x0040  /* reserved by Opus      0000 0000 0100 0000 */
#define B_res3   0x0080  /* reserved by Opus      0000 0000 1000 0000 */
#define B_res4   0x0100  /* reserved by Opus      0000 0001 0000 0000 */
#define B_res5   0x0200  /* reserved for non-Opus 0000 0010 0000 0000 */
#define B_res6   0x0400  /* reserved for non-Opus 0000 0100 0000 0000 */
#define B_res7   0x0800  /* reserved for non-Opus 0000 1000 0000 0000 */
#define B_point  0x1000  /* node is a point       0001 0000 0000 0000 */
#define B_res9   0x2000  /* reserved for non-Opus 0010 0000 0000 0000 */
#define B_resa   0x4000  /* reserved for non-Opus 0100 0000 0000 0000 */
#define B_resb   0x8000  /* reserved for non-Opus 1000 0000 0000 0000 */
*)
  PFileSys = ^TFileSys;
  TFileSys = RECORD
              Area_Name     : S32;
              Area_Number,
              Area_Menu,
              Total_Size    : Word;
              Area_Priv,
              Down_Priv,
              Up_Priv,
              Priv_Up,
              Ratio_Priv,
              New_Priv      : Byte;
              Attrib,
              Status        : Word;
              StartPos,
              Area_Lock,
              Up_Lock,
              Down_Lock,
              Priv_Key,
              Section       : LongInt;
              Other_Len,
              Def_Upload,
              Priv_Upload,
              Key_Upload    : Word;
              Title,
              PreFiles,
              DownPath,
              UpPath,
              Barricade,
              ListPath,
              PrivKey,
              PrivUp,
              Menu,
              Volume,
              Help          : String;
            END;

  _PFileSys = ^_TFileSys;
  _TFileSys = RECORD
               Area_Name   : Array[1..32] of Char;
               Area_Number,
               Area_Menu,
               Total_Size  : Word;
               Area_Priv,
               Down_Priv,
               Up_Priv,
               Priv_Up,
               Ratio_Priv,
               New_Priv    : Byte;
               Fill_Byte1  : Array[1..2] of Byte;
               Attrib,
               Status      : Word;
               StartPos,
               Area_Lock,
               Up_Lock,
               Down_Lock,
               Priv_Key,
               Section     : LongInt;
               Fill_Long   : Array[1..2] of LongInt;
               Title_Len,
               PreFiles_Len,
               Downpath_Len,
               Uppath_Len,
               Barricade_Len,
               ListPath_Len,
               PrivKey_Len,
               PrivUp_Len,
               Menu_Len,
               Vol_Len,
               Help_Len      : Byte;
               Fill_Byte2    : Array[1..5] of Byte;
               Other_Len,
               Def_Upload,
               Priv_Upload,
               Key_Upload    : Word;
               Fill_Word     : Array[1..10] of Word;
             END;

  FilesBBSType = RECORD
    Area_Number : Word;
    Name        : String[12];
    Dl_Priv     : Byte;
    Size        : LongInt;
    Date        : Word;
    Time        : Word;
    AFlag       : Word;
    DL_Lock     : LongInt;
    Up_Date     : Word;
    Up_Time     : Word;
    Down_Cntr   : Word;
    Descr_Len   : Word;
    AltPath_Len : Byte;
    Upld_by_Len : Byte;
    Nxt_Key     : LongInt;
    Filler      : Array[1..20] of Byte;  { Size = 64 bytes }
    Description : String;
    AltPath     : PathStr;
    Uploaded_By : String[35];
  END;
(*
typedef struct _numb_idx {      /* Structure for FILESBBS.ADX */
    word    area_number;	/* area number where files reside */
    byte    area_priv;  /* Access priv */
    byte    filler;  /* To keep it aligned */
    long    area_lock;  /* Access lock */
    long    pos;		/* start of area in FILESBBS.DAT */
    long    insert_pos;		/* where to insert new files	*/
    word    nflag;		/* flags for this area		*/
} ANUMB;
*)

  FilesBBSNumIdx = RECORD
    Area_Number : Word;
    Area_Priv   : Byte;
    Filler      : Byte;
    Area_Lock   : LongInt;
    Offset      : LongInt;
    Insert_Pos  : LongInt;
    NFlag       : Word;
  END;

FUNCTION Address2Opus(CONST Address: TFidoAddress): S8;
FUNCTION FancyStr(s: String): String;
FUNCTION UnPack(CONST InStr: String): String;
FUNCTION Pack(InStr: String): String;

procedure ReadOneFilesBBSLine(VAR f: TBufTextFile; VAR FileRec: FilesBBSType);
PROCEDURE ReadNextFileArea(VAR FSFile: TBufTextFile; VAR FileSysRec: TFileSys);
FUNCTION  FindAreaByNumber(CONST BBSPath: PathStr; AreaNumber: Word; VAR Offset: LongInt): Boolean;
FUNCTION  FindAreaByPath(CONST BBSPath, Path: PathStr; VAR Offset: LongInt): Boolean;

IMPLEMENTATION

USES OpString, OpRoot,
     StrUtil, NetFile;

CONST
  unwrk : String[40] = ' EANROSTILCHBDMUGPKYWFVJXZQ-''0123456789';

TYPE
  UType = RECORD
            CASE Byte OF
              1: (w1    : Word);
              2: (c1,c2 : Char);
          END;

  FUNCTION Address2Opus(CONST Address: TFidoAddress): S8;
  VAR
    s : S8;
  BEGIN
    WITH Address DO
      s:=Char(Lo(Zone))+Char(Hi(Zone))+Char(Lo(Net))+Char(Hi(Net))+
         Char(Lo(Node))+Char(Hi(Node))+Char(Lo(Point))+Char(Hi(Point));
    IF Address.Point=0 THEN s:=Copy(s,1,6);
    Address2Opus:=s;
  END;

  FUNCTION FancyStr(s: String): String;
  VAR
    i : Byte;
  BEGIN
    s:=StLoCase(s);
    FOR i:=1 TO Length(s) DO
      IF (i=1) Or (s[i-1]=' ') THEN s[i]:=UpCase(s[i]);
    FancyStr:=s;
  END;

  FUNCTION UnPack(CONST InStr: String): String;
  VAR
    OutStr : String;
    OBuf : String[4];
    Count,i,j : Byte;
    u : UType;
  BEGIN
    OutStr:=''; Count:=1;
    WHILE Count<=Length(InStr) DO
    BEGIN
      u.c1:=InStr[Count]; u.c2:=InStr[Count+1];
      Inc(Count,2);
      FOR j:=3 DOWNTO 1 DO
      BEGIN
        i:=u.w1 Mod 40;
        u.w1:=u.w1 Div 40;
        OBuf[j]:=unwrk[i+1];
      END;
      OBuf[0]:=#3;
      OutStr:=OutStr+OBuf;
    END;
    UnPack:=OutStr;
  END;

  FUNCTION Pack(InStr: String): String;
  VAR
    u : UType;
    i,j,Cnt : Byte;
    s : String;
  BEGIN
    u.w1:=0; cnt:=0; u.w1:=0; s:='';
    InStr:=stupcase(InStr)+CharStr(' ',3-(Length(InStr) Mod 3)); { Indsat BK'95 }
    FOR i:=1 TO Length(InStr) DO
    BEGIN
      j:=Pos(InStr[i],unwrk);
      IF j=0 THEN j:=1;
      u.w1:=u.w1*40+(j-1);
      Inc(Cnt);
      IF Cnt=3 THEN
      BEGIN
        s:=s+u.c1+u.c2;
        u.w1:=0;
        Cnt:=0;
      END;
    END;
{ ????
    IF Cnt>0 THEN s:=s+u.c1+u.c2;
}
    Pack:=s;
  END;


{=== FilesBBS support routiner ==============================================}

  procedure ReadOneFilesBBSLine(VAR f: TBufTextFile; VAR FileRec: FilesBBSType);
  begin
    FillChar(FileRec, SizeOf(FileRec), 0);
    f.Read(FileRec, 64);
    f.ReadLenStr(FileRec.Description, FileRec.Descr_Len);
    f.ReadLenStr(FileRec.AltPath, FileRec.AltPath_Len);
    f.ReadLenStr(FileRec.Uploaded_By, FileRec.Upld_by_Len);
    FileRec.Name:=AsciiZ2Str(FileRec.Name[0],12);
  end;

  PROCEDURE ReadNextFileArea(VAR FSFile: TBufTextFile; VAR FileSysRec: TFileSys);
  VAR
    _FileSysRec : _PFileSys;
  BEGIN
    New(_FileSysRec);
    FillChar(_FileSysRec^, SizeOf(_FileSysRec^), 0);
    FillChar(FileSysRec, SizeOf(FileSysRec), 0);

    FSFile.Read(_FileSysRec^,SizeOf(_FileSysRec^));

    Move(_FileSysRec^.Area_Number, FileSysRec.Area_Number, 12);
    Move(_FileSysRec^.Attrib, FileSysRec.Attrib, 28);
    Move(_FileSysRec^.Other_Len, FileSysRec.Other_Len, 8);

    FSFile.ReadLenStr(FileSysRec.Title,_FileSysRec^.Title_Len);
    FSFile.ReadLenStr(FileSysRec.PreFiles,_FileSysRec^.PreFiles_Len);
    FSFile.ReadLenStr(FileSysRec.Downpath,_FileSysRec^.DownPath_Len);
    FSFile.ReadLenStr(FileSysRec.Barricade,_FileSysRec^.Barricade_Len);
    FSFile.ReadLenStr(FileSysRec.ListPath,_FileSysRec^.ListPath_Len);
    FSFile.ReadLenStr(FileSysRec.Menu,_FileSysRec^.Menu_Len);
    FSFile.ReadLenStr(FileSysRec.Help,_FileSysRec^.Help_Len);
    FSFile.ReadLenStr(FileSysRec.UpPath,_FileSysRec^.UpPath_Len);
    FSFile.ReadLenStr(FileSysRec.PrivUp,_FileSysRec^.PrivUp_Len);
    FSFile.ReadLenStr(FileSysRec.PrivKey,_FileSysRec^.PrivKey_Len);
    FSFile.ReadLenStr(FileSysRec.Volume,_FileSysRec^.Vol_Len);
    Dispose(_FileSysRec);
  END;

  FUNCTION FindAreaByNumber(CONST BBSPath: PathStr; AreaNumber: Word; VAR Offset: LongInt): Boolean;
  VAR
    f : TNetFile;
    Found : Boolean;
    FilesBBSNumIdxRec : FilesBBSNumIdx;
  BEGIN
    FindAreaByNumber:=False;
    IF f.Open(AddBackSlash(BBSPath)+'FILESBBS.ADX', SizeOf(FilesBBSNumIdx), False) THEN
    BEGIN
      Found:=False;
      REPEAT
        f.Read(FilesBBSNumIdxRec,NoKeep,Wait);
        Found:=(FilesBBSNumIdxRec.Area_Number=AreaNumber)
      UNTIL f.Eof Or (Found);
      Offset:=FilesBBSNumIdxRec.Offset;
      FindAreaByNumber:=Found;
      f.Close;
    END;
  END;

  FUNCTION FindAreaByPath(CONST BBSPath, Path: PathStr; VAR Offset: LongInt): Boolean;
  VAR
    f           : TBufTextFile;
    SysFileRec  : PFileSys;
    Found       : Boolean;
  BEGIN
    Found:=False; Offset:=0;
    IF f.Init(AddBackSlash(BBSPath)+'SYSFILE.DAT', SOpenRead+ShareDenyNone, 10240) THEN
    BEGIN
      New(SysFileRec);
      WHILE Not F.Eof AND NOT Found DO
      BEGIN
        ReadNextFileArea(F, SysFileRec^);
        Found:=StUpCase(AddBackSlash(SysFileRec^.DownPath))=StUpCase(AddBackSlash(Path));
      END;
      f.Done;
      IF Found THEN Found:=FindAreaByNumber(BBSPath, SysFileRec^.Area_Number, Offset);
      Dispose(SysFileRec);
    END;
  END;

END.
