UNIT OutMan2;
{ͻ}
{ Outbound manager v2                           Last changed: 22.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

{ To-Do-List:
  -----------
    - Config fields/order/size (mellem object PickList->TPickListwFields->TNodePick)
    -

}

INTERFACE

USES Use32, PopTypes;

PROCEDURE NewOutboundManager(StartAdr: TFidoAddress);

IMPLEMENTATION

USES OpCrt, Dos, OpRoot, OpFrame, OpWindow, OpPick, OpString, OpCmd, OpKey,
     OpEntry,
     Globals, Nodelist, Input, FileUtil, OproUtil, MailUtil, StrUtil, Util,
     Display;

CONST
  DividerPos = 25;

TYPE
  TStatus = (sNotExpandable, sExpandable, sExpanded);

  TShowNameAs = (snaName, snaSysName, snaAdr, snaFullAdr);

  TMailType = (mtBundle, mtMail, mtAttach, mtPoll,
               mtRequest, mtOldDate, mtUpDate);

CONST
  snaFirst = snaName;
  snaLast  = snaFullAdr;

TYPE
  PPollNodeES = ^TPollNodeES;
  TPollNodeES = OBJECT(EntryScreen)
    CONSTRUCTOR Init(x, y: Byte);
    PROCEDURE esPostEdit; VIRTUAL;
  END;


  PMailEntry = ^TMailEntry;
  TMailEntry = OBJECT(SingleListNode)
    FName   : PathStr;
    Stat    : Char;
    Typ     : TMailType;
    Size    : LongInt;
    Time    : LongInt;
    DoAfter : Char;

    CONSTRUCTOR Init;
  END;

  PNodeInfo = ^TNodeInfo;
  TNodeInfo = OBJECT(SingleListNode)
    Name    : S30;
    SysName : S30;
    Address : TFidoAddress;
    Scanned : Boolean;
    Status  : TStatus;
    MailList: SingleListPtr;

    CONSTRUCTOR Init;
    DESTRUCTOR Done; VIRTUAL;
    PROCEDURE FindInNodelist;
    PROCEDURE InsertMail(MailEntry: PMailEntry);
  END;

  PNodesList = ^TNodesList;
  TNodesList = OBJECT(SingleList)

    PROCEDURE InsertNode(NewNode: PNodeInfo);
    FUNCTION FindNode(Address: TFidoAddress): PNodeInfo;
  END;


  PNodePick = ^TNodePick;
  TNodePick = OBJECT(PickList)
    ShowNameAs : TShowNameAs;
    NodesList  : PNodesList;

    CONSTRUCTOR Init(X1, Y1, X2, Y2 : Byte; ANodes: PnodesList);
    PROCEDURE ItemString(Item: Word; Mode: pkMode; VAR IType: pkItemType; VAR IString: STRING); VIRTUAL;
    PROCEDURE PreMove; VIRTUAL;
    PROCEDURE pkUpdateSearch; VIRTUAL;
    PROCEDURE pkResetSearchStr; VIRTUAL;
  END;

  PDetailPick = ^TDetailPick;
  TDetailPick = OBJECT(PickList)
    Node : PNodeInfo;

    CONSTRUCTOR Init(X1, Y1, X2, Y2 : Byte);
    PROCEDURE ItemString(Item: Word; Mode: pkMode; VAR IType: pkItemType; VAR IString: STRING); VIRTUAL;

    PROCEDURE SetNodePtr(ANode: PNodeInfo);
  END;

  POutMan = ^TOutMan;
  TOutMan = OBJECT(StackWindow)
    KeyWin     : WindowPtr;
    NodePick   : PNodePick;
    DetailPick : PDetailPick;
    NodesList  : PNodesList;
    SearchHdr  : Byte;
    Offset     : Word;

    CONSTRUCTOR Init;
    DESTRUCTOR Done; VIRTUAL;
    PROCEDURE UpdateContents; VIRTUAL;
    PROCEDURE Process; VIRTUAL;

    PROCEDURE UpdateSearch(SearchStr: S20);

    PROCEDURE ScanZones;
    PROCEDURE ScanNode(Node: PNodeInfo);
    PROCEDURE ExpandNode(Node: PNodeInfo);
    PROCEDURE CollapseNode(Node: PNodeInfo);
    PROCEDURE ShowNodeInfo(Node: PNodeInfo);

    PROCEDURE DeleteMail;
    PROCEDURE MakePoll;
  END;


{=== TPollNodeES ===}

  CONSTRUCTOR TPollNodeES.Init(x, y: Byte);
  BEGIN
  END;

  PROCEDURE TPollNodeES.esPostEdit;
  BEGIN
{   IF GetCurrentID=1 THEN GetAdressFromStr(s, Address);}
  END;


{=== TMailEntry ===}

  CONSTRUCTOR TMailEntry.Init;
  BEGIN
    IF NOT INHERITED Init THEN Fail;
    FName:='';
    Stat:=' ';
    Typ:=mtMail;
    Size:=0;
    Time:=0;
    DoAfter:=' ';
  END;


{=== TNodeInfo ===}

  CONSTRUCTOR TNodeInfo.Init;
  BEGIN
    IF NOT INHERITED Init THEN Fail;
    Name:='';
    SysName:='';
    FillChar(Address, SizeOf(Address), 0);
    Scanned:=False;
    Status:=sNotExpandable;
    MailList:=NIL;
  END;

  DESTRUCTOR TNodeInfo.Done;
  BEGIN
    IF MailList<>NIL THEN Dispose(MailList, Done);
    INHERITED Done;
  END;

  PROCEDURE TNodeInfo.FindInNodelist;
  VAR
    NodeListRec : NodeListRecType;
  BEGIN
    IF FindNode(Address, NodeListRec) THEN
    BEGIN
      IF Address.Net=0 THEN
        Name:=NodeListRec.SystemName
      ELSE
        Name:=NodeListRec.SysopName;
      SysName:=NodeListRec.SystemName;
    END ELSE
    BEGIN
      IF Address.Net=0 THEN
        Name:='Zone '+Long2Str(Address.Zone)
      ELSE
        IF Address.Point=0 THEN
          Name:=Long2Str(Address.Net)+'/'+Long2Str(Address.Node)
        ELSE
          Name:='.'+Long2Str(Address.Point);
      SysName:=Name;
    END;
  END;

  PROCEDURE TNodeInfo.InsertMail(MailEntry: PMailEntry);
  BEGIN
    IF MailList=NIL THEN New(MailList, Init);
    MailList^.Append(MailEntry);
  END;



{=== TNodesList ===}

  PROCEDURE TNodesList.InsertNode(NewNode: PNodeInfo);
  VAR
    OldAdr, NewAdr : S8;
    Node : PNodeInfo;
  BEGIN
    NewAdr:=Address2Sort(NewNode^.Address);
    Node:=PNodeInfo(Head);
    IF Node<>NIL THEN
    BEGIN
      OldAdr:=Address2Sort(Node^.Address);
      WHILE (Node<>NIL) AND (OldAdr<=NewAdr) DO
      BEGIN
        Node:=PNodeInfo(Next(Node));
        IF Node<>NIL THEN OldAdr:=Address2Sort(Node^.Address);
      END;
    END;
    NewNode^.FindInNodelist;
    IF Node=NIL THEN Append(NewNode) ELSE PlaceBefore(NewNode, Node);
  END;

  FUNCTION TNodesList.FindNode(Address: TFidoAddress): PNodeInfo;
  VAR
    Node : PNodeInfo;
  BEGIN
    Node:=PNodeInfo(Head);
    WHILE (Node<>NIL) AND NOT CmpAdr(Address, Node^.Address) DO
    BEGIN
      Node:=PNodeInfo(Next(Node));
    END;
    FindNode:=Node;
  END;


{=== TNodePick ===}

  CONSTRUCTOR TNodePick.Init(X1, Y1, X2, Y2 : Byte; ANodes: PNodesList);
  BEGIN
    IF NOT PickList.InitAbstractDeluxe(X1, Y1, X2, Y2, Cfg.Color[2],
                                       DefWindowOptions, X2-X1+1, 0,                 {Number of picklist items}
                                       PickVertical, SingleChoice,
                                       DefPickOptions and Not pkMinHeight or
                                       pkProcessZero) THEN Fail;
    SetPadSize(1, 1);
    SetSearchMode(PickStringSearch);
{
    wFrame.SetFrameType(NoWindowFrame);
    AddSearchHeader(10, heBL);}
{   SetSelectMarker('>','<'); }
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    ShowNameAs:=snaName;
    NodesList:=ANodes;
  END;

  PROCEDURE TNodePick.ItemString(Item: Word; Mode: pkMode; var IType: pkItemType; var IString : String);
  VAR
    Node : PNodeInfo;
  BEGIN
    Node:=PNodeInfo(NodesList^.Nth(Item));
    IF Node<>NIL THEN
    BEGIN
      IString:='';
      IF Mode=pkDisplay THEN
      BEGIN
        IF Node^.Address.Net<>0 THEN IString:=' ';
        IF Node^.Address.Point<>0 THEN IString:='  ';
        CASE Node^.Status OF
          sExpandable : IString:=IString+'+';
          sExpanded   : IString:=IString+'-';
          ELSE          IString:=IString+' ';
        END;
      END;
      CASE ShowNameAs OF
        snaName    : IString:=IString+Node^.Name;
        snaAdr     : IF Node^.Address.Net=0 THEN
                       IString:=IString+'Zone '+Long2Str(Node^.Address.Zone)
                     ELSE
                       IF Node^.Address.Point=0 THEN
                         IString:=IString+Long2Str(Node^.Address.Net)+'/'+Long2Str(Node^.Address.Node)
                       ELSE
                         IString:=IString+'.'+Long2Str(Node^.Address.Point);
        snaFullAdr : IString:=IString+Address2Str(Node^.Address);
        snaSysName : IString:=IString+Node^.SysName;
      END;
    END;
  END;

  PROCEDURE TNodePick.PreMove;
  BEGIN
    INHERITED PreMove;
    POutMan(wParentPtr)^.DetailPick^.SetNodePtr(PNodeInfo(NodesList^.Nth(pkChoice)));
  END;

  PROCEDURE TNodePick.pkUpdateSearch;
  BEGIN
    POutMan(wParentPtr)^.UpdateSearch(pkSearchStr);
  END;

  PROCEDURE TNodePick.pkResetSearchStr;
  BEGIN
    INHERITED pkResetSearchStr;
    pkUpdateSearch;
  END;


{=== TDetailPick ===}

  CONSTRUCTOR TDetailPick.Init(X1, Y1, X2, Y2 : Byte);
  BEGIN
    IF NOT PickList.InitAbstractDeluxe(X1, Y1, X2, Y2, Cfg.Color[2],
                                       DefWindowOptions, X2-X1+1, 0,
                                       PickVertical, MultipleChoice,
                                       DefPickOptions and Not pkDrawActive and
                                       Not pkMinHeight or  pkProcessZero) then
      Fail;
    SetPadSize(0, 1);
    SetSelectMarker(#251, '');
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    Node:=NIL;
  END;

  PROCEDURE TDetailPick.ItemString(Item: Word; Mode: pkMode; var IType: pkItemType; var IString : String);
  VAR
    MailEntry : PMailEntry;

    FUNCTION Typ2Str(MailType: TMailType): S10;
    BEGIN
      CASE MailType OF
        mtBundle : Typ2Str:='Bundle  ';
        mtMail   : Typ2Str:='Mail    ';
        mtAttach : Typ2Str:='Attach  ';
        mtPoll   : Typ2Str:='Poll    ';
        mtRequest: Typ2Str:='Req.    ';
        mtOldDate: Typ2Str:='O.Req.  ';
        mtUpDate : Typ2Str:='U.Req.  ';
        ELSE       Typ2Str:='??????  ';
      END;
    END;

    FUNCTION Stat2Str(Stat: Char): S10;
    BEGIN
      CASE Stat OF
        'H' : Stat2Str:='Hold  ';
        'D' : Stat2Str:='Dir.  ';
        'F',
        'O' : Stat2Str:='Norm  ';
        'C' : Stat2Str:='Crsh  ';
        'I' : Stat2Str:='Imp.  ';
      END;
    END;

  BEGIN
    IF (Node<>Nil) AND (Node^.MailList<>NIL) AND (Node^.MailList^.Size>0) THEN
    BEGIN
      MailEntry:=PMailEntry(Node^.MailList^.Nth(Item));
      WITH MailEntry^ DO
      BEGIN
        IString:=Typ2Str(Typ)+Stat2Str(Stat)+'  '+LongIntForm('########', Size)+'  ';
        IF Typ IN [mtBundle, mtMail] THEN
          IString:=IString+JustFileName(FName)
        ELSE
          IString:=IString+FName;
      END;
    END ELSE
      IString:='* * * * N o t   S c a n n e d   y e t * * * *';
  END;

  PROCEDURE TDetailPick.SetNodePtr(ANode: PNodeInfo);
  BEGIN
    Node:=ANode;
    ClearSelected;
    IF NOT Node^.Scanned THEN POutMan(wParentPtr)^.ScanNode(Node);
    IF Node^.MailList<>NIL THEN
      ChangeNumItems(Node^.MailList^.Size)
    ELSE
      IF Node^.Scanned THEN ChangeNumItems(0) ELSE ChangeNumItems(1);
    UpdateContents;
  END;


{=== TOutMan ===}

  CONSTRUCTOR TOutMan.Init;
  BEGIN
    IF NOT INHERITED InitCustom(2, 3, ScreenWidth-1, ScreenHeight-3, Cfg.Color[2],
                                wClear+wUserContents+wBordered) THEN Fail;
    wFrame.AddSpanHeader('', '', '',  DividerPos,  frLL);
    wFrame.AddHeader(' Outbound Manager ',heTC);
    WITH wFrame DO
    BEGIN
      AddHeader('', heBL);
{     IF frRes <> 0 THEN
      BEGIN
        GotError(epFatal+ecOutOfMemory, emInsufficientMemory);
        Exit;
      END; }
      SearchHdr:=GetLastHeaderIndex;
    END;
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    Offset:=0;

    PickCommands.AddCommand(ccUser0, 1, OpKey.Tab, 0);
    PickCommands.AddCommand(ccUser0, 1, OpKey.ShTab, 0);
    PickCommands.AddCommand(ccUser1, 1, OpKey.Plus, 0);
    PickCommands.AddCommand(ccUser1, 1, OpKey.PadPlus, 0);
    PickCommands.AddCommand(ccUser2, 1, OpKey.Minus, 0);
    PickCommands.AddCommand(ccUser2, 1, OpKey.PadMinus, 0);

    PickCommands.AddCommand(ccUser10, 1, OpKey.AltN, 0);
    PickCommands.AddCommand(ccUser11, 1, OpKey.AltI, 0);

    PickCommands.AddCommand(ccUser22, 1, OpKey.Del, 0);
    PickCommands.AddCommand(ccUser22, 1, OpKey.F2, 0);
    PickCommands.AddCommand(ccUser28, 1, OpKey.F8, 0);

    New(NodesList, Init);
    New(NodePick, Init(2, 3, DividerPos, ScreenHeight-3, NodesList));
    AddChild(NodePick);
    New(DetailPick, Init(DividerPos+2, 4, ScreenWidth-1, ScreenHeight-3));
    AddChild(DetailPick);
    ScanZones;
    MyWin(KeyWin, 1, ScreenHeight-1, ScreenWidth, ScreenHeight, 2, '',False);
    KeyWin^.wFastText('F1=Help          F2=Delete      F3=Request     F4=Send File     F5=ReAddress', 1, 2);
    KeyWin^.wFastText('F6=Change Stat   F7=View File   F8=Poll        F9=Upd. Req.     F0=Global Cmd.', 2, 2);
    Draw;
    SetActiveChild(NodePick);
  END;

  DESTRUCTOR TOutMan.Done;
  BEGIN
    KillWindow(KeyWin);
    Dispose(NodesList, Done);
    INHERITED Done;
  END;

  PROCEDURE TOutMan.UpdateContents;
  BEGIN
    INHERITED UpdateContents;
    wFastWrite(Pad(' Type    Stat        Size  Filename', ScreenWidth-DividerPos-2),
               1, DividerPos+1, Cfg.Color[2].HighLightColor);
  END;

  PROCEDURE TOutMan.Process;
  VAR
    LastCmd : Word;
  BEGIN
    REPEAT
      ActiveChild^.Process;
      LastCmd:=PickListPtr(ActiveChild)^.GetLastCommand;
      CASE LastCmd OF
        ccUser0 : IF TypeOf(wActiveChild^)=TypeOf(TNodePick) THEN
                  BEGIN
                    IF DetailPick^.Node^.Address.Net<>0 THEN
                    BEGIN
                      IF NOT DetailPick^.Node^.Scanned THEN ScanNode(DetailPick^.Node);
                      IF DetailPick^.Node^.MailList<>NIL THEN
                        SetActiveChild(DetailPick);
                     END ELSE
                       IF NOT DetailPick^.Node^.Scanned THEN
                         ExpandNode(DetailPick^.Node);
                   END ELSE
                     SetActiveChild(NodePick);
        ccUser1 : IF TypeOf(wActiveChild^)=TypeOf(TNodePick) THEN
                  BEGIN
                    IF ((NOT DetailPick^.Node^.Scanned) AND (DetailPick^.Node^.Address.Net=0)) OR
                       (DetailPick^.Node^.Status=sExpandable) THEN
                      ExpandNode(DetailPick^.Node);
                  END;
        ccUser2 : IF DetailPick^.Node^.Status=sExpanded THEN CollapseNode(DetailPick^.Node);

        ccUser10: BEGIN
                    IF NodePick^.ShowNameAs=snaLast THEN
                      NodePick^.ShowNameAs:=snaFirst
                    ELSE
                      NodePick^.ShowNameAs:=Succ(NodePick^.ShowNameAs);
                    NodePick^.UpdateContents;
                  END;
        ccUser11: IF TypeOf(wActiveChild^)=TypeOf(TNodePick) THEN ShowNodeInfo(DetailPick^.Node);

        ccUser22: DeleteMail;
        ccUser28: MakePoll;
      END;
    UNTIL LastCmd=ccQuit;
  END;

  PROCEDURE TOutMan.UpdateSearch(SearchStr: S20);
  BEGIN
    ChangeHeader(SearchHdr, Copy(SearchStr, 1, 10));
  END;

  PROCEDURE TOutMan.ScanZones;
  VAR
    Node: PNodeInfo;
    p,
    OutName : S12;
    Test,
    GlobZone: Integer;
    SRec    : SearchRec;
  BEGIN
    FindFirst(Cfg.Outbound+'.*', Directory, SRec);
    OutName:=JustFileName(Cfg.Outbound);
    GlobZone:=0;
    WHILE DOSError=0 DO
    BEGIN
      Test:=0;
      IF SRec.Name=OutName THEN
        GlobZone:=Cfg.Addresses[Cfg.MainAdrNum].Zone
      ELSE
      BEGIN
        p:=Copy(Srec.Name, pos('.', Srec.Name)+1, Length(Srec.Name) - pos('.', Srec.Name)+1);
        Val('$'+p, GlobZone, Test);
        IF GlobZone=Cfg.Addresses[Cfg.MainAdrNum].Zone THEN
        BEGIN
          FindNext(SRec);
          Continue;
        END;
      END;
      IF (Test=0) AND (GlobZone<>0) THEN
      BEGIN
        New(Node, Init);
        Node^.Address.Zone:=GlobZone;
        Node^.Status:=sExpandable;
        NodesList^.InsertNode(Node);
      END;
      FindNext(Srec);
    END;
    FindClose(Srec);
    NodePick^.ChangeNumItems(NodesList^.Size);
  END;

  PROCEDURE TOutMan.ScanNode(Node: PNodeInfo);
  CONST
    Attach         : String[6] = 'HDFCI ';
    Mail           : String[6] = 'HDOCI ';
  VAR
    SRec, SRec1 : SearchRec;
    ZoneOut,
    FileOut     : PathStr;
    a, Try      : Byte;
    MailEntry   : PMailEntry;
    f           : TBufTextFile;
    InStr       : String;
    GotOne      : Boolean;
    Count       : Word;
  BEGIN
    FileOut:=HoldFileName(Node^.Address, False);
    ZoneOut:=HoldAreaPath(Node^.Address, False);

{    FindFirst(FileOut+'*.PKT',Archive,SRec) ;
    IF (DosError=0) And (Confirm('Orphan packets found, rename','Y',13)) THEN
    BEGIN
      REPEAT
        RenamePkt(ZoneOut,SRec.FName);
        FindNext(SRec);
        Wait^.Animate;
      UNTIL DosError<>0;
    END;}

    FOR a:=1 TO 5 DO
    BEGIN
      FindFirst(FileOut+Mail[a]+'UT', Archive, SRec);
      WHILE DOSError = 0 DO
      BEGIN
{        IF SRec.Size<>0 THEN}
        BEGIN
          New(MailEntry, Init);
          WITH MailEntry^ DO
          BEGIN
            FName:=SRec.Name;
            Stat:=Mail[a];
            Typ:=mtBundle;
            Size:=SRec.Size;
            Time:=SRec.Time;
          END;
          Node^.InsertMail(MailEntry);
        END;
{       Wait^.Animate;}
        FindNext(SRec);
      END;
      FindClose(SRec);
    END;
    FindFirst(FileOut+'REQ', Archive, SRec);
    WHILE DOSError = 0 DO
    BEGIN
      IF (SRec.size>0) AND (f.Init(ZoneOut+SRec.Name, SOpenread+ShareDenyNone, 10240)) THEN
      BEGIN
        GotOne:=False;
        WHILE NOT f.EoF DO
        BEGIN
          f.ReadLn(InStr);
          InStr:=StUpCase(InStr);
          IF (InStr[1] <> ';') AND (Length(InStr) > 0) THEN
          BEGIN
            GotOne:=True;
            New(MailEntry, Init);
            MailEntry^.Typ:=mtRequest;
            Try:=Pos(' ',InStr);
            IF (Try>0) And (pos('-', InStr)>Try) THEN MailEntry^.Typ:=mtOldDate;
            IF (Try>0) And (pos('+', InStr)>Try) THEN MailEntry^.Typ:=mtUpDate;
            IF Try >0  THEN InStr:=Copy(InStr, 1, Try-1);
            MailEntry^.FName:=InStr;
            Node^.InsertMail(MailEntry);
          END;
{         Wait^.Animate;}
        END;
        f.Done;
        IF NOT GotOne THEN DeleteFile(FileOut+SRec.Name);
      END;
      FindNext(SRec);
    END;
    FindClose(SRec);

    FOR a:=1 TO 5 DO
    BEGIN
      FindFirst(FileOut+Attach[a]+'LO', Archive, SRec);
      WHILE DOSERROR = 0 DO
      BEGIN
        Count:=0;
        IF (SRec.size>0) AND (f.Init(ZoneOut+SRec.Name, SOpenread+ShareDenyNone, 10240)) THEN
        BEGIN
          WHILE NOT F.EoF DO
          BEGIN
            f.ReadLn(InStr);
            InStr:=StUpCase(InStr);
            IF (Length(InStr)>0) AND (InStr[1]<>';') AND (InStr[1]<>'~') THEN
            BEGIN
              New(MailEntry, Init);
              IF (InStr[1] = '#') OR (InStr[1] = '^') THEN
              BEGIN
                MailEntry^.DoAfter:=InStr[1];
                InStr:=Copy(InStr, 2, Length(InStr) - 1);
              END;
              WITH MailEntry^ DO
              BEGIN
                FName:=InStr;
                Stat:=Attach[a];
                FindFirst(FName, AnyFile, SRec1);
                IF DOSError=0 THEN
                BEGIN
                  Size:=SRec1.Size;
                  Time:=SRec1.Time;
                END;
                IF Copy(FName, 1, Length(ZoneOut))=ZoneOut THEN
                  Typ:=mtMail
                ELSE
                  Typ:=mtAttach;
              END;
              Inc(Count);
              Node^.InsertMail(MailEntry);
            END;
{           Wait^.Animate;}
          END;
          f.Done;
        END;
        IF Count=0 THEN
        BEGIN
          New(MailEntry, Init);
          WITH MailEntry^ DO
          BEGIN
            Stat:=Attach[a];
            Typ:=mtPoll;
          END;
          Node^.InsertMail(MailEntry);
        END;
        FindNext(SRec);
      END;
      FindClose(SRec);
    END;

    Node^.Scanned:=True;
  END;

  PROCEDURE TOutMan.ExpandNode(Node: PNodeInfo);
  VAR
    NewNode : PNodeInfo;
    SRec : SearchRec;
    Path : PathStr;
    Err  : Integer;
    FoundSome : Boolean;
    Adr       : TFidoAddress;
    WaitWin : PWait;
  BEGIN
    New(WaitWin, Init(ScreenHeight DIV 2, 3, 'Scannning: '+Node^.Name));
    IF Node^.Address.Net<>0 THEN
    BEGIN
      Adr:=Node^.Address;
      Adr.Point:=1;
      Path:=HoldAreaPath(Adr, False)+'*.*';
    END ELSE
      Path:=HoldAreaPath(Node^.Address, False)+'*.*';
    FoundSome:=False;
    FindFirst(Path, AnyFile, SRec);
    WHILE DOSError=0 DO
    BEGIN
      IF (Length(SRec.Name)>=8) AND
      ((Copy(SRec.Name, 11, 2)='LO') OR (Copy(SRec.Name, 11, 2)='UT') OR
       (Copy(SRec.Name, 10, 3)='REQ') OR (Copy(SRec.Name, 10, 3)='PNT')) THEN
      BEGIN
        Adr.Zone:=Node^.Address.Zone;
        Val('$'+Copy(SRec.Name, 1, 4), Adr.Net, Err);
        Val('$'+Copy(SRec.Name, 5, 4), Adr.Node, Err);
        Adr.Point:=0;
        IF (Adr.Net=0) THEN
        BEGIN
          Adr.Point:=Adr.Node;
          Adr.Net:=Node^.Address.Net;
          Adr.Node:=Node^.Address.Node;
        END;
        NewNode:=NodesList^.FindNode(Adr);
        IF NewNode=NIL THEN
        BEGIN
          New(NewNode, Init);
          NewNode^.Address:=Adr;
          NodesList^.InsertNode(NewNode);
        END;
        IF (Copy(SRec.Name, 10, 3)='PNT') AND (Adr.Point=0) THEN NewNode^.Status:=sExpandable;
        FoundSome:=True;
      END;
      FindNext(SRec);
      WaitWin^.Animate;
    END;
    FindClose(SRec);
    NodePick^.ChangeNumItems(NodesList^.Size);
    IF FoundSome THEN
      Node^.Status:=sExpanded
    ELSE
      Node^.Status:=sNotExpandable;
    Node^.Scanned:=True;
    Dispose(WaitWin, Done);
  END;

  PROCEDURE TOutMan.CollapseNode(Node: PNodeInfo);
  VAR
    AdrStr : S6;
    NewNode : PNodeInfo;
    Len : Byte;
  BEGIN
    IF Node^.Address.Net=0 THEN Len:=2 ELSE Len:=6;
    AdrStr:=Copy(Address2Sort(Node^.Address), 1, Len);
    NewNode:=PNodeInfo(NodesList^.Next(Node));
    WHILE (NewNode<>NIL) AND (AdrStr=Copy(Address2Sort(NewNode^.Address), 1, Len)) DO
    BEGIN
      NodesList^.Delete(NewNode);
      NewNode:=PNodeInfo(NodesList^.Next(Node));
    END;
    Node^.Status:=sExpandable;
    NodePick^.ChangeNumItems(NodesList^.Size);
  END;

  PROCEDURE TOutMan.ShowNodeInfo(Node: PNodeInfo);
  VAR
    NodeInfoWin : WindowPtr;
  BEGIN
    MyWin(NodeInfoWin, 20, 8, 60, 19, 2, 'Node information',False);
{ Fill in code!!!! }
    ReadKeyWord;
    KillWindow(NodeInfoWin);
  END;


  PROCEDURE TOutMan.DeleteMail;
  BEGIN
    IF DetailPick^.Node^.Address.Net=0 THEN
    BEGIN
      IF Confirm('Delete ALL mail in: ','N',13) THEN ;

    END ELSE
      IF Confirm('Delete mail for: ','N',13) THEN ;

  END;

  PROCEDURE TOutMan.MakePoll;
  BEGIN

  END;


{=== ===}

  PROCEDURE NewOutboundManager(StartAdr: TFidoAddress);
  VAR
    OutMan: TOutMan;
  BEGIN
    OutMan.Init;
    OutMan.Process;
    OutMan.Done;
  END;

END.
