UNIT Config;
{ͻ}
{ Config of anything except mail options        Last changed: 28.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE SaveConfiguration;
PROCEDURE DisplayKeys(EditKeys: Boolean);
PROCEDURE IncModemType(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE IncNodelist(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE IncBBSType(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncTaskType(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
PROCEDURE IncReqOnUs(VAR Value; ID: Word; Factor: Integer; VAR s:String);
PROCEDURE Configuration(Forced: Boolean; VAR Key: LongInt);

IMPLEMENTATION

USES Dos, OpCrt, OpEntry, OpDate, OpString, OpPick, OpWindow, OpCmd, OpFrame,
     OpSelect, OpKey, OpRoot,
     MailCfg, Globals, OproUtil, Util, StrUtil, Input, KeyBoard, Display,
     Resource, NetFile, RBrowser, PoPTypes, TextEdit, Newimp, NewExp, LogFile;

TYPE
  PColorSelector = ^TColorSelector;
  TColorSelector = OBJECT(PickList)
    Names : StringArrayPtr;

    CONSTRUCTOR Init(ANames: StringArrayPtr);
    PROCEDURE ItemString(Item: Word; Mode: PkMode; Var IType: PkItemType; var IString: string); Virtual;
  END;

  CONSTRUCTOR TColorSelector.Init(ANames: StringArrayPtr);
  BEGIN
    Names:=ANames;
    IF NOT INHERITED InitAbstract(20, 6, 60, 18, Cfg.Color[3],
                                  DefWindowOptions OR wBordered,
                                  40, Names^.NumStrings, PickVertical, SingleChoice) THEN
      Fail;
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    wFrame.AddHeader(' Select color scheme ', heTC);
    AddMoreHeader(' More   ', HeBR, #24, #25, '', 7, 8, 0);
    SetSearchMode(PickStringSearch);
    SetPadSize(1, 1);
  END;

  PROCEDURE TColorSelector.ItemString(Item: Word; Mode: PkMode; Var IType: PkItemType; Var IString: String);
  BEGIN
    Istring:=Trim(Copy(Names^.GetString(Item), 1, 40));
  END;


  PROCEDURE ReadNames(VAR Names: StringArrayPtr; CONST APath: PathStr);
  VAR
    ColorScheme : TColorScheme;
    f           : TNetFile;
    Sr          : SearchRec;
  BEGIN
    New(Names, Init(100, 2100));
    IF Names<>NIL THEN
    BEGIN
      FindFirst(AddBackSlash(APath)+'*.CLR', AnyFile, Sr);
      WHILE DOSError=0 DO
      BEGIN
        IF Sr.Size=SizeOf(TColorScheme) THEN
        BEGIN
          f.Open(AddBackSlash(APath)+Sr.Name, SizeOf(ColorScheme), False);
          f.GetRec(ColorScheme, 0, NoKeep, Wait);
          f.Close;
          Names^.AddString(Pad(ColorScheme.Desc, 40)+Sr.Name);
        END;
        IF Sr.Size=SizeOf(ColorSet)*4 THEN { Old version without desc.}
        BEGIN
          Names^.AddString(Pad(Sr.Name, 40)+Sr.Name);
        END;
        FindNext(Sr);
      END;
      FindClose(Sr);
    END ELSE
      AddLog('!', 'Not enough memory to read color schemes');
  END;


  PROCEDURE DoESR(VAR ESR: TPoPEntryScreen; VAR Win: WindowPtr);
  BEGIN
    Esr.SetPostEditProc(ConfigPostEdit);
    Esr.Process;
    Esr.Done;
    KillWindow(Win);
  END;

  PROCEDURE DisplayKeys(EditKeys: Boolean);
  VAR
    Win : WindowPtr;
  BEGIN
    GetESRAndWin(ESRFuncKeys,2,ESR,Win);
    ESR.SetPostEditProc(ConfigPostEdit);
    ESR.Draw;
    IF EditKeys THEN
    BEGIN
      Esr.Process;
    END ELSE
    BEGIN
      WaitForAction(3000);
    END;
    Esr.Done;
    KillWindow(Win);
  END;

  PROCEDURE SaveConfiguration;
  VAR
    f : FILE OF TConfig;
  BEGIN
    Assign(f, StartPath+PoPCfgFileName);
    Rewrite(f);
    Write(f,cfg);
    Close(f);
  END;

  PROCEDURE LoadConfiguration;
  VAR
    f : FILE OF TConfig;
  BEGIN
    Assign(f, StartPath+PoPCfgFileName); FileMode:=ShareRead+ShareDenyW;
    Reset(f);
    Read(f,cfg);
    IF IOResult<>0 THEN ;
    Close(f);
    CheckSnow:=Cfg.Screen.ChkSnow;
  END;

{--- EventEdit: Start -------------------------------------------------------}

  PROCEDURE EventPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF (ESR^.CurrentFieldModified) THEN Save:=True;
  END;

  FUNCTION _GetEventStr(VAR Buffer; VAR f: TNetFile): String; far;
  CONST
    YN : ARRAY[False..True] OF S3 = ('No ','Yes');
  VAR
    s   : STRING;
    x,y : Byte;
  BEGIN
    WITH TEvent(Buffer) DO
    BEGIN
      s:=LongintForm('###',f.FilePos)+' '+YN[(Active AND $80)=$80]+' '+LongintForm('###',TaskNumber)+' '+
         TimeToTimeString('hh:mm',Start)+' '+
         LongIntForm('###',InitExit)+' '+LongIntForm('###',MailExit)+' '+
         LongIntForm('###',PollExit)+' '+LongIntForm('###',FilesExit)+' ';
      y:=1;
      FOR x:=0 TO 6 DO
      BEGIN
        IF active AND y=y THEN s:=s+DayString[DayType(x+1-(Byte(x=6)*7))][1] ELSE s:=s+' ';
        y:=y SHL 1;
      END;
      s:=s+' '+CPad(Description,20);
    END;
    _GetEventStr:=s;
  END;

  FUNCTION EventFlagNames(typ: LongInt): STRING;
  VAR
    s:STRING;
  BEGIN
    IF typ AND  etForced<>0 THEN   s:='Forced ' ELSE s:='';
    IF typ AND  etRequests<>0 THEN s:=s+'Req ';
    IF typ AND  etUsers<>0 THEN    s:=s+'User ' ELSE s:=s+'Mail ';
    IF typ AND  etReceive<>0 THEN  s:=s+'Recv ';
    IF typ AND  etCrash<>0 THEN    s:=s+'CM ';
    IF typ AND  etNoSend<>0 THEN   s:=s+'No-Send ';
    IF typ AND  etDynamic<>0 THEN  s:=s+'Dynamic ';
    IF typ AND  etClrOut<>0 THEN   s:=s+'Clr.Out ';
    IF typ AND  etNoAnswer<>0 THEN s:=s+'No-Answer ';
    IF typ AND  etOnceOnly<>0 THEN s:=s+'Once-Only ';
    IF typ AND  etPoPList<>0 THEN  s:=s+'PoPList ';
    IF typ AND  etTossMail<>0 THEN s:=s+'Toss ';
    IF typ AND  etScanMail<>0 THEN s:=s+'Scan ';
    IF typ AND  etPackMail<>0 THEN s:=s+'Pack ';
    IF typ AND  etNoFiles<>0 THEN  s:=s+'No-Files ';
    EventFlagNames:=s;
  END;

  FUNCTION flagon(mask : Word) : S5;
  BEGIN
    IF mask=4 THEN
    BEGIN
      IF CurrentEvent.typ AND mask<>0 THEN flagon:='Users' ELSE flagon:='Mail ';
    END ELSE
      IF CurrentEvent.typ AND mask<>0 THEN flagon:='On ' ELSE flagon:='Off';
  END;

  procedure EventCustomStringProc(var Name : String; Key : LongInt;
                                  Selected, Highlighted : Boolean;
                                  WPtr : RawWindowPtr); far;
  var
    s : S5;
  begin
    s:=FlagOn(1 SHL (Key-1));
    Move(s[1], Name[Length(Name)-4], Length(s));
  end;


  PROCEDURE Edit_Flags;      { EDIT user Flags }
  VAR
    m     : TPoPMenu;
    key   : WORD;
  BEGIN
    Topic:=199;
    GetMenu(MNUEventFlags,3,m);
    M.SetCustomStringProc(EventCustomStringProc);
    REPEAT
      M.Process;
      Key:=M.MenuChoice;
      CASE Key OF
        1..15 : BEGIN
                  IF m.GetLastCommand<>ccQuit THEN
                  BEGIN
                    CurrentEvent.typ:=CurrentEvent.typ XOR (1 SHL (Key-1));
                    Save:=True;
                  END;
                END;
      END;
    UNTIL m.GetLastCommand=ccQuit;
    m.Done;
    Topic:=0;
  END;

  PROCEDURE _EditEvent(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
  VAR
    ExitCode:WORD;
  BEGIN
    Esr.Select;
    Esr.SetNextField(0);
    Esr.Draw;
    Save:=False;
    REPEAT
      Esr.Process;
      ExitCode:=ESR.GetLastCommand;
      CASE ExitCode OF
        ccUser7 : BEGIN
                    Edit_Flags;
                    ExitCode:=ccNone;
                  END;
      END;
    UNTIL (ExitCode=ccDone) OR (ExitCode=ccQuit);
    Changed:=Save;
  END;

  PROCEDURE _InitEvent(VAR Buffer); far;
  BEGIN
    FillChar(Buffer,SizeOf(TEvent),0);
    TEvent(Buffer).TaskNumber:=Cfg.TaskNumber;
    TEvent(Buffer).Tries.Bad:=5;
    TEvent(Buffer).Tries.Busy:=10;
    TEvent(Buffer).Active:=255;
  END;

  FUNCTION _IsGreaterEvent(VAR B1,B2): Boolean; far;
  BEGIN
    _IsGreaterEvent:=TEvent(B1).Start>TEvent(B2).Start;
  END;

  PROCEDURE _EventUpd(ASP: AbstractSelectorPtr); far;
  BEGIN
    FastWrite(CPad(EventFlagNames(CurrentEvent.Typ),42),19,21,Cfg.Color[2].FieldColor);
  END;

  PROCEDURE EventEdit;
  VAR
    ExitCode : Word;
    f        : TNetFile;

    PROCEDURE MakeEventScreen;
    BEGIN
      GetEsr(EsrEventSetup,2,Esr);
      ESR.SetPostEditProc(EventPostEdit);
      ESR.SetScreenUpdateProc(_EventUpd);
      EntryCommands.addcommand(ccUser7,1,WORD(256*65),0);
    END;

  BEGIN
    f.Open(StartPath+PoPEventFileName,SizeOf(TEvent),True);
    MakeEventScreen;
    BrowseRecords(f,CurrentEvent,ExitCode,'EVENT FILE',
                  'Ev# Ena Tsk Start Ini Mai Pol Fil Ev.Days Description',
                  _GetEventStr,_EditEvent,_InitEvent,_IsGreaterEvent);
    Esr.Done;
    f.GetRec(CurrentEvent,Data.Event-1,NoKeep,Wait);
    f.Close;
  END;


{=== EditEvent: End ======================================================== }

  PROCEDURE function_key_options;
  BEGIN
    DisplayKeys(True);
  END;

  PROCEDURE LoadColorScheme(CONST APath: PathStr);
  VAR
    f           : TNetFile;
    ColorScheme : TColorScheme;
    ColSel      : PColorSelector;
    Names       : StringArrayPtr;
    s           : STRING;
    i           : Byte;
  BEGIN
    ReadNames(Names, APath);
    IF Names^.NumStrings>0 THEN
    BEGIN
      New(ColSel, Init(Names));
      IF (ColSel<>NIL) THEN
      BEGIN
        ColSel^.Process;
        IF ColSel^.GetLastCommand<>ccquit THEN
        BEGIN
          s:=Names^.GetString(ColSel^.GetLastChoice);
          s:=Copy(s, 41, 12);
          f.Open(AddBackSlash(APath)+s, SizeOf(ColorScheme), False);
          f.GetRec(ColorScheme, 0, NoKeep, Wait);
          f.Close;
          FOR i:=1 TO 4 DO
            Cfg.Color[i]:=ColorScheme.Color[i];
          ConfigChanged:=True;
        END;
        Dispose(ColSel, Done);
      END;
    END;
    Dispose(Names, Done);
  END;

  PROCEDURE SaveColorScheme;
  VAR
    s : PathStr;
    f : TNetFile;
    i : Byte;
    ColorScheme : TColorScheme;
  BEGIN
    IF Cfg.TaskNumber=0 THEN s:='PORTAL.CLR' ELSE s:='PORTAL'+HexB(Cfg.TaskNumber)+'.CLR';
    s:=StartPath+s;
    IF InputString(5,10,70,50,3,'Save color scheme','Filename : ',s) THEN
    BEGIN
      IF f.Open(s, SizeOf(TColorScheme), True) THEN
      BEGIN
        FillChar(ColorScheme, SizeOf(ColorScheme), 0);
        FOR i:=1 TO 4 DO
          ColorScheme.Color[i]:=Cfg.Color[i];
        ColorScheme.Address:=Cfg.Addresses[Cfg.MainAdrNum];
        ColorScheme.MadeBy:=Cfg.Sysop;
        InputString(15,12,40,40,3,'Save color scheme','Desc : ', ColorScheme.Desc);
        f.Write(ColorScheme);
        f.Close;
      END;
    END;
  END;

  PROCEDURE ColorConfiguration;
  VAR
    farve    : ARRAY[1..4,1..31,1..2] OF BYTE;
    Temp     : WindowPtr;
    attr,
    level,
    farvenum : BYTE;
    InKey    : Word;
    s        : S10;
    Txt      : STRING;

    FUNCTION Name(Num:BYTE):S21;
    BEGIN
      CASE Num OF
        01 : Name:='Text';
        02 : Name:='Ctrl char';
        03 : Name:='Frame';
        04 : Name:='Header';
        05 : Name:='Shadow';
        06 : Name:='HighLight';
        07 : Name:='Prompt';
        08 : Name:='Selected prompt';
        09 : Name:='Protected prompt';
        10 : Name:='Field';
        11 : Name:='Selected field';
        12 : Name:='Protected field';
        13 : Name:='Scroll bar';
        14 : Name:='Slider';
        15 : Name:='Hot spot';
        16 : Name:='Block';
        17 : Name:='Marker';
        18 : Name:='Delimiter';
        19 : Name:='Selected delimiter';
        20 : Name:='Protected delimiter';
        21 : Name:='Selected item';
        22 : Name:='Protected item';
        23 : Name:='HighLight item';
        24 : Name:='Alternate select item';
        25 : Name:='Alt. selected item';
        26 : Name:='Flex A item';
        27 : Name:='Flex B item';
        28 : Name:='Flex C item';
        29 : Name:='UnSelected Xref item';
        30 : Name:='Selected Xref item';
        ELSE Name:='';
      END;
    END;

    PROCEDURE DisplaySample(i,colorno:BYTE);
    BEGIN
      IF i<16 THEN
        Temp^.wFastWrite(CPad(Name(i),24),i+1,2,colorno)
      ELSE
        Temp^.wFastWrite(CPad(Name(i),24),i-14,28,colorno);
    END;

    PROCEDURE DisplayLevel;
    VAR
      i:BYTE;
    BEGIN
      FOR i:=1 TO 30 DO
        DisplaySample(i,farve[level,i,1]);
      Temp^.wFastText('Current level: '+Long2Str(level),18,2);
    END;

    FUNCTION SelectAttribute(Cur:BYTE):BYTE;
    VAR
      w:WindowPtr;
      Inkey:WORD;
      x,y:BYTE;
    BEGIN
      mywin(w,44,9,79,18,0,'Select color',False);
      FOR y:=0 TO 7 DO
        FOR x:=0 TO 15 DO
          w^.wFastWrite('<>',y+1,(x*2)+2,x+(y*16));
      x:=Cur MOD 16;
      y:=Cur DIV 16;
      REPEAT
        w^.wFastText(#17#16,y+1,(x*2)+2);
        InKey:=PoPReadKeyWord;
        w^.wFastText('<>',y+1,(x*2)+2);
        CASE InKey OF
          Up    : BEGIN
                    REPEAT
                      IF y>0  THEN DEC(y) ELSE y:=7;
                    UNTIL y<>x;
                  END;
          Down  : BEGIN
                    REPEAT
                      IF y<7  THEN INC(y) ELSE y:=0;
                    UNTIL y<>x;
                  END;
          Left  : BEGIN
                    REPEAT
                      IF x>0  THEN DEC(x) ELSE x:=15;
                    UNTIL y<>x;
                  END;
          Right : BEGIN
                    REPEAT
                      IF x<15 THEN INC(x) ELSE x:=0;
                    UNTIL y<>x;
                  END;
        END;
        DisplaySample(farvenum,x+(16*y));
      UNTIL (InKey=ESC) OR (InKey=Enter);
      KillWindow(w);
      IF InKey=Enter THEN Cur:=x+(16*y);
      SelectAttribute:=Cur;
    END;

    PROCEDURE PlaceMarker(on:BOOLEAN);
    VAR
      ch1,ch2:CHAR;
    BEGIN
      IF on THEN
      BEGIN
        ch1:='>';
        ch2:='<';
      END ELSE
      BEGIN
        ch1:=' ';
        ch2:=' ';
      END;
      IF farvenum<16 THEN
      BEGIN
        Temp^.wFastWrite(ch1,FarveNum+1,1,7);
        Temp^.wFastWrite(ch2,FarveNum+1,26,7);
      END ELSE
      BEGIN
        Temp^.wFastWrite(ch1,FarveNum-14,27,7);
        Temp^.wFastWrite(ch2,FarveNum-14,52,7);
      END;
    END;

  BEGIN
{   hiddencursor;}
    mywin(Temp,1,2,80,ScreenHeight,0,'Color Configuration',False);
    MOVE(Cfg.Color[1].TextColor,Farve,31*4*2);
    level:=1;
    DisplayLevel;
    farvenum:=1;
    WITH Temp^ DO
    BEGIN
      wFastText('Left/Right/Up/Down selects another color, PgUp/PgDn selects screen level.',21, 2);
      wFastText('Return change color. Press F1 for more help on what the colors are used for',22, 2);
    END;
    REPEAT
      attr:=farve[level,farvenum,1];
      placemarker(True);
      Topic:=699+farvenum;
      InKey:=PopReadKeyWord;
      placemarker(False);
      CASE InKey OF
        Enter: BEGIN
                 attr:=SelectAttribute(attr);
                 farve[level,farvenum,1]:=attr;
                 farve[level,farvenum,2]:=attr;
                 MOVE(Farve,Cfg.Color,31*4*2);
                 ConfigChanged:=True;
                 DisplayLevel;
               END;
        Right,
        Left : IF farvenum>15 THEN DEC(farvenum,15) ELSE INC(farvenum,15);
        Up   : IF FarveNum>1 THEN DEC(farvenum) ELSE farvenum:=30;
        Down : IF FarveNum<30 THEN INC(farvenum) ELSE farvenum:=1;
        PgUp : BEGIN
                 DEC(level);
                 IF level<1 THEN level:=4;
                 DisplayLevel;
               END;
        PgDn : BEGIN
                 INC(level);
                 IF Level>4 THEN Level:=1;
                 DisplayLevel;
               END;
      END;
    UNTIL InKey=Esc;
    KillWindow(Temp);
  END;

  PROCEDURE MiscScreen;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMiscScreen,2,Esr,Win) ;
    DoEsr(Esr, Win);
    CheckSnow:=Cfg.Screen.ChkSnow;
  END;

  PROCEDURE IncModemType(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<7 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=7;
    END;
    S:=Cfg.NLCompiler.MTypeStr[Byte(Value)];
  END;

  PROCEDURE ConnectStatistics;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMdmConnStat,2,Esr,Win);
    DoEsr(ESR,Win);
  END;

  PROCEDURE AdvModemOptions;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrAdvMdmOptions,2,Esr,Win);
    DoEsr(ESR,Win);
  END;

  PROCEDURE ModemOptions;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMdmOptions,2,Esr,Win);
    DoEsr(ESR,Win);
  END;

  PROCEDURE IncNodelist(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<4 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=4;
    END;
    CASE Byte(Value) OF
      0 : s:='Version 6';
      1 : s:='QuickBBS';
      2 : s:='R.Access';
      3 : s:='Version 7';
      4 : s:='SuperBBS';
    END;
  END;

  PROCEDURE IncBBSType(VAR Value; ID: Word; Factor: Integer; VAR s: STRING);
  CONST
    MaxType = 7;
  BEGIN
    CASE Factor OF
      +1 : BEGIN
             INC(ShortInt(Value));
             IF ShortInt(Value)>MaxType THEN ShortInt(Value):=0;
           END;
      -1 : BEGIN
             DEC(ShortInt(Value));
             IF ShortInt(Value)<0 THEN ShortInt(Value):=MaxType;
           END;
    END;
    CASE Byte(Value) OF
      0 : s:='None';
      1 : s:='QuickBBS';
      2 : s:='ProBoard';
      3 : s:='Opus 1.10';
      4 : s:='R.Access';
      5 : s:='Opus 1.73+';
      6 : s:='SuperBBS';
      7 : s:='Maximus 2.0';
    END;
  END;

  PROCEDURE IncTaskType(VAR Value; ID: Word; Factor: Integer; VAR s: STRING);
  BEGIN
    CASE Factor OF
      +1 : BEGIN
             INC(ShortInt(Value));
             IF ShortInt(Value)>2 THEN ShortInt(Value):=0;
           END;
      -1 : BEGIN
             DEC(ShortInt(Value));
             IF ShortInt(Value)<0 THEN ShortInt(Value):=2;
           END;
    END;
    CASE Byte(Value) OF
      0 : s:='Normal';
      1 : s:='Function server';
      2 : s:='Function user';
    END;
  END;

  PROCEDURE DirectoryPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    WITH Esr^ DO
    BEGIN
      IF CurrentFieldModified THEN ConfigChanged:=True;
      CASE GetCurrentID OF
         0 : IF TestDirectoryPath(Esr^,Cfg.Inbound[nsUnKnown],True) THEN ConfigChanged:=True;
         1 : IF TestDirectoryPath(Esr^,Cfg.Inbound[nsKnown],True) THEN ConfigChanged:=True;
         2 : IF TestDirectoryPath(Esr^,Cfg.Inbound[nsPassword],True) THEN ConfigChanged:=True;
         3 : IF TestDirectoryPath(Esr^,Cfg.Outbound,False) THEN ConfigChanged:=True;
         4 : IF TestDirectoryPath(Esr^,Cfg.NodeList,True) THEN ConfigChanged:=True;
        11 : IF TestDirectoryPath(Esr^,Cfg.BBS.Path,True) THEN ConfigChanged:=True;
        12 : IF TestDirectoryPath(Esr^,Cfg.SwapDir,True) THEN ConfigChanged:=True;
      END;
    END;
  END;

  PROCEDURE directories;
  VAR
    FuncKeyWin : windowptr;
  BEGIN
    MyWin(FuncKeyWin, 1,ScreenHeight-1,80,ScreenHeight,2,'',False);
    WITH FuncKeyWin^, cfg.color[2] DO
    BEGIN
      wFastText('F1=Help        F2=Select      F3=Edit (banner)',1,2);
    END;
    GetEsr(EsrDirAndFiles,2,Esr);
    WITH Esr DO
    BEGIN
      SetPostEditProc(DirectoryPostEdit);
      EntryCommands.AddCommand(ccUser2, 1, F2, 0);
      EntryCommands.AddCommand(ccUser3, 1, F3, 0);
    END;
    REPEAT
      Esr.Process;
      CASE Esr.GetLastCommand OF
        ccUser2 : CASE Esr.GetCurrentId OF
                    5 : IF SelectFile(Cfg.BBS.UserFile) THEN ConfigChanged:=True;
                    6 : IF SelectFile(Cfg.LogFileName) THEN ConfigChanged:=True;
                    9 : IF SelectFile(Cfg.DefaultMacro) THEN ConfigChanged:=True;
                    10: IF SelectFile(Cfg.Editor) THEN ConfigChanged:=True;
                    14: IF SelectFile(Cfg.Banner) THEN ConfigChanged:=True;
                  END;
        ccUser3 : If (Esr.GetCurrentID = 14) and (Cfg.Banner<>'') Then RunTextEditor(Cfg.Banner);
      END;
    UNTIL (esr.getlastcommand=ccquit) OR (esr.getlastcommand=ccDone);
    Esr.Done;
    KillWindow(FuncKeyWin);
  END;

  PROCEDURE matrix_info;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMatrixInfo,2,esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE InboundControl;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrInboundToDoSetup, 2, Esr, Win);
    DoEsr(Esr, Win);
  END;

  PROCEDURE GlobalValues;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrGlobalVal,2,Esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE DumbTerminalSetup;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrDumbTermSetup,2,Esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE DumbTerminalExternalProtocols;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrDumbTermExt,2,Esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE NlCompPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF ESR^.GetLastCommand=ccUser2 THEN
    BEGIN
      CASE ESR^.GetCurrentID OF
        0 : SelectFile(Cfg.NLCompiler.CostFileName);
      END;
    END;
    IF ESR^.CurrentFieldModified THEN ConfigChanged:=True;
  END;

  PROCEDURE NodelistCompilerSetup;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrNLCompSetup,2,Esr,Win);
    WITH Esr DO
    BEGIN
      SetPostEditProc(NlCompPostEdit);
      REPEAT
        process;
      UNTIL GetLastCommand IN [ccDone,ccQuit];
    END;
    Esr.Done;
    KillWindow(Win);
  END;

FUNCTION _GetNLTStr(VAR Buffer; VAR f: TNetFile): String; far;
VAR
  s   : STRING;
BEGIN
  WITH TNLTranslat(Buffer) DO
  BEGIN
    s:=Pad(NumFrom,35)+NumTo;
  END;
  _GetNLTStr:=s;
END;

PROCEDURE _EditNLT(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
VAR
  ExitCode:WORD;
BEGIN
  Esr.Select;
  Esr.SetNextField(0);
  Esr.Draw;
  Save:=False;
  Esr.Process;
  Changed:=Save;
END;

PROCEDURE _InitNLT(VAR Buffer); far;
BEGIN
  FillChar(Buffer,SizeOf(TNLTranslat),0);
END;

FUNCTION _IsGreaterNLT(VAR B1,B2): Boolean; far;
BEGIN
  _IsGreaterNLT:=TNLTranslat(B1).NumFrom>TNLTranslat(B2).NumFrom;
END;

PROCEDURE NLTPostEdit(Esr: EntryScreenPtr); far;
BEGIN
  IF (ESR^.CurrentFieldModified) THEN Save:=True;
END;

PROCEDURE NodeListCompilerTranslationTable;
VAR
  ExitCode:WORD;
  NLT:TNLTranslat;
  p:POINTER;
  f : TNetFile;

  PROCEDURE MakeNLTScreen;
  BEGIN
    GetEsr(EsrNLTranslatSetup,2,Esr);
    Esr.SetPostEditProc(NLTPostEdit);
    p:=Esr.GetUserRecord;
  END;

BEGIN
  f.Open(StartPath+PoPNLTranslateFileName,SizeOf(TNLTranslat),True);
  MakeNLTScreen;
  BrowseRecords(f,p^,ExitCode,'Nodelist compiler: Translation table entries',
                Pad('Original',35)+'New',_GetNLTStr,_EditNLT,_InitNLT,_IsGreaterNLT);
  Esr.Done;
  f.Close;
END;

  PROCEDURE ConnectionPostEdit(Esr: EntryScreenPtr); far;
  BEGIN
    IF (ESR^.GetCurrentID=0) AND (ESR^.GetLastCommand=ccUser2) THEN
      IF SelectFile(Cfg.BiMail.BiModemPath) THEN ConfigChanged:=True;
    IF ESR^.CurrentFieldModified THEN ConfigChanged:=True;
  END;

  PROCEDURE ConnectionSetup;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrConnectionSetup,2,Esr,Win);
    WITH Esr DO
    BEGIN
      EntryCommands.AddCommand(ccUser2, 1, F2, 0);
      SetPostEditProc(ConnectionPostEdit);
      REPEAT
        Process;
      UNTIL GetLastCommand IN [ccDone,ccQuit];
    END;
    Esr.Done;
    KillWindow(Win);
  END;

  PROCEDURE AreaManagerConfiguration;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrAreaManSetup,2,esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE ListSetup;
  VAR
    FuncKeyWin : windowptr;
  BEGIN
    MyWin(FuncKeyWin, 1,ScreenHeight-1,80,ScreenHeight,2,'',False);
    WITH FuncKeyWin^, cfg.color[2] DO
    BEGIN
      wFastText('F1=Help        F2=Select',1,2);
    END;
    GetEsr(EsrListFiles,2,esr);
    WITH Esr DO
    BEGIN
      SetPostEditProc(ConfigPostEdit);
      EntryCommands.AddCommand(ccUser2, 1, F2, 0);
    END;
    REPEAT
      ESR.PROCESS;
      CASE Esr.GetLastCommand OF
        ccUser2 : CASE Esr.GetCurrentId OF
                    0 : IF SelectFile(Cfg.ListFiles.FileList) THEN ConfigChanged:=True;
                    1 : IF SelectFile(Cfg.ListFiles.NewsList) THEN ConfigChanged:=True;
                    2 : IF SelectFile(Cfg.ListFiles.Header) THEN ConfigChanged:=True;
                    3 : IF SelectFile(Cfg.ListFiles.Footer) THEN ConfigChanged:=True;
                    4 : IF SelectFile(Cfg.ListFiles.StatFile) THEN ConfigChanged:=True;
                    5 : IF SelectFile(Cfg.ListFiles.TopFile) THEN ConfigChanged:=True;
                    6 : IF SelectFile(Cfg.ListFiles.DoBefore) THEN ConfigChanged:=True;
                    7 : IF SelectFile(Cfg.ListFiles.DoPack) THEN ConfigChanged:=True;
                    8 : IF SelectFile(Cfg.ListFiles.DoAfter) THEN ConfigChanged:=True;
                  END;
      END;
    UNTIL (esr.getlastcommand=ccquit) OR (esr.getlastcommand=ccDone);
    Esr.Done;
    KillWindow(FuncKeyWin);
  END;

  PROCEDURE ListSetup2;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrListFiles2,2,esr,Win);
    DoEsr(Esr,Win);
  END;
FUNCTION _GetMFSStr(VAR Buffer; VAR f: TNetFile): String; far;
VAR
  s   : STRING;
BEGIN
  WITH TFileListSegment(Buffer) DO
  BEGIN
    s:=Pad(Name,22)+FileName;
  END;
  _GetMFSStr:=s;
END;

PROCEDURE _EditMFS(VAR Buffer; VAR Changed: Boolean; RecNum, MaxRec: LongInt); far;
VAR
  ExitCode:WORD;
BEGIN
  Esr.Select;
  Esr.SetNextField(0);
  Esr.Draw;
  Save:=False;
  REPEAT
    Esr.Process;
    CASE Esr.GetLastCommand OF
      ccUser2 : CASE Esr.GetCurrentId OF
                  1 : IF SelectFile(TFileListSegment(Buffer).FileName) THEN ConfigChanged:=True;
                  2 : IF SelectFile(TFileListSegment(Buffer).HeaderFile) THEN ConfigChanged:=True;
                END;
    END;
  UNTIL (esr.getlastcommand=ccquit) OR (esr.getlastcommand=ccDone);
  Changed:=Save or configChanged;
END;

PROCEDURE _InitMFS(VAR Buffer); far;
BEGIN
  FillChar(Buffer,SizeOf(TFileListSegment),0);
END;

FUNCTION _IsGreaterMFS(VAR B1,B2): Boolean; far;
BEGIN
  _IsGreaterMFS:=TFileListSegment(B1).Name>TFileListSegment(B2).Name;
END;

PROCEDURE MFSPostEdit(Esr: EntryScreenPtr); far;
BEGIN
  IF (ESR^.CurrentFieldModified) THEN Save:=True;
END;

  PROCEDURE MultiFilelistSetup;
  VAR
    ExitCode:WORD;
    p:POINTER;
    f : TNetFile;

    PROCEDURE MakeMFSScreen;
    BEGIN
      GetEsr(EsrMFSSetup,2,Esr);
      Esr.SetPostEditProc(MFSPostEdit);
      EntryCommands.AddCommand(ccUser2, 1, F2, 0);
      p:=Esr.GetUserRecord;
    END;

  BEGIN
    f.Open(StartPath+PoPListSegmentsName,SizeOf(TFileListSegment),True);
    MakeMFSScreen;
    BrowseRecords(f,p^,ExitCode,'Multiple Filelist Segments',
                  Pad('Name',22)+'FileName',_GetMFSStr,_EditMFS,_InitMFS,_IsGreaterMFS);
    Esr.Done;
    f.Close;
  END;

  PROCEDURE MultiBBSSetUp;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrMultiBBSSetup,2,esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE ArchiverSetUp;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrArcSetup,2,Esr,Win);
    DoEsr(Esr,Win);
  END;

  FUNCTION ReqOnUsStr(CONST ReqOnUs: TReqOnUs): S10;
  BEGIN
    CASE ReqOnUs OF
      ru_NoWay   : ReqOnUsStr:='No way!   ';
      ru_Always  : ReqOnUsStr:='Always    ';
      ru_Cost    : ReqOnUsStr:='Check cost';
      ELSE         ReqOnUsStr:='??????????';
    END;
  END;

  PROCEDURE IncReqOnUs(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    s:=ReqOnUsStr(TReqOnUs(Value));
  END;

  PROCEDURE RequestLimits;
  VAR
    Win : WindowPtr;
  BEGIN
    GetEsrAndWin(EsrReqLimits,2,Esr,Win);
    DoEsr(Esr,Win);
  END;

  PROCEDURE DisableItems;
  VAR
    i : LongInt;
  BEGIN
    FOR i:=100 TO 108 DO
      IF (i<>106) AND (i<>104) THEN MainMenu^.ProtectItem(i);
    MainMenu^.ProtectItem(ALTB);
    MainMenu^.ProtectItem(ALTL);
    MainMenu^.ProtectItem(ALTF);
    MainMenu^.Draw;
  END;

  PROCEDURE Configuration(Forced: Boolean; VAR Key: LongInt);
  VAR
    MustExit,
    SaveIt : Boolean;
    EventFile : TNetFile;
  BEGIN
    ConfigChanged:=False;
    MustExit:=False;
    IF NOT Forced THEN
    BEGIN
      LoadMainMenu;
      IF Key<=0 THEN
      BEGIN
        IF Key=-1 THEN DisableItems ELSE MainMenu^.Draw;
        MainMenu^.SelectSubMenu(1);
        Key:=0;
      END;
    END ELSE
    BEGIN
      IF NOT Confirm('Configure Portal from scratch','Y',11) THEN
      BEGIN
        FinishPortal;
        Halt;
      END;
      LoadColorScheme(StartPath);
      Key:=0;
      data.event:=1;
      FILLCHAR(CurrentEvent,SizeOf(CurrentEvent),0);
      WITH CurrentEvent DO
        active:=255;
      EventFile.Open(StartPath+PoPEventFileName,SizeOf(TEvent),True);
      EventFile.PutRec(CurrentEvent,0);
      EventFile.Close;
    END;
    REPEAT
      IF Forced THEN
      BEGIN
        CASE key OF
          0..2 : Inc(key);
          3    : Key:=34;
          34   : Key:=13;
          13   : Key:=14;
          14   : Key:=6;
          6    : Key:=0;
        END;
      END ELSE
        IF Key=0 THEN
        BEGIN
          MainMenuToggle;
          InMainMenu:=True;
          MainMenu^.Process;
          InMainMenu:=False;
          Key:=MainMenu^.MenuChoice;
          IF Key>100 THEN MainMenu^.EraseAllSubMenus(True, True);
          IF (Key<90) OR (Key>97) THEN MainMenu^.Erase;
        END;
      IF (Forced) OR (MainMenu^.GetLastCommand<>ccQuit) THEN
      BEGIN
        CASE key OF
          1 : matrix_info;
          2 : ModemOptions;
          3 : directories;
          4 : Nodes;
          5 : AdvModemOptions;
          6 : EventEdit;
          7 : ConnectStatistics;
          8 : LoadColorScheme(StartPath);
          9 : SaveColorScheme;
         10 : NodeListCompilerSetup;
         11 : Function_Key_Options;
         12 : GlobalValues;
         13 : ColorConfiguration;
         14 : MiscScreen;
         15 : NetMail;
         16 : EchoMail;
         17 : InboundControl;
         18 : SchedulerSetup;
         19 : BrowseAreas;
         20 : MiscOptions;
         21 : FilesToForward;
         22 : FwdMiscOptions;
         23 : DumbTerminalSetup;
         24 : DumbTerminalExternalProtocols;
         25 : ConnectionSetup;
         26 : AreaManagerConfiguration;
         27 : MultiBBSSetup;
         28 : ArchiverSetup;
         29 : NodeListCompilerTranslationTable;
         30 : EditOkFile;
         31 : RequestLimits;
         32 : TickAreas;
         33 : TickMisc;
         34 : NodeListSegSetup;
         35 : ListSetup;
         36 : ListSetup2;
         37 : IF Cfg.NlCompiler.CostFileName<>'' THEN
                RunTextEditor(Cfg.NlCompiler.CostFileName);
         38 : RunTextEditor(StartPath+PoPTemplateFIleName);
         39 : MultiFileListSetup;
        214 : ExportConfig;
        215 : ImportConfig;
         ELSE MustExit:=NOT Forced;
        END;
      END;
      IF NOT Forced AND NOT MustExit THEN Key:=0;
    UNTIL ((MainMenu<>NIL) AND (MainMenu^.GetLastCommand=ccQuit)) OR MustExit OR (Forced AND (key=0));
    IF Forced THEN
      Saveit:=True
    ELSE
      IF ConfigChanged THEN
        SaveIt:=Confirm('Save new configuration','Y',11)
      ELSE
        SaveIt:=False;
    IF SaveIt THEN SaveConfiguration ELSE LoadConfiguration;
    IF NOT MustExit THEN Key:=0;
  END;

END.
