unit Isdncall;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, rds_isdn, ExtCtrls, StdCtrls, Menus, Buttons, eazset,
  service,about,inifiles,callerid;

type
  TWatchform = class(TForm)
    ListBox1: TListBox;
    Header1: THeader;
    ISDNControl1: TISDNControl;
    Panel1: TPanel;
    ExitButton: TSpeedButton;
    SetEAZButton: TSpeedButton;
    SetServiceButton: TSpeedButton;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Einstellungen1: TMenuItem;
    N1: TMenuItem;
    Programmbeenden1: TMenuItem;
    ServiceEinstellungen1: TMenuItem;
    AboutButton: TSpeedButton;
    Hilfe1: TMenuItem;
    N2: TMenuItem;
    PfadzurCAPIDLL1: TMenuItem;
    SetCapiButton: TSpeedButton;
    OpenDialog1: TOpenDialog;
    SpeedButton1: TSpeedButton;
    Rufnummernbearbeiten1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ISDNControl1InComingCall(Sender: TObject; Service, EAZ: Byte;
      Anrufer, ServiceStr: String);
    procedure ExitButtonClick(Sender: TObject);
    procedure SetEAZButtonClick(Sender: TObject);
    procedure SetServiceButtonClick(Sender: TObject);
    procedure AboutButtonClick(Sender: TObject);
    procedure SetCapiButtonClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private-Deklarationen }
    procedure DeActivateCapi;
    procedure ActivateCapi;
    procedure WriteCapiDir;
    procedure ReadCapiDir;
    procedure ReadCapiService;
    procedure WriteCapiService;
    procedure ReadEAZ;
    procedure WriteEAZ;

  public
    { Public-Deklarationen }
    ISDNIni:TIniFile;
    CapiDir:String;
  end;

var
  Watchform: TWatchform;

implementation

{$R *.DFM}

procedure TWatchform.FormCreate(Sender: TObject);
begin
 Hilfe1.Caption:=#8+Hilfe1.Caption;
 ReadCapiDir;
 ReadCapiService;
 ReadEAZ;
 ActivateCapi;
 ListBox1.Items.Add(DateToStr(Date)+' '+TimeToStr(Time)+'   ISDN-Watch gestartet');
end;

procedure TWatchform.ISDNControl1InComingCall(Sender: TObject; Service,
  EAZ: Byte; Anrufer, ServiceStr: String);
var CallerStr:String;
begin
 If WatchForm.WindowState=wsMinimized then
  WatchForm.WindowState:=wsNormal;

 ISDNIni := TIniFile.Create('ISDN.INI');
 CallerStr:=ISDNIni.ReadString('CallerIn',Anrufer,'');
 ISDNIni.Free;

 if CallerStr<>'' then
  ListBox1.Items.Add(DateToStr(Date)+' '+TimeToStr(Time)+'  '+Anrufer
                     +' ['+Callerstr+']'+
                     +'  Calling EAZ '+Chr(EAZ)+' ('+ServiceStr+')')
 else
  ListBox1.Items.Add(DateToStr(Date)+' '+TimeToStr(Time)+'  '+Anrufer
                     +'  Calling EAZ '+Chr(EAZ)+' ('+ServiceStr+')');
end;

procedure TWatchform.ExitButtonClick(Sender: TObject);
begin
 application.terminate;
end;

procedure TWatchform.SetEAZButtonClick(Sender: TObject);
var I:Integer;
begin
 with EAZDialog do
  begin
   SrcList.Clear;
   DstList.Clear;
   if EAZ0 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 0') else SrcList.Items.Add('EAZ 0');
   if EAZ1 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 1') else SrcList.Items.Add('EAZ 1');
   if EAZ2 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 2') else SrcList.Items.Add('EAZ 2');
   if EAZ3 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 3') else SrcList.Items.Add('EAZ 3');
   if EAZ4 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 4') else SrcList.Items.Add('EAZ 4');
   if EAZ5 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 5') else SrcList.Items.Add('EAZ 5');
   if EAZ6 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 6') else SrcList.Items.Add('EAZ 6');
   if EAZ7 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 7') else SrcList.Items.Add('EAZ 7');
   if EAZ8 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 8') else SrcList.Items.Add('EAZ 8');
   if EAZ9 in ISDNControl1.EAZin then
    DstList.Items.Add('EAZ 9') else SrcList.Items.Add('EAZ 9');
   if SrcList.Items.Count>0 then
    begin
     IncludeBtn.Enabled:=True;
     IncAllBtn.Enabled:=True;
    end else
     begin
      IncludeBtn.Enabled:=False;
      IncAllBtn.Enabled:=False;
     end;
   if DstList.Items.Count>0 then
    begin
     ExcludeBtn.Enabled:=True;
     ExAllBtn.Enabled:=True;
    end else
     begin
      ExcludeBtn.Enabled:=False;
      ExAllBtn.Enabled:=False;
     end;
  end;

 if EAZDialog.Showmodal=mrOk then
  begin
   ISDNControl1.Clear_Listen_Request;

   with EAZDialog do
    begin
     ISDNControl1.EAZIn:=[];
     for i:=0 to DstList.Items.Count-1 do
      begin
       if DstList.Items[i]='EAZ 0' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ0] else
       if DstList.Items[i]='EAZ 1' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ1] else
       if DstList.Items[i]='EAZ 2' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ2] else
       if DstList.Items[i]='EAZ 3' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ3] else
       if DstList.Items[i]='EAZ 4' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ4] else
       if DstList.Items[i]='EAZ 5' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ5] else
       if DstList.Items[i]='EAZ 6' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ6] else
       if DstList.Items[i]='EAZ 7' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ7] else
       if DstList.Items[i]='EAZ 8' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ8] else
       if DstList.Items[i]='EAZ 9' then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ9];
      end;
    end; { with EAZDialog do }

   WriteEAZ;
   ISDNControl1.Listen_Request;
  end; { if Dialog.Showmodal=mrOk then }
end;

procedure TWatchform.SetServiceButtonClick(Sender: TObject);
var I:Integer;
begin
 with ServiceDialog do
  begin
   SrcList.Clear;
   DstList.Clear;
   if BildTelefon in ISDNControl1.InService then
    DstList.Items.Add('BildTelefon') else SrcList.Items.Add('BildTelefon');
   if Telefon in ISDNControl1.InService then
    DstList.Items.Add('Telefon') else SrcList.Items.Add('Telefon');
   if AB_Dienste in ISDNControl1.InService then
    DstList.Items.Add('AB_Dienste') else SrcList.Items.Add('AB_Dienste');
   if X21_Dienste in ISDNControl1.InService then
    DstList.Items.Add('X21_Dienste') else SrcList.Items.Add('X21_Dienste');
   if TeleFax_Grp4 in ISDNControl1.InService then
    DstList.Items.Add('TeleFax_Grp4') else SrcList.Items.Add('TeleFax_Grp4');
   if Bildschirmtext in ISDNControl1.InService then
    DstList.Items.Add('Bildschirmtext') else SrcList.Items.Add('Bildschirmtext');
   if Datenuebertragung in ISDNControl1.InService then
    DstList.Items.Add('Datenuebertragung') else SrcList.Items.Add('Datenuebertragung');
   if X25_Dienste in ISDNControl1.InService then
    DstList.Items.Add('X25_Dienste') else SrcList.Items.Add('X25_Dienste');
   if Teletex_64 in ISDNControl1.InService then
    DstList.Items.Add('Teletex_64') else SrcList.Items.Add('Teletex_64');
   if Mixed_Mode in ISDNControl1.InService then
    DstList.Items.Add('Mixed_Mode') else SrcList.Items.Add('Mixed_Mode');
   if Fernwirken in ISDNControl1.InService then
    DstList.Items.Add('Fernwirken') else SrcList.Items.Add('Fernwirken');
   if Grafiktelefon in ISDNControl1.InService then
    DstList.Items.Add('Grafiktelefon') else SrcList.Items.Add('Grafiktelefon');
   if BTX_NeuerStandard in ISDNControl1.InService then
    DstList.Items.Add('BTX_NeuerStandard') else SrcList.Items.Add('BTX_NeuerStandard');
   if SrcList.Items.Count>0 then
    begin
     IncludeBtn.Enabled:=True;
     IncAllBtn.Enabled:=True;
    end else
     begin
      IncludeBtn.Enabled:=False;
      IncAllBtn.Enabled:=False;
     end;
   if DstList.Items.Count>0 then
    begin
     ExcludeBtn.Enabled:=True;
     ExAllBtn.Enabled:=True;
    end else
     begin
      ExcludeBtn.Enabled:=False;
      ExAllBtn.Enabled:=False;
     end;

 if ServiceDialog.Showmodal=mrOk then
  begin
   ISDNControl1.Clear_Listen_Request;

   with ServiceDialog do
    begin
     ISDNControl1.InService:=[];
     for i:=0 to DstList.Items.Count-1 do
      begin
       if DstList.Items[i]='BildTelefon' then
        ISDNControl1.InService:=ISDNControl1.InService+[BildTelefon] else
       if DstList.Items[i]='Telefon' then
        ISDNControl1.InService:=ISDNControl1.InService+[Telefon] else
       if DstList.Items[i]='AB_Dienste' then
        ISDNControl1.InService:=ISDNControl1.InService+[AB_Dienste] else
       if DstList.Items[i]='X21_Dienste' then
        ISDNControl1.InService:=ISDNControl1.InService+[X21_Dienste] else
       if DstList.Items[i]='TeleFax_Grp4' then
        ISDNControl1.InService:=ISDNControl1.InService+[TeleFax_Grp4] else
       if DstList.Items[i]='Bildschirmtext' then
        ISDNControl1.InService:=ISDNControl1.InService+[Bildschirmtext] else
       if DstList.Items[i]='Datenuebertragung' then
        ISDNControl1.InService:=ISDNControl1.InService+[Datenuebertragung] else
       if DstList.Items[i]='X25_Dienste' then
        ISDNControl1.InService:=ISDNControl1.InService+[X25_Dienste] else
       if DstList.Items[i]='Teletex_64' then
        ISDNControl1.InService:=ISDNControl1.InService+[Teletex_64] else
       if DstList.Items[i]='Mixed_Mode' then
        ISDNControl1.InService:=ISDNControl1.InService+[Mixed_Mode] else
       if DstList.Items[i]='Fernwirken' then
        ISDNControl1.InService:=ISDNControl1.InService+[Fernwirken] else
       if DstList.Items[i]='Grafiktelefon' then
        ISDNControl1.InService:=ISDNControl1.InService+[Grafiktelefon] else
       if DstList.Items[i]='BTX_NeuerStandard' then
        ISDNControl1.InService:=ISDNControl1.InService+[BTX_NeuerStandard];
      end;

    end; { with ServiceDialog do }

   WriteCapiService;
   ISDNControl1.Listen_Request;
  end; { if Dialog.Showmodal=mrOk then }
 end;
end;

procedure TWatchform.AboutButtonClick(Sender: TObject);
begin
 AboutBox.Showmodal;
end;

procedure TWatchform.SetCapiButtonClick(Sender: TObject);
begin
 OpenDialog1.InitialDir:=CapiDir;
 if Opendialog1.execute then
  begin
   DeActivateCapi;
   Capidir:=ExtractFilePath(OpenDialog1.FileName);
   WriteCapiDir;
   ReadCapiDir;
   ActivateCapi;
  end;
end;


procedure TWatchform.WriteCapiDir;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');
 ISDNIni.WriteString('Einstellungen', 'CapiDir', CapiDir);
 ISDNIni.Free;
end;

procedure TWatchform.ReadCapiDir;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');
 CapiDir:=ISDNIni.ReadString('Einstellungen', 'CapiDir', '');
 ISDNIni.Free;
 ISDNControl1.CapiDir:=CapiDir;
end;


procedure TWatchform.ActivateCapi;
begin
 ISDNControl1.Active:=True;
 ISDNControl1.Signal:=True;
 ISDNControl1.Listen_Request;
 Header1.Sections.Clear;
 Header1.Sections.Add(' '+ISDNControl1.MANUFACTURER+' ');
 Header1.Sections.Add(' '+ISDNControl1.VERSION+' ');
 Header1.Sections.Add(' AppID='+inttostr(ISDNControl1.appid)+' ');
end;

procedure TWatchform.DeActivateCapi;
begin
 ISDNControl1.Clear_Listen_Request;
 ISDNControl1.Signal:=False;
 ISDNControl1.Active:=False;
 Header1.Sections.Clear;
 Header1.Sections.Add('  ');
 Header1.Sections.Add('  ');
 Header1.Sections.Add('  ');
end;

procedure TWatchform.ReadCapiService;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');
 ISDNControl1.InService:=[];
 if ISDNIni.ReadBool('InService', 'BildTelefon', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[BildTelefon];
 if ISDNIni.ReadBool('InService', 'Telefon', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Telefon];
 if ISDNIni.ReadBool('InService', 'AB_Dienste', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[AB_Dienste];
 if ISDNIni.ReadBool('InService', 'X21_Dienste', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[X21_Dienste];
 if ISDNIni.ReadBool('InService', 'TeleFax_Grp4', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[TeleFax_Grp4];
 if ISDNIni.ReadBool('InService', 'Bildschirmtext', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Bildschirmtext];
 if ISDNIni.ReadBool('InService', 'Datenuebertragung', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Datenuebertragung];
 if ISDNIni.ReadBool('InService', 'X25_Dienste', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[X25_Dienste];
 if ISDNIni.ReadBool('InService', 'Teletex_64', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Teletex_64];
 if ISDNIni.ReadBool('InService', 'Mixed_Mode', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Mixed_Mode];
 if ISDNIni.ReadBool('InService', 'Fernwirken', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Fernwirken];
 if ISDNIni.ReadBool('InService', 'Grafiktelefon', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[Grafiktelefon];
 if ISDNIni.ReadBool('InService', 'BTX_NeuerStandard', False) then
  ISDNControl1.InService:=ISDNControl1.InService+[BTX_NeuerStandard];
 ISDNIni.Free;
end;

procedure TWatchform.WriteCapiService;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');

 ISDNIni.WriteBool('InService','BildTelefon',(BildTelefon in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Telefon',(Telefon in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','AB_Dienste',(AB_Dienste in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','X21_Dienste',(X21_Dienste in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','TeleFax_Grp4',(TeleFax_Grp4 in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Bildschirmtext',(Bildschirmtext in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Datenuebertragung',(Datenuebertragung in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','X25_Dienste',(X25_Dienste in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Teletex_64',(Teletex_64 in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Mixed_Mode',(Mixed_Mode in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Fernwirken',(Fernwirken in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','Grafiktelefon',(Grafiktelefon in ISDNControl1.InService));
 ISDNIni.WriteBool('InService','BTX_NeuerStandard',(BTX_NeuerStandard in ISDNControl1.InService));

 ISDNIni.Free;
end;


procedure TWatchform.WriteEAZ;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');

 ISDNIni.WriteBool('EAZIn','EAZ0',(EAZ0 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ1',(EAZ1 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ2',(EAZ2 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ3',(EAZ3 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ4',(EAZ4 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ5',(EAZ5 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ6',(EAZ6 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ7',(EAZ7 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ8',(EAZ8 in ISDNControl1.EAZIn));
 ISDNIni.WriteBool('EAZIn','EAZ9',(EAZ9 in ISDNControl1.EAZIn));

 ISDNIni.Free;
end;


procedure TWatchform.ReadEAZ;
begin
 ISDNIni := TIniFile.Create('ISDN.INI');
 ISDNControl1.EAZIn:=[];

 if ISDNIni.ReadBool('EAZIn','EAZ0',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ0];
 if ISDNIni.ReadBool('EAZIn','EAZ1',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ1];
 if ISDNIni.ReadBool('EAZIn','EAZ2',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ2];
 if ISDNIni.ReadBool('EAZIn','EAZ3',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ3];
 if ISDNIni.ReadBool('EAZIn','EAZ4',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ4];
 if ISDNIni.ReadBool('EAZIn','EAZ5',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ5];
 if ISDNIni.ReadBool('EAZIn','EAZ6',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ6];
 if ISDNIni.ReadBool('EAZIn','EAZ7',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ7];
 if ISDNIni.ReadBool('EAZIn','EAZ8',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ8];
 if ISDNIni.ReadBool('EAZIn','EAZ9',False) then ISDNControl1.EAZIn:=ISDNControl1.EAZIn+[EAZ9];

 ISDNIni.Free;
end;

procedure TWatchform.ListBox1DblClick(Sender: TObject);
var tempstring:string;
    nummer:string;
    name:string;
begin
 if ListBox1.itemindex>0 then
  begin
   tempstring:=ListBox1.Items[Listbox1.ItemIndex];
   delete(tempstring,1,19);
   name:='';
   nummer:=copy(tempstring,1,pred(pos(' ',tempstring)));
   delete(tempstring,1,length(nummer)+1);
   if pos('[',tempstring) > 0 then
    begin
      delete(tempstring,1,1);
      name:=copy(tempstring,1,pred(pos(']',tempstring)));
    end;
   Callername.edit1.text:=nummer;
   Callername.edit2.text:=name;
   if callername.showmodal=mrOK then
    begin
     ISDNIni := TIniFile.Create('ISDN.INI');
     ISDNIni.WriteString('CallerIn', Nummer, Callername.edit2.text);
     ISDNIni.Free;
    end;

  end;
end;

procedure TWatchform.ListBox1KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then ListBox1DblClick(sender);
end;

end.
