unit Disdn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RDS_ISDN, ExtCtrls, FileCtrl, Menus, Buttons,
  Tabs, ISDN_Z,zdialog, Isterm;



type
  TTISDN_InfoForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    N1: TMenuItem;
    Programmende1: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Edit1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    ISDNControl1: TISDNControl;
    Edit2: TEdit;
    ISDN_ZModem1: TISDN_ZModem;
    TerminalWindow1: TTerminalWindow;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Button2: TButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    Senden: TMenuItem;
    Empfangen: TMenuItem;
    Verbindung1: TMenuItem;
    Herstellen1: TMenuItem;
    Beenden1: TMenuItem;
    Funktion1: TMenuItem;
    Namensenden1: TMenuItem;
    Passwortsenden1: TMenuItem;
    Button3: TButton;
    Button5: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Programmende1Click(Sender: TObject);
    procedure SpeedButton1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure WaehlenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AuflegenClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ISDNControl1B3DisConnection(Sender: TObject);
    procedure ISDNControl1Connection(Sender: TObject);
    procedure ISDNControl1DataReceived(Sender: TObject);
    procedure ISDNControl1DataSent(Sender: TObject);
    procedure ISDNControl1DisConnection(Sender: TObject);
    procedure ISDNControl1Schicht1Connect(Sender: TObject);
    procedure ISDNControl1Schicht2Connect(Sender: TObject);
    procedure ISDNControl1Schicht3Connect(Sender: TObject);
    procedure EmpfangenClick(Sender: TObject);
    procedure EscapeClick(Sender: TObject);
    procedure UsernameClick(Sender: TObject);
    procedure ISDN_ZModem1Status(Sender: TObject; FileSize:Longint;
      TransTime:TDateTime; TransCount, TransByte: Longint; TransName, TransCheck,
      TransMessage: String; TransTotal, TransBlockSize, Transerror: Word);
    procedure ISDN_ZModem1Exit(Sender: TObject);
    procedure EnterClick(Sender: TObject);
    procedure PasswortClick(Sender: TObject);
    procedure SendenClick(Sender: TObject);
    procedure NClick(Sender: TObject);
    procedure JClick(Sender: TObject);
    procedure RauteClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    ReadyToSend:Boolean;
    KeyBuf:Char;
    name:string;
  end;

var
  TISDN_InfoForm: TTISDN_InfoForm;

implementation

uses wincrt;

{$R *.DFM}

procedure TTISDN_InfoForm.Programmende1Click(Sender: TObject);
begin
 Application.Terminate;
end;

procedure TTISDN_InfoForm.SpeedButton1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 Application.Terminate;
end;

procedure TTISDN_InfoForm.WaehlenClick(Sender: TObject);
begin
 TerminalWindow1.ClrScr;
 ISDNControl1.DestAddress:=Edit1.Text;
 shape1.brush.color:=clwhite;
 shape2.brush.color:=clwhite;
 shape3.brush.color:=clwhite;
 { Verbindung aufbauen lassen }
 ISDNControl1.Connect_Request;
 Edit2.SetFocus;
end;


procedure TTISDN_InfoForm.FormActivate(Sender: TObject);
begin
 shape1.brush.color:=clgray;
 shape2.brush.color:=clgray;
 shape3.brush.color:=clgray;
 ISDNControl1.Active:=True;
 if ISDNControl1.Installed then
  begin
   panel1.caption:=' Capi-Information: ['+ISDNControl1.MANUFACTURER+']   ['
                  +ISDNControl1.VERSION+']   [AppID='+inttostr(ISDNControl1.appid)+']';
   ISDNControl1.Signal:=True;
  end else
   panel1.caption:=' ISDN nicht verfgbar: CAPI Connect Verbindung konnte nicht hergestellt werden';
end;

procedure TTISDN_InfoForm.AuflegenClick(Sender: TObject);
begin
 { bestehende B3 Verbindung abbauen ...
   Schicht 1 und Schicht 2 werden von TISDNControl automatisch abgebaut }
 ISDNControl1.Disconnect_B3_Request;
end;

procedure TTISDN_InfoForm.Button3Click(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:=#13;
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
 Edit2.SetFocus;
end;

procedure TTISDN_InfoForm.ISDNControl1Connection(Sender: TObject);
begin
 label3.caption:='ONLINE';
 SpeedButton3.Enabled:=True;
 SpeedButton2.Enabled:=False;
 SpeedButton4.Enabled:=True;
 SpeedButton5.Enabled:=True;
 ReadyToSend:=True;

 Senden.Enabled:=True;
 Empfangen.Enabled:=True;
 Herstellen1.Enabled:=False;
 Beenden1.Enabled:=True;
 Funktion1.Enabled:=True;
 Namensenden1.Enabled:=True;
 Passwortsenden1.Enabled:=True;

 Edit2.SetFocus;
end;

procedure TTISDN_InfoForm.ISDNControl1DataReceived(Sender: TObject);
var Laenge:Word;
    L,R:Longint;
    Start,P:PChar;
    SRect,DRect:TRect;
    Ausgabe:String;
    Block:Byte;
begin
 Ausgabe:='';
 Block:=ISDNControl1.ReceivedBlock;
 P:=StrAlloc(2049);
 Start:=P;
 StrMove(#0,P,1);
 { empfangene Daten abholen }
 ISDNControl1.GetReceivedData(P,Laenge);

 { ab mit den infos ins terminalfenster zum anzeigen der empfangenen Daten
   und parsen von ansi-sequenzen }
 TerminalWindow1.Write(p,laenge);

 StrDispose(P);


 { dem ISDNControl mitteilen das wir wieder empfangen koennen }
 ISDNControl1.Data_B3_Resp(Block);
 Edit2.SetFocus;
end;

procedure TTISDN_InfoForm.ISDNControl1DataSent(Sender: TObject);
begin
 ReadyToSend:=True;
end;

procedure TTISDN_InfoForm.ISDNControl1DisConnection(Sender: TObject);
begin
 label3.caption:='OFFLINE';
 SpeedButton3.Enabled:=False;
 SpeedButton2.Enabled:=True;
 SpeedButton4.Enabled:=False;
 SpeedButton5.Enabled:=False;
 shape1.brush.color:=clgray;
 shape2.brush.color:=clgray;
 shape3.brush.color:=clgray;

 Senden.Enabled:=False;
 Empfangen.Enabled:=False;
 Herstellen1.Enabled:=True;
 Beenden1.Enabled:=False;
 Funktion1.Enabled:=False;
 Namensenden1.Enabled:=False;
 Passwortsenden1.Enabled:=False;

 ReadyToSend:=False;
end;

procedure TTISDN_InfoForm.ISDNControl1Schicht1Connect(Sender: TObject);
begin
 shape1.brush.color:=clred;
end;

procedure TTISDN_InfoForm.ISDNControl1Schicht2Connect(Sender: TObject);
begin
 shape2.brush.color:=clyellow;
end;

procedure TTISDN_InfoForm.ISDNControl1Schicht3Connect(Sender: TObject);
begin
 shape3.brush.color:=clgreen;
end;

procedure TTISDN_InfoForm.ISDNControl1B3DisConnection(Sender: TObject);
begin
 shape3.brush.color:=clgray;
end;

procedure TTISDN_InfoForm.EmpfangenClick(Sender: TObject);
begin
 zstatusdlg.abbruch:=false;
 zstatusdlg.caption:='Empfangen einer Datei';
 zstatusdlg.label6.caption:='Empfangen';
 ZStatusdlg.show;
 ISDN_ZModem1.receivefile;
end;

procedure TTISDN_InfoForm.EscapeClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:=#27;
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

procedure TTISDN_InfoForm.UsernameClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:=#27;
 name:='Isdn User'+#13#10;
 name:='Rolf Rother'+#13#10;
 ISDNControl1.Data_B3_Req(@name,1,length(name));
end;

procedure TTISDN_InfoForm.ISDN_ZModem1Status(Sender: TObject; FileSize:Longint;
  TransTime:TDateTime; TransCount, TransByte: Longint; TransName, TransCheck,
  TransMessage: String; TransTotal, TransBlockSize, Transerror: Word);
begin
 if not ZStatusdlg.abbruch then
  begin
   with ZStatusdlg do
    begin
     FTransName.caption:=TransName;
     FFileSize.caption:=inttostr(FileSize);
     FTransByte.caption:=inttostr(TransByte);
     FTransCheck.caption:=TransCheck;
     FTransMessage.caption:=TransMessage;
     FTransTime.caption:=timetostr(TransTime);
     FTransCount.caption:=inttostr(TransCount);
     FTransTotal.caption:=inttostr(TransTotal);
     FTransBlockSize.caption:=inttostr(TransBlockSize);
     FTranserror.caption:=inttostr(Transerror);
     restfile.caption:=inttostr(FileSize-TransByte);
    end;
   ZStatusdlg.Update;
  end else isdn_zmodem1.userkey:=#27;
end;

procedure TTISDN_InfoForm.ISDN_ZModem1Exit(Sender: TObject);
begin
 ZStatusdlg.visible:=false;
 TerminalWindow1.WatchZModem:=True;
end;

procedure TTISDN_InfoForm.EnterClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:=#13;
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

procedure TTISDN_InfoForm.PasswortClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:=#27;
 name:='Isdn'+#13#10;
 name:='Radio'+#13#10;
 ISDNControl1.Data_B3_Req(@name,1,length(name));
end;

procedure TTISDN_InfoForm.SendenClick(Sender: TObject);
begin
 if OpenDialog1.Execute then
  begin
   ISDN_ZModem1.SendeDatei:=Opendialog1.Filename;
   zstatusdlg.abbruch:=false;
   zstatusdlg.caption:='Senden einer Datei';
   zstatusdlg.label6.caption:='Gesendet';
   ZStatusdlg.show;
   ISDN_ZModem1.Sendfile;
  end;
end;

procedure TTISDN_InfoForm.NClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:='N';
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

procedure TTISDN_InfoForm.JClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:='J';
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

procedure TTISDN_InfoForm.RauteClick(Sender: TObject);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 KeyBuf:='#';
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

procedure TTISDN_InfoForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
 repeat Application.ProcessMessages; until ReadyToSend;
 ReadyToSend:=False;
 KeyBuf:=Key;
 ISDNControl1.Data_B3_Req(@KeyBuf,1,1);
end;

end.
