/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_HANDLECHUNK__
#define __LB_HANDLECHUNK__

#ifndef __LB_DATACHUNK__
#include "LB_DataChunk.h"
#endif

/*
	LB_HandleChunk for data chunks allocated as handles.
 */
 
class LB_HandleChunk:public LB_DataChunk
{
protected:
	char			lbh_oldState;
	
protected:
	LB_HandleChunk();
	
public:	// From LB_DataChunk.
	virtual SN_Error RetrieveData(LB_ChunkData& rChunkData);
	virtual SN_Error DestroyData();
	virtual SN_Error ReleaseData(LB_DataReference dataReference);
	virtual Boolean MyDependancy(LB_DataReference dataReference);
	virtual Boolean IsValidData(LB_DataReference dataReference);
	virtual LB_DataSize GetDataSize();
	virtual LB_DataSize SetDataSize(LB_DataSize newSize);
	virtual LB_DataReference GetRealData();
	
public:
	LB_HandleChunk(Handle hData);
	LB_HandleChunk(LB_DataSize dataSize);
	virtual ~LB_HandleChunk();
	
	virtual Handle GetHandle() { return ((Handle) GetData()); };
};

#endif
