package bmsi.awt;

import java.awt.TextArea;
import java.io.OutputStream;
import java.io.PrintStream;

public class TextLog extends TextArea {
  public TextLog(int rows,int cols) {
    super("",rows,cols);
    setEditable(false);
  }
  class Stream extends OutputStream {
    private StringBuffer buf = new StringBuffer();
    public void write(int b) {
      buf.append((char)b);
    }
    public void write(byte[] b,int off,int len) {
      for (int i = 0; i < len; ++i)
	buf.append((char)b[off+i]);
    }
    public void flush() {
      appendText(buf.toString());
      buf.setLength(0);
    }
  }
  public PrintStream getPrintStream() {
    return new PrintStream(new Stream(),true);
  }
}
