
#include "stdafx.h"
#include "dcontxt.h"
#include "MainFrm.h"	// Class CMainFrame

#undef AFX_DATA
#define AFX_DATA AFX_CORE_DATA

#undef _MAC

#include "afximpl.h"		// definiton of afxData

#define HORZF(dw) (dw & CBRS_ORIENT_HORZ)
#define VERTF(dw) (dw & CBRS_ORIENT_VERT)

#define m_rectRequestedSize     m_rectDragHorz
#define m_rectActualSize        m_rectDragVert
#define m_rectActualFrameSize   m_rectFrameDragHorz
#define m_rectFrameBorders      m_rectFrameDragVert

void CMyDockContext::GetDimsFromPoint (CRect& rect, CPoint pt) 
{

   UINT uState = ABE_FLOAT;   // Assume that the AppBar is floating

   // Let's get floating out of the way first

   // Get the rectangle that bounds the size of the screen
   // minus any docked (but not-autohidden) AppBars.
   CRect rc, rcSav;
   ::SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);

   rcSav = rc;
   // Leave a 1/2 width/height-of-a-scrollbar gutter around the workarea
   rc.InflateRect(-GetSystemMetrics(SM_CXVSCROLL), -GetSystemMetrics(SM_CYHSCROLL));

   if (rc.PtInRect(pt)) 
   {
		// If the point is in the adjusted workarea
	   return; 
   }

   // If we get here, the AppBar should be docked; determine the proper edge

   // Get the dimensions of the screen
   int cxScreen = GetSystemMetrics(SM_CXSCREEN);
   int cyScreen = GetSystemMetrics(SM_CYSCREEN);

   // Find the center of the screen
   CPoint ptCenter(cxScreen / 2, cyScreen / 2);

   // Find the distance from the point to the center
   CPoint ptOffset = pt - ptCenter;

   // Determine if the point is farther from the left/right or top/bottom
   BOOL fIsLeftOrRight = (AbsoluteValue(ptOffset.y) * cxScreen) <=
      (AbsoluteValue(ptOffset.x) * cyScreen);

   // If (it should be left/right) 
   if (fIsLeftOrRight) 
	  {

	  rect.top = rcSav.top;
	  rect.bottom = rcSav.bottom;
	  int width = rect.Width();
	  if (0 <= ptOffset.x)
	  {
		  int width = rect.Width();
		  rect.right = rcSav.right;
		  rect.left  = rect.right - width;
	  }
	  else
	  {
		  rect.left = rcSav.left;
		  rect.right = rect.left + width;
	  }
   } 
   else if( !fIsLeftOrRight ){
	  rect.left = rcSav.left;
	  rect.right = rcSav.right;
	  int height = rect.Height();
	  if (0 <= ptOffset.y)
	  {
		  rect.bottom = rcSav.bottom;
		  rect.top =  rect.bottom - height;
	  }
	  else
	  {
		  rect.top = rcSav.top;
		  rect.bottom = rect.top + height;
	  }
   }
   

}

static void AdjustRectangle(CRect& rect, CPoint pt)
{
	int nXOffset = (pt.x < rect.left) ? (pt.x - rect.left) :
					(pt.x > rect.right) ? (pt.x - rect.right) : 0;
	int nYOffset = (pt.y < rect.top) ? (pt.y - rect.top) :
					(pt.y > rect.bottom) ? (pt.y - rect.bottom) : 0;
	rect.OffsetRect(nXOffset, nYOffset);
}

CMyDockContext::CMyDockContext(CControlBar* pBar) : CDockContext(pBar)
{
}

void CMyDockContext::StartDrag(CPoint pt)
{
	ASSERT_VALID(m_pBar);
	m_bDragging = TRUE;

	InitLoop();

	if (m_pBar->m_dwStyle & CBRS_SIZE_DYNAMIC)
	{
		// get true bar size (including borders)
		CRect rect;
		m_pBar->GetWindowRect(rect);
		m_ptLast = pt;
		CSize sizeHorz = m_pBar->CalcDynamicLayout(0, LM_HORZ | LM_HORZDOCK);
		CSize sizeVert = m_pBar->CalcDynamicLayout(0, LM_VERTDOCK);
		CSize sizeFloat = m_pBar->CalcDynamicLayout(0, LM_HORZ | LM_MRUWIDTH);

		m_rectDragHorz = CRect(rect.TopLeft(), sizeHorz);
		m_rectDragVert = CRect(rect.TopLeft(), sizeVert);

		// calculate frame dragging rectangle
		m_rectFrameDragHorz = CRect(rect.TopLeft(), sizeFloat);
		m_rectFrameDragVert = CRect(rect.TopLeft(), sizeFloat);

#ifdef _MAC
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragHorz,
			WS_THICKFRAME | WS_CAPTION, WS_EX_FORCESIZEBOX);
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragVert,
			WS_THICKFRAME | WS_CAPTION, WS_EX_FORCESIZEBOX);
#else
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragHorz);
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragVert);
#endif
		m_rectFrameDragHorz.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
		m_rectFrameDragVert.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
	}
	else if (m_pBar->m_dwStyle & CBRS_SIZE_FIXED)
	{
		// get true bar size (including borders)
		CRect rect;
		m_pBar->GetWindowRect(rect);
		m_ptLast = pt;
		CSize sizeHorz = m_pBar->CalcDynamicLayout(-1, LM_HORZ | LM_HORZDOCK);
		CSize sizeVert = m_pBar->CalcDynamicLayout(-1, LM_VERTDOCK);

		// calculate frame dragging rectangle
		m_rectFrameDragHorz = m_rectDragHorz = CRect(rect.TopLeft(), sizeHorz);
		m_rectFrameDragVert = m_rectDragVert = CRect(rect.TopLeft(), sizeVert);

		CMiniFrameWnd::CalcBorders(&m_rectFrameDragHorz);
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragVert);
		m_rectFrameDragHorz.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
		m_rectFrameDragVert.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
	}
	else
	{
		// get true bar size (including borders)
		CRect rect;
		m_pBar->GetWindowRect(rect);
		m_ptLast = pt;
		BOOL bHorz = HORZF(m_dwStyle);
		DWORD dwMode = !bHorz ? (LM_HORZ | LM_HORZDOCK) : LM_VERTDOCK;
		CSize size = m_pBar->CalcDynamicLayout(-1, dwMode);

		// calculate inverted dragging rect
		if (bHorz)
		{
			m_rectDragHorz = rect;
			m_rectDragVert = CRect(CPoint(pt.x - rect.Height()/2, rect.top), size);
		}
		else // vertical orientation
		{
			m_rectDragVert = rect;
			m_rectDragHorz = CRect(CPoint(rect.left, pt.y - rect.Width()/2), size);
		}

		// calculate frame dragging rectangle
		//m_rectFrameDragHorz = m_rectDragHorz;
		//m_rectFrameDragVert = m_rectDragVert;
		m_rectFrameDragHorz = CRect(m_rectDragHorz.TopLeft(), ((CDialogBar*)m_pBar)->m_sizeDefault);
		m_rectFrameDragVert = CRect(m_rectDragVert.TopLeft(), ((CDialogBar*)m_pBar)->m_sizeDefault);

		CMiniFrameWnd::CalcBorders(&m_rectFrameDragHorz);
		CMiniFrameWnd::CalcBorders(&m_rectFrameDragVert);
		m_rectFrameDragHorz.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
		m_rectFrameDragVert.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);
	}

	// adjust rectangles so that point is inside
	AdjustRectangle(m_rectDragHorz, pt);
	AdjustRectangle(m_rectDragVert, pt);
	AdjustRectangle(m_rectFrameDragHorz, pt);
	AdjustRectangle(m_rectFrameDragVert, pt);

	// initialize tracking state and enter tracking loop
	m_dwOverDockStyle = CanDock();
	Move(pt);   // call it here to handle special keys
	Track();
}

void CMyDockContext::EndDrag()
{
	CancelLoop();

	if (m_dwOverDockStyle != 0)
	{
		CDockBar* pDockBar = GetDockBar(m_dwOverDockStyle);
		ASSERT(pDockBar != NULL);

		CRect rect = (m_dwOverDockStyle & CBRS_ORIENT_VERT) ?
			m_rectDragVert : m_rectDragHorz;

		UINT uID = _AfxGetDlgCtrlID(pDockBar->m_hWnd);
		if (uID >= AFX_IDW_DOCKBAR_TOP &&
			uID <= AFX_IDW_DOCKBAR_BOTTOM)
		{
			m_uMRUDockID = uID;
			m_rectMRUDockPos = rect;
			pDockBar->ScreenToClient(&m_rectMRUDockPos);
		}

		// dock it at the specified position, RecalcLayout will snap

		// TYPE CAST pointer to derived class
		((CMainFrame*)m_pDockSite)->DockControlBar(m_pBar, pDockBar, &rect);
		((CMainFrame*)m_pDockSite)->RecalcLayout();
	}
	else if ((m_dwStyle & CBRS_SIZE_DYNAMIC) || (HORZF(m_dwStyle) && !m_bFlip) ||
			(VERTF(m_dwStyle) && m_bFlip))
	{
		m_dwMRUFloatStyle = CBRS_ALIGN_TOP | (m_dwDockStyle & CBRS_FLOAT_MULTI);
		m_ptMRUFloatPos = m_rectFrameDragHorz.TopLeft();
		// TYPE CAST pointer to derived class
		((CMainFrame*)m_pDockSite)->FloatControlBar(m_pBar, m_ptMRUFloatPos, m_dwMRUFloatStyle);
	}
	else // vertical float
	{
		m_dwMRUFloatStyle = CBRS_ALIGN_LEFT | (m_dwDockStyle & CBRS_FLOAT_MULTI);
		m_ptMRUFloatPos = m_rectFrameDragVert.TopLeft();
		// TYPE CAST pointer to derived class
		((CMainFrame*)m_pDockSite)->FloatControlBar(m_pBar, m_ptMRUFloatPos, m_dwMRUFloatStyle);
	}
}


BOOL CMyDockContext::Track()
{
	// don't handle if capture already set
	if (::GetCapture() != NULL)
		return FALSE;

	// set capture to the window which received this message
	m_pBar->SetCapture();
	ASSERT(m_pBar == CWnd::GetCapture());

#ifndef _MAC
	// get messages until capture lost or cancelled/accepted
	while (CWnd::GetCapture() == m_pBar)
	{
		MSG msg;
		if (!::GetMessage(&msg, NULL, 0, 0))
		{
			AfxPostQuitMessage(msg.wParam);
			break;
		}

		switch (msg.message)
		{
		case WM_LBUTTONUP:
			if (m_bDragging)
				EndDrag();
			else
				EndResize();
			return TRUE;
		case WM_MOUSEMOVE:
			if (m_bDragging)
				Move(msg.pt);
			else
				Stretch(msg.pt);
			break;
		case WM_KEYUP:
			if (m_bDragging)
				OnKey((int)msg.wParam, FALSE);
			break;
		case WM_KEYDOWN:
			if (m_bDragging)
				OnKey((int)msg.wParam, TRUE);
			if (msg.wParam == VK_ESCAPE)
			{
				CancelLoop();
				return FALSE;
			}
			break;
		case WM_RBUTTONDOWN:
			CancelLoop();
			return FALSE;

		// just dispatch rest of the messages
		default:
			DispatchMessage(&msg);
			break;
		}
	}
#else
	Point   ptCur = {0};

	// get messages until capture lost or cancelled/accepted
	while (CWnd::GetCapture() == m_pBar)
	{
		EventRecord     er;

		if (OSEventAvail(everyEvent, &er))
		{
			GetNextEvent(everyEvent, &er);
			switch (er.what)
			{
			case mouseUp:
				if (m_bDragging)
					EndDrag();
				else
					EndResize();
				return TRUE;

			case keyDown:
			case keyUp:
			case autoKey:
			case app2Evt:
			{
				MSG     msg;

				if (WrapEvent(&er, &msg, PM_REMOVE))
				{
					if (m_bDragging)
						OnKey((int)msg.wParam, msg.message == WM_KEYDOWN);
					if (msg.message == WM_KEYUP && msg.wParam == VK_ESCAPE)
					{
						CancelLoop();
						return FALSE;
					}
				}
				break;
			}

			default:
				break;
			}
		}
		else
		{
			if (!EqualPt(er.where, ptCur))
			{
				POINT pt = {er.where.h, er.where.v};
				if (m_bDragging)
					Move(pt);
				else
					Stretch(pt);
			}
		}
	}
#endif
	CancelLoop();

	return FALSE;
}

void CMyDockContext::StartResize(int nHitTest, CPoint pt)
{
	ASSERT_VALID(m_pBar);
	ASSERT(m_pBar->m_dwStyle & CBRS_SIZE_DYNAMIC);
	m_bDragging = FALSE;

	InitLoop();

	// get true bar size (including borders)
	CRect rect;
	m_pBar->GetWindowRect(rect);
	m_ptLast = pt;
	m_nHitTest = nHitTest;

	CSize size = m_pBar->CalcDynamicLayout(0, LM_HORZ | LM_MRUWIDTH);
	m_rectRequestedSize = CRect(rect.TopLeft(), size);
	m_rectActualSize = CRect(rect.TopLeft(), size);
	m_rectActualFrameSize = CRect(rect.TopLeft(), size);

	// calculate frame rectangle
#ifdef _MAC
	CMiniFrameWnd::CalcBorders(&m_rectActualFrameSize,
		WS_THICKFRAME | WS_CAPTION, WS_EX_FORCESIZEBOX);
#else
	CMiniFrameWnd::CalcBorders(&m_rectActualFrameSize);
#endif
	m_rectActualFrameSize.InflateRect(-afxData.cxBorder2, -afxData.cyBorder2);

	m_rectFrameBorders = CRect(CPoint(0,0),
		m_rectActualFrameSize.Size() - m_rectActualSize.Size());

	// initialize tracking state and enter tracking loop
	m_dwOverDockStyle = 0;
	Stretch(pt);   // call it here to handle special keys
	Track();
}

void CMyDockContext::EndResize()
{
	CancelLoop();

	m_pBar->CalcDynamicLayout(m_rectActualSize.Width(), LM_HORZ | LM_COMMIT);

	// TYPE CAST pointer to derived class
	((CMainFrame*)m_pDockSite)->FloatControlBar(m_pBar, m_rectActualFrameSize.TopLeft(),
		CBRS_ALIGN_TOP | (m_dwDockStyle & CBRS_FLOAT_MULTI) | CBRS_SIZE_DYNAMIC);
}

void CMyDockContext::Move(CPoint pt)
{
	CPoint ptOffset = pt - m_ptLast;

#ifdef _MAC
	// prevent dragging the floating window completely under the menu bar
	GDHandle hgd = _AfxFindDevice(pt.x, pt.y);
	if (hgd == NULL || hgd == GetMainDevice() ||
			TestDeviceAttribute(hgd, hasAuxMenuBar))
	{
		CRect rect;
		if ((HORZF(m_dwStyle) && !m_bFlip) || (VERTF(m_dwStyle) && m_bFlip))
			rect = m_rectFrameDragHorz;
		else
			rect = m_rectFrameDragVert;

		// determine our new position
		rect.OffsetRect(ptOffset);

		// keep us on the screen if we were getting too close to the menu bar
		int yMBarBottom = (*hgd)->gdRect.top + GetMBarHeight() + 4;
		if (rect.bottom < yMBarBottom)
		{
			pt.y += yMBarBottom - rect.bottom;
			ptOffset.y += yMBarBottom - rect.bottom;
		}
	}
#endif

	// offset all drag rects to new position
	m_rectDragHorz.OffsetRect(ptOffset);
	m_rectFrameDragHorz.OffsetRect(ptOffset);
	m_rectDragVert.OffsetRect(ptOffset);
	m_rectFrameDragVert.OffsetRect(ptOffset);
	m_ptLast = pt;

	// save the drag rectangle size
	CRect rectDragHorzSav = m_rectDragHorz;
	CRect rectDragVertSav = m_rectDragVert;
	CRect rectFrameDragHorzSav = m_rectFrameDragHorz;
	CRect rectFrameDragVertSav = m_rectFrameDragVert;

	// if control key is down don't dock
	m_dwOverDockStyle = m_bForceFrame ? 0 : CanDock();


	// if not in a docking position on the frame and the drag rect is over 
	// the edges of the system shell - change the drag rect size
	if (m_dwOverDockStyle == 0)
	{
		GetDimsFromPoint(m_rectDragHorz, pt);
		GetDimsFromPoint(m_rectFrameDragHorz, pt);
		GetDimsFromPoint(m_rectDragVert, pt);
		GetDimsFromPoint(m_rectFrameDragVert, pt);
	}

	// update feedback
	DrawFocusRect();

	// restore saved drag rectangle sizes
	m_rectDragHorz = rectDragHorzSav;
	m_rectDragVert = rectDragVertSav;
	m_rectFrameDragHorz = rectFrameDragHorzSav;
	m_rectFrameDragVert = rectFrameDragVertSav;

}

void CMyDockContext::ToggleDocking()
{
	if (m_pBar->IsFloating())
	{
		// Dock it only if is allowed to be docked
		if (m_pBar->m_dwDockStyle & CBRS_ALIGN_ANY)
		{
			ASSERT((m_uMRUDockID >= AFX_IDW_DOCKBAR_TOP &&
				m_uMRUDockID <= AFX_IDW_DOCKBAR_BOTTOM) ||
				m_uMRUDockID == 0);

			CRect rect = m_rectMRUDockPos;
			CDockBar* pDockBar = NULL;
			if (m_uMRUDockID != 0)
			{
				pDockBar = (CDockBar*)m_pDockSite->GetControlBar(m_uMRUDockID);
				pDockBar->ClientToScreen(&rect);
			}

			// dock it at the specified position, RecalcLayout will snap
			((CMainFrame*)m_pDockSite)->ReDockControlBar(m_pBar, pDockBar, &rect);
			((CMainFrame*)m_pDockSite)->RecalcLayout();
		}
	}
	else
	{
		CPoint ptFloat = m_ptMRUFloatPos;
		if (ptFloat.x < 0 || ptFloat.y < 0)
		{
			ptFloat = m_rectMRUDockPos.TopLeft();
			m_pBar->GetParent()->ClientToScreen(&ptFloat);
		}
		((CMainFrame*)m_pDockSite)->FloatControlBar(m_pBar, ptFloat, m_dwMRUFloatStyle);
	}
}
