/*
	Source code is copyright 1997 by Viperware(tm)
	Permission to re-use code is granted
	
	Note: this code is not intended to compile- there are too many interdependancies 
		  to make this feasible.  However, this code is being used in real products
		  being sold by Viperware, and it should furthur illustrate the concepts
		  introduced in the "Tagged Data Storage Architecture" article.
 */

#ifndef __LB_CHUNKDATA__
#include "LB_ChunkData.h"
#endif
#ifndef __LB_DATACHUNK__
#include "LB_DataChunk.h"
#endif

LB_ChunkData::LB_ChunkData()
{
	UseChunk(nil);
	UseData(nil);
}

LB_ChunkData::LB_ChunkData(Ptr pData)
{
	UseData(pData);
}

LB_ChunkData::~LB_ChunkData()
{
	if (HasChunk())
		// Variable pData belongs to data chunk, so we don't have to release it from memory.
		// However, we must adjust the reference count on the data chunk.
		GetChunk()->ReleaseData(GetData());
}

void LB_ChunkData::UseData(LB_DataReference pData)
{
	// Since we have new data, the chunk is invalid.
	if (HasChunk())
		GetChunk()->ReleaseData(GetData());
		
	this->lbc_pData = pData;
}

LB_DataSize LB_ChunkData::GetDataSize()
{
	LB_DataSize			result = 0;
	
	if (HasChunk())
		// Only the chunk can determine the size of the data.
		result = GetChunk()->GetDataSize();
		
	return result;
}
