

/*
  Support for RTKernel 

  This module implements Windows 95/NT (Win32)
  critical section facilities.

  Copyright 1996 Algorithms Corporation
*/

#include "dynrtk.h"



void	InitializeCriticalSection(CRITICAL_SECTION *cs)
{
	cs->s1 = RTKCreateSemaphore(Resource, 1, "NoName");
	cs->s2 = RTKCreateSemaphore(Resource, 1, "NoName");
	cs->t = (TaskHandle) 0;
	cs->n = 0;
}

void	DeleteCriticalSection(CRITICAL_SECTION *cs)
{
	RTKDeleteSemaphore(&cs->s1);
	RTKDeleteSemaphore(&cs->s2);
}

void	EnterCriticalSection(CRITICAL_SECTION *cs)
{
	RTKWait(cs->s1);
	if (cs->t == RTKCurrentTaskHandle())
		cs->n++;
	else {
		RTKSignal(cs->s1);
		RTKWait(cs->s2);
		RTKWait(cs->s1);
		cs->n = 1;
		cs->t = RTKCurrentTaskHandle();
	}
	RTKSignal(cs->s1);
}

void	LeaveCriticalSection(CRITICAL_SECTION *cs)
{
	RTKWait(cs->s1);
	if (cs->n  &&  cs->t == RTKCurrentTaskHandle())
		if (!--cs->n) {
			cs->t = (TaskHandle) 0;
			RTKSignal(cs->s1);
			RTKSignal(cs->s2);
			return;
		}
	RTKSignal(cs->s1);
}
