
/*
 *
 *	Copyright (c) 1994-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


#include "dpp.h"


defclass  Token : Link  {
	iToken;			/*  String rep of token		*/
	long	iLine;		/*  source line found on or 0	*/
	int	iSpace;		/*  1=following char is space   */
};


cmeth	gNew()
{
	return gShouldNotImplement(self, "gNew");
}

cmeth	gNewToken(char *tkn, long ln, int sp)
{
	object	obj;
	ivType	*iv;

	obj = gNew(super);
	iv = ivPtr(obj);
	iToken = gNewWithStr(String, tkn);
	iLine  = ln;
	iSpace = sp;
	return obj;
}

imeth	object	gDispose, gDeepDispose ()
{
	gDispose(iToken);
	return gDispose(super);
}

imeth	char	*gStringValue()
{
	return gStringValue(iToken);
}

imeth	gToken()
{
	return iToken;
}

imeth	gChangeToken(char *str)
{
	gChangeStrValue(iToken, str);
	return self;
}

imeth	long	gLineNumber()
{
	return iLine;
}

imeth	int	gSpace()
{
	return iSpace;
}

imeth	gCopy, gDeepCopy ()
{
	object	obj = gCopy(super);
	ivType	*niv = ivPtr(obj);
	niv->iToken = gCopy(iToken);
	return obj;
}

imeth	gStringRepValue()
{
	return gStringRepValue(iToken);
}

imeth	gStringRep()
{
	object	a, b, s;

	a = gStringRepValue(super);
	b = gStringRepValue(iToken);
	s = vBuild(String, gName(ClassOf(self)), " (", a, ", ", b, ")\n", NULL);
	DISPOSE(a);
	DISPOSE(b);
	return s;
}


/*
 *
 *	Copyright (c) 1994-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

