


/*                                      
 *
 *      Copyright (c) 1994-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


#include "dpp.h"

defclass  ArgumentList : LinkObject;

static	void	process_file(object, char *);

cmeth	gNew()
{
	return gShouldNotImplement(self, "gNew");
}

cmeth	gNewArglist(int argc, char **argv)
{
	int	i;
	object	obj = gNew(super);
	for (i=0 ; i < argc ; i++)
		if (argv[i][0] == '@')
			process_file(obj, 1+argv[i]);
		else
			gAddLast(obj, gNewWithStr(String, argv[i]));
	return obj;
}

static	void	process_word(char *word, object list, int noexpand)
{
	int	wild=0;
	char	*w;

	if (!noexpand)
		for (w=word ; *w ; w++)
			if (*w == '*'  ||  *w == '?')  {
				wild = 1;
				break;
			}
	if (!wild)  {
		gAddLast(list, gNewWithStr(String, word));
		return;
	}
	
	/*  process wild some day...   */

	gAddLast(list, gNewWithStr(String, word));
}


#define space(x) 	((x) <= ' ')

static	char	*process_token(char *p, object list)
{
	char	word[128], *w;
	int	inquote, noexpand;

	while (*p  &&  space(*p))
		p++;
	if (noexpand = inquote = *p == '"')
		p++;
	for (w=word ; *p  &&  (!space(*p) || inquote) ; p++)
		if (inquote  &&  *p == '"')
			inquote = 0;
		else
			*w++ = *p;
	*w = '\0';
	if (*word == '@')
		process_file(list, word+1);
	else if (*word)
		process_word(word, list, noexpand);
	return p;
}

static	void	process_file(object list, char *file)
{
	char	buf[256], *p;
	object	fobj;

	fobj = gOpenFile(File, file, "r");
	if (!fobj)  {
		vPrintf(stdoutStream, "Can't open %s\n", file);
		exit(1);
	}
	while (gGets(fobj, buf, sizeof buf))
		for (p=buf ; *(p=process_token(p, list)) ; );
	gDispose(fobj);
}





/*                                      
 *
 *      Copyright (c) 1994-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */



