


/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */



#include "array1.h"


defclass  UnsignedShortArray : NumberArray  {
	init:	init_class;
};


#define TYPE	unsigned short


static	gIndex_t	_index;


cvmeth	vNew(unsigned rank, ...)
{
	static	gNewArray_t	cnew = NULL;
	MAKE_REST(rank);

	if (!cnew)
		cnew = cmcPointer(Array, gNewArray);
	return cnew(self, AT_USHT, rank, _rest_);
}

ivmeth	char	vCharValue(...)
{
	MAKE_REST(self);
	return (char) *((TYPE *) _index(self, _rest_));
}

ivmeth	short	vShortValue(...)
{
	MAKE_REST(self);
	return (short) *((TYPE *) _index(self, _rest_));
}

ivmeth	unsigned short	vUnsignedShortValue(...)
{
	MAKE_REST(self);
	return (unsigned short) *((TYPE *) _index(self, _rest_));
}

ivmeth	long	vLongValue(...)
{
	MAKE_REST(self);
	return (long) *((TYPE *) _index(self, _rest_));
}

ivmeth	double	vDoubleValue(...)
{
	MAKE_REST(self);
	return (double) *((TYPE *) _index(self, _rest_));
}

ivmeth	vChangeValue(val, ...)
{
	MAKE_REST(val);
	ChkArg(val, 2);
	*((TYPE *) _index(self, _rest_)) = gUnsignedShortValue(val);
	return self;
}

ivmeth	vChangeCharValue(int val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = (TYPE) val;
	return self;
}

ivmeth	vChangeShortValue(int val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = (TYPE) val;
	return self;
}

ivmeth	vChangeUShortValue(unsigned val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = (TYPE) val;
	return self;
}

ivmeth	vChangeLongValue(long val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = (TYPE) val;
	return self;
}

ivmeth	vChangeDoubleValue(double val, ...)
{
	MAKE_REST(val);
	*((TYPE *) _index(self, _rest_)) = (TYPE) val;
	return self;
}

static	void	init_class(void)
{
	_index = imcPointer(Array, gIndex);
}




/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */



