

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 23 "memalloc.d"
#include "dynl.h" 
#include <string.h> 
#include "memalloc.h" 


typedef struct _header { 
	char status; 
	struct _header *next; 

	unsigned rsize; 
	unsigned size; 

} Header; 

typedef struct _memBlk { 
	struct _memBlk *next; 
	unsigned size; 

} MemBlk; 


typedef struct { 
	unsigned userBytes; 
	Header *h; 
} MAP; 

#define SZ(x) (sizeof(Header)*x) 

#define RND(n) (((n-1) / sizeof(Header)) + 1) * sizeof(Header); 

static MAP Map[] = { 
	{SZ(1)}, 
	{SZ(2)}, 
	{SZ(4)}, 
	{SZ(8)}, 
	{SZ(16)}, 
	{SZ(32)}, 
	{SZ(64)}, 
	{SZ(128)}, 
	{SZ(256)}, 
	{SZ(512)}, 
	{SZ(1024)}, 
	{SZ(2048)}, 
	{0} 
}; 



static MemBlk *MMBP = NULL; 

static unsigned DBS = 1024; 

static void more_core(unsigned); 
static Header *compact(MemBlk *); 

static CRITICALSECTION CS; 
static int CS_init = 0; 

void *MA_malloc(unsigned n, void *p) 


{ 
	unsigned sz; 
	int i; 
	Header *h; 
	Header *ph; 
	Header *bh; 
	Header *pbh; 
	unsigned tnb; 
	unsigned nbn; 
	unsigned nbl; 

	if (!CS_init) { 
		INITIALIZECRITICALSECTION(CS); 
		CS_init = 1; 
	} 
	ENTERCRITICALSECTION(CS); 
	if (!n) 
		++n; 
	sz = RND(n); 


	for (i=1 ; Map[i].userBytes && Map[i].userBytes <= sz ; ++i); 
	i--; 



	for (bh=pbh=ph=NULL, h=Map[i].h ; h ; ph=h, h=h->next) 
		if (h->size == sz) { 
		if (ph) 
			ph->next = h->next; 
		else 
			Map[i].h = h->next; 
		h->status = 'U'; 
		h->next = (Header *) p; 
		h->rsize = n; 
		LEAVECRITICALSECTION(CS); 
		return h+1; 
	} else if (h->size > sz && (!bh || bh->size > h->size)) { 
		pbh = ph; 
		bh = h; 
	} 

	if (bh) { 
		if (pbh) 
			pbh->next = bh->next; 
		else 
			Map[i].h = bh->next; 
		bh->status = 'U'; 
		bh->next = (Header *) p; 
		bh->rsize = n; 
		LEAVECRITICALSECTION(CS); 
		return bh+1; 
	} 



	for (i++ ; Map[i].userBytes && !Map[i].h ; ++i); 

	if (!Map[i].userBytes) { 
		more_core(n); 
		LEAVECRITICALSECTION(CS); 
		return MA_malloc(n, p); 
	} 

#line 152 "memalloc.d"
	h = Map[i].h; 
	Map[i].h = h->next; 

	tnb = h->size / sizeof(Header); 
	nbn = sz / sizeof(Header); 
	nbl = tnb - nbn; 
	if (nbl > 5) { 
		bh = h + (nbn + 1); 
		bh->status = 'U'; 
		bh->next = NULL; 
		bh->rsize = bh->size = (nbl - 1) * sizeof(Header); 
		h->size -= nbl * sizeof(Header); 
		MA_free(bh+1); 
	} 
	h->status = 'U'; 
	h->next = (Header *) p; 
	h->rsize = n; 
	LEAVECRITICALSECTION(CS); 
	return h+1; 
} 

void *MA_calloc(unsigned n, void *p) 
{ 
	p = MA_malloc(n, p); 
	memset(p, 0, n); 
	return p; 
} 

void MA_free(void *arg) 
{ 
	int i; 
	Header *h = (Header *) arg; 

	ENTERCRITICALSECTION(CS); 
	if (!h || (--h)->status != 'U') { 
		LEAVECRITICALSECTION(CS); 
		return; 
	} 


	for (i=1 ; Map[i].userBytes && Map[i].userBytes <= h->size ; ++i); 
	i--; 

	h->status = 'F'; 
	if (h->next) 
		*((char **) h->next) = NULL; 
	h->next = Map[i].h; 
	Map[i].h = h; 
	LEAVECRITICALSECTION(CS); 
} 

static void more_core(unsigned n) 
{ 
	unsigned sz; 
	unsigned as; 
	MemBlk *mb; 
	Header *h; 

	sz = n > DBS ? n : DBS; 
	sz = RND(sz); 
	as = sizeof(MemBlk) + sizeof(Header) + sz; 
	mb = (MemBlk *) malloc(as); 
	if (!mb) { 
		fprintf(stderr, "\nOut of memory.\n"); 
		exit(1); 
	} 
	mb->next = MMBP; 
	MMBP = mb; 
	mb->size = sz + sizeof(Header); 

	h = (Header *) (mb+1); 
	h->status = 'U'; 
	h->next = NULL; 
	h->size = sz; 
	MA_free(h+1); 
} 

void *MA_realloc(void *arg, unsigned n) 
{ 
	char *m; 
	Header *h = (Header *) arg; 

	ENTERCRITICALSECTION(CS); 
	if (!h || (--h)->status != 'U') { 
		LEAVECRITICALSECTION(CS); 
		return NULL; 
	} 
	if (h->size >= n) { 
		h->rsize = n; 
		LEAVECRITICALSECTION(CS); 
		return h+1; 
	} 
	m = (char *) MA_malloc(n, h->next); 
	memcpy(m, h+1, h->rsize); 
	h->next = NULL; 
	MA_free(h+1); 
	LEAVECRITICALSECTION(CS); 
	return m; 
} 


void MA_compact(void) 
{ 
	MemBlk *mb; 
	Header *fh, *mfh = NULL; 
	int i; 

	ENTERCRITICALSECTION(CS); 

	for (mb=MMBP ; mb ; mb = mb->next) { 
		fh = compact(mb); 
		if (fh) { 
			fh->next = mfh; 
			mfh = fh; 
		} 
	} 


	for (i=0 ; Map[i].userBytes ; ++i) 
		Map[i].h = NULL; 


	while (fh = mfh) { 
		mfh = fh->next; 
		fh->status = 'U'; 
		fh->next = NULL; 
		MA_free(fh+1); 
	} 
	LEAVECRITICALSECTION(CS); 
} 

#define NEXTH(h) (Header *) ((char *) h + (sizeof(Header)+h->size)) 

static Header *compact(MemBlk *mb) 
{ 
	char *end = (char *) (mb+1) + mb->size; 
	Header *h = (Header *) (mb+1); 
	Header *to, *pto=NULL; 

	for (to=h ; (char *) h < end ; h = NEXTH(h)) { 
		if (h->status == 'F') 
			continue; 
		if (to != h) { 
			memcpy(to, h, h->rsize+sizeof(Header)); 
			if (h->next) 
				*((Header **) to->next) = to + 1; 
		} 
		to->size = RND(to->rsize); 
		pto = to; 
		to = NEXTH(to); 
	} 
	if ((char *) to >= end) 
		return NULL; 
	to->status = 'F'; 
	to->size = (end - (char *) to) - sizeof(Header); 
	if (!to->size) { 
		if (pto) 
			pto->size += to->size + sizeof(Header); 
		return NULL; 
	} 
	return to; 
} 
