

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 15 "findfile.d"
#if defined(_WIN32) || defined(WIN32) 
#include <io.h> 
#define FINDSTRUCT _finddata_t 
#ifndef _WIN32 
#define _WIN32 
#endif 
#else 
#include <dos.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#define FINDSTRUCT find_t 
#endif 


#include "findfile.h" 

#define	CLASS	FindFile_c
#define	ivType	FindFile_iv_t

#include "generics.h"

object	FindFile_c;


#line 42 "findfile.c"
typedef struct  _FindFile_iv_t  {
	object iFileName;
	unsigned iAttributes;
	struct FINDSTRUCT iData;
	long iHandle;
	int iFirst;
	int iEnd;
}	FindFile_iv_t;



#line 42 "findfile.d"
cmeth objrtn FindFile_cm_gNewFindFile(object self, char *name, int attr)
{ 
	object obj = oSuper(FindFile_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 
	iv->iFileName = gNewWithStr(String, name); 
	iv->iAttributes = attr; 
	iv->iHandle = -1L; 
	return obj; 
} 

imeth objrtn FindFile_im_gDispose(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
#ifdef _WIN32 
		if (iv->iHandle != -1L) 
		_findclose(iv->iHandle); 
#endif 
		gDispose(iv->iFileName); 
	return oSuper(FindFile_c, gDispose, self)(self); 
} 

imeth objrtn FindFile_im_gGCDispose(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
#ifdef _WIN32 
		if (iv->iHandle != -1L) 
		_findclose(iv->iHandle); 
#else 
		USE(iv->iHandle); 
#endif 
		return oSuper(FindFile_c, gDispose, self)(self); 
} 

#define SET(a, b) ((a) & (b)) 

static int valid(ivType *iv) 
{ 
	if (SET(iv->iData.attrib, _A_SUBDIR)) { 
		if (!SET(iv->iAttributes, FF_DIRECTORY)) 
			return 0; 
	} else 
		if (!SET(iv->iAttributes, FF_FILE)) 
		return 0; 
	if (SET(iv->iData.attrib, _A_RDONLY)) { 
		if (!SET(iv->iAttributes, FF_READONLY)) 
			return 0; 
	} else 
		if (!SET(iv->iAttributes, FF_READWRITE)) 
		return 0; 
	if (SET(iv->iData.attrib, _A_HIDDEN) && !SET(iv->iAttributes, FF_HIDDEN)) 
		return 0; 
	if (SET(iv->iData.attrib, _A_SYSTEM) && !SET(iv->iAttributes, FF_SYSTEM)) 
		return 0; 
	if (SET(iv->iAttributes, FF_ARCHIVE_ONLY) && !SET(iv->iData.attrib, _A_ARCH)) 
		return 0; 
	return 1; 
} 

imeth char * FindFile_im_gNextFile(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
#ifdef _WIN32 
		int r; 

	if (iv->iEnd) 
		return NULL; 
	if (!iv->iFirst) { 
		iv->iHandle = _findfirst(gStringValue(iv->iFileName), &iv->iData); 
		iv->iFirst = 1; 
		r = iv->iHandle < 0L ? 1 : 0; 
	} else 
		r = _findnext(iv->iHandle, &iv->iData); 
	while (!r && !valid(iv)) 
		r = _findnext(iv->iHandle, &iv->iData); 
	if (r) { 
		iv->iEnd = 1; 
		if (iv->iHandle != -1L) { 
			_findclose(iv->iHandle); 
			iv->iHandle = -1; 
		} 
		return NULL; 
	} else 
		return iv->iData.name; 
#else 
		unsigned r; 

	if (iv->iEnd) 
		return NULL; 
	if (!iv->iFirst) { 
		r = _dos_findfirst(gStringValue(iv->iFileName), 
			_A_ARCH | _A_HIDDEN | _A_NORMAL | _A_RDONLY | _A_SUBDIR | _A_SYSTEM, 
			&iv->iData); 
		iv->iFirst = 1; 
	} else 
		r = _dos_findnext(&iv->iData); 
	while (!r && !valid(iv)) 
		r = _dos_findnext(&iv->iData); 
	if (r) { 
		iv->iEnd = 1; 
		return NULL; 
	} else 
		return iv->iData.name; 
#endif 
	} 

imeth long FindFile_im_gLength(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
	return iv->iFirst && !iv->iEnd ? iv->iData.size : -1L; 
} 

imeth char * FindFile_im_gName(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
	return iv->iFirst && !iv->iEnd ? iv->iData.name : NULL; 
} 

#ifndef _WIN32 
static void getpath(char *path, char *search, char *name) 
{ 
	char *p, *last; 

	strcpy(path, search); 
	for (last=path-1, p=path ; *p ; ++p) 
		if (*p == ':' || *p == '/' || *p == '\\') 
		last = p; 
	strcpy(last+1, name); 
} 
#endif 

imeth long FindFile_im_gWriteTime(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
#ifdef _WIN32 
		if (!iv->iFirst || iv->iEnd) 
		return -1L; 
	return iv->iData.time_write; 
#else 
		char path[256]; 
#ifdef MSC16 
		struct _stat sb; 
#else 
		struct stat sb; 
#endif 

		if (!iv->iFirst || iv->iEnd) 
		return -1L; 
	getpath(path, gStringValue(iv->iFileName), iv->iData.name); 
	return _stat(path, &sb) ? -1L : sb.st_mtime; 
#endif 
	} 

imeth unsigned FindFile_im_gAttributes(object self)
{ FindFile_iv_t *iv = GetIVs(FindFile, self);
	unsigned at = 0; 

	if (!iv->iFirst || iv->iEnd) 
		return at; 
	if (SET(iv->iData.attrib, _A_SUBDIR)) 
		at |= FF_DIRECTORY; 
	else 
		at |= FF_FILE; 
	if (SET(iv->iData.attrib, _A_RDONLY)) 
		at |= FF_READONLY; 
	else 
		at |= FF_READWRITE; 
	if (SET(iv->iData.attrib, _A_HIDDEN)) 
		at |= FF_HIDDEN; 
	if (SET(iv->iData.attrib, _A_SYSTEM)) 
		at |= FF_SYSTEM; 
	if (SET(iv->iData.attrib, _A_ARCH)) 
		at |= FF_ARCHIVE_ONLY; 
	return at; 
} 


#line 225 "findfile.c"

objrtn	FindFile_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (FindFile_c) {
		LEAVECRITICALSECTION(cs);
		return FindFile_c;
	}
	INHIBIT_THREADER;
	FindFile_c = gNewClass(Class, "FindFile", sizeof(FindFile_iv_t), 0, END);
	cMethodFor(FindFile, gNewFindFile, FindFile_cm_gNewFindFile);
	iMethodFor(FindFile, gNextFile, FindFile_im_gNextFile);
	iMethodFor(FindFile, gLength, FindFile_im_gLength);
	iMethodFor(FindFile, gAttributes, FindFile_im_gAttributes);
	iMethodFor(FindFile, gWriteTime, FindFile_im_gWriteTime);
	iMethodFor(FindFile, gDispose, FindFile_im_gDispose);
	iMethodFor(FindFile, gName, FindFile_im_gName);
	iMethodFor(FindFile, gGCDispose, FindFile_im_gGCDispose);
	iMethodFor(FindFile, gDeepDispose, FindFile_im_gDispose);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return FindFile_c;
}



