

/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



#include <stdio.h>
#include <dos.h>
#include <stdlib.h>

#pragma check_stack( off )
#pragma check_pointer( off )

#define TICKPERMIN  1092L
#define MINPERHOUR  60L

#define __interrupt _interrupt
#define __far _far

static	void (__interrupt __far *oldtimer)();
static	void __interrupt __far newtimer();


#ifdef	__cplusplus
extern "C"  {
#endif
#ifdef TEST
int	_tick_count=10000;
#else
extern	int	_tick_count;
#endif
#ifdef	__cplusplus
}
#endif

static	void	_end_timer(void)
{
	_dos_setvect( 0x1c, oldtimer );
}

void	_start_timer(void)
{
	oldtimer = _dos_getvect( (unsigned)0x1c );
	_dos_setvect( 0x1c, newtimer );
	atexit( _end_timer );
}

static	void __interrupt __far newtimer(void)
{
	if (_tick_count)
		_tick_count--;
        _chain_intr( oldtimer );
}


#ifdef TEST

main()
{
	int	n;
	long	i;

	_start_timer();

	for (n=0 ; n++ != 10 ; )  {
		fprintf(stderr, "Timer = %d\n", _tick_count);
		for (i=0L ; i++ != 1000000L ; );
	}
	return(0);
}

#endif



/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */


