/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

public	defclass Method  {
	char	*name;
	object	cls;
	object	generic;
	ofun	meth;
	ofun	fmeth;		/*  fixed arg version of overloaded methods  */
	int	trace;
	object	next;
};

imeth	char	*gName()
{
	return name;
}	

imeth	int	gTrace(int mode)
{
	int	pmode = trace;
	trace = mode;
	return pmode;
}

imeth	ofun	gFunction()
{
	return meth;
}	

imeth	ofun	gChangeFunction(ofun fun)
{
	ofun	org;

	org = meth;
	meth = fun;
	return org;
}	

imeth	gCopy()
{
	return gShouldNotImplement(self, "gCopy/gDeepCopy");
}

objrtn	Method_initialize(void)
{
	static	int	done = 0;

	/*  Class creation and some of the methods are initialized by
	    the kernel  */

	if (done)
		return Method_c;

	done = 1;

/*	Method_c = gNewClass(Class, "Method", sizeof(Method_iv_t), 0, END);	*/

	iMethodFor(Method, gName, Method_im_gName);
	iMethodFor(Method, gTrace, Method_im_gTrace);
	iMethodFor(Method, gFunction, Method_im_gFunction);
	iMethodFor(Method, gChangeFunction, Method_im_gChangeFunction);
	iMethodFor(Method, gCopy, Method_im_gCopy);
	iMethodFor(Method, gDeepCopy, Method_im_gCopy);
	return Method_c;
}

#if 0  /*  code for the benefit of dpp  */

cmeth gNewMethod(char *n, object c, object gen, ofun methf, ofun methf2){}

#endif


/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */
