

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 16 "string.d"
#include "memalloc.h" 
#include <ctype.h> 
#include <string.h> 
#include <math.h> 

#if 0 
#define ADJUST 
#endif 

#define	CLASS	String_c
#define	ivType	String_iv_t

#include "generics.h"

object	String_c;


#line 35 "string.c"
typedef struct  _String_iv_t  {
	char * iStr;
	int iSize;
	int iLen;
	int iBlksz;
	int iCalcLen;
	int iFum;
}	String_iv_t;


#line 41 "string.d"
#define SETSIZE(x) iv->iSize = ((x) ? (((x)-1)/iv->iBlksz + 1) * iv->iBlksz : 0) 

#define ABS 40 

#define UPDATE_LEN if (iv->iCalcLen) iv->iLen = strlen(iv->iStr) 


#ifndef max 
#define max(a,b) ((a) > (b) ? (a) : (b)) 
#endif 


#ifdef ADJUST 




#define FREE_UNUSED if (iv->iFum && iv->iLen+1 <= iv->iSize-iv->iBlksz) { SETSIZE(iv->iLen+1); iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); } 
#else 
#define FREE_UNUSED 
#endif 


static int get_string(object, char **, char *, int); 



cmeth objrtn New(object self, char *so)
{ 
	object obj = oSuper(String_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 
	char *str; 
	int len; 

	len = get_string((object) so, &str, "New", 2); 
	iv->iBlksz = 1; 
	SETSIZE(len + 1); 
	iv->iStr = (char *) MA_malloc(iv->iSize, &iv->iStr); 
	if (len) 
		memcpy(iv->iStr, str, len); 
	iv->iStr[len] = '\0'; 
	iv->iLen = len; 
	return(obj); 
} 

cmeth objrtn String_cm_gNewWithInt(object self, int len)
{ 
	object obj = oSuper(String_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 

	iv->iBlksz = 1; 
	SETSIZE(len + 1); 
	iv->iStr = (char *) MA_malloc(iv->iSize, &iv->iStr); 
	*iv->iStr = '\0'; 
	iv->iCalcLen = 1; 
	iv->iLen = 0; 
	return(obj); 
} 

cmeth objrtn String_cm_gNewWithObj(object self, object so)
{ 
	return New(self, (char *) so); 
} 

cmeth objrtn String_cm_gNew(object self)
{ 
	return New(self, ""); 
} 

imeth char * String_im_gStringValue(object self)
{ String_iv_t *iv = GetIVs(String, self);
	return iv->iStr; 
} 

imeth int String_im_gSize(object self)
{ String_iv_t *iv = GetIVs(String, self);
	UPDATE_LEN; 
	return iv->iLen; 
} 

imeth objrtn ChangeValue(object self, object obj)
{ String_iv_t *iv = GetIVs(String, self);
	char *str; 
	int len; 

	len = get_string(obj, &str, "ChangeValue", 2); 
	iv->iLen = len; 
	if (len >= iv->iSize) { 
		SETSIZE(iv->iLen + 1); 
		iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); 
	} 
	if (len) 
		memcpy(iv->iStr, str, len); 
	iv->iStr[len] = '\0'; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gChangeStrValue(object self, char *str)
{ 
	return ChangeValue(self, (object) str); 
} 

imeth objrtn String_im_gDispose(object self)
{ String_iv_t *iv = GetIVs(String, self);
	if (iv->iStr) 
		MA_free(iv->iStr); 
	return oSuper(String_c, gDispose, self)(self); 
} 

imeth int String_im_gHash(object self)
{ String_iv_t *iv = GetIVs(String, self);
	register char c = 'a'; 
	char *s = iv->iStr; 
	double t; 
	register unsigned short k=0; 

	while (*s) 
		k += *s++ ^ c++; 
	t = .6125423371 * k; 
	return (int) (BIG_INT * (t - floor(t))); 
} 

imeth int String_im_gCompare(object self, object obj)
{ String_iv_t *iv = GetIVs(String, self);
	char *s, *t; 
	int tlen, slen; 

	if (IsObj(obj)) { 
		ivType *iv2; 

		if (!gIsKindOf(obj, CLASS)) 
			return oSuper(String_c, gCompare, self)(self, obj); 
		iv2 = ivPtr(obj); 
		t = iv2->iStr; 
		if (iv2->iCalcLen) 
			iv2->iLen = strlen(t); 
		tlen = iv2->iLen; 
	} else { 
		t = (char *) obj; 
		tlen = t ? strlen(t) : 0; 
	} 
	UPDATE_LEN; 
	slen = iv->iLen; 
	s = iv->iStr; 
	while (slen && tlen && *s == *t) { 
		s++; 
		t++; 
		slen--; 
		tlen--; 
	} 
	if (!slen && !tlen) 
		return 0; 
	if (!slen) 
		return -1; 
	if (!tlen) 
		return 1; 
	return *(unsigned char *)s - *(unsigned char *)t; 
} 

imeth int String_im_gCompareI(object self, object obj)
{ String_iv_t *iv = GetIVs(String, self);
	char *s, *t; 
	int tlen, slen; 

	if (IsObj(obj)) { 
		ivType *iv2; 

		if (!gIsKindOf(obj, CLASS)) 
			gError(self, "CompareI::String:  Arg 2 incorrect type.\n"); 
		iv2 = ivPtr(obj); 
		t = iv2->iStr; 
		if (iv2->iCalcLen) 
			iv2->iLen = strlen(t); 
		tlen = iv2->iLen; 
	} else { 
		t = (char *) obj; 
		tlen = t ? strlen(t) : 0; 
	} 
	UPDATE_LEN; 
	slen = iv->iLen; 
	s = iv->iStr; 
	while (slen && tlen && tolower(*s) == tolower(*t)) { 
		s++; 
		t++; 
		slen--; 
		tlen--; 
	} 
	if (!slen && !tlen) 
		return 0; 
	if (!slen) 
		return -1; 
	if (!tlen) 
		return 1; 
	return tolower(*(unsigned char *)s) - tolower(*(unsigned char *)t); 
} 

imeth int String_im_gCompareN(object self, object obj, int n)
{ String_iv_t *iv = GetIVs(String, self);
	char *s, *t; 
	int tlen, slen; 

	if (IsObj(obj)) { 
		ivType *iv2; 

		if (!gIsKindOf(obj, CLASS)) 
			gError(self, "CompareN::String:  Arg 2 incorrect type.\n"); 
		iv2 = ivPtr(obj); 
		t = iv2->iStr; 
		if (iv2->iCalcLen) 
			iv2->iLen = strlen(t); 
		tlen = iv2->iLen; 
	} else { 
		t = (char *) obj; 
		tlen = t ? strlen(t) : 0; 
	} 
	UPDATE_LEN; 
	slen = iv->iLen; 
	s = iv->iStr; 
	while (n && slen && tlen && *s == *t) { 
		s++; 
		t++; 
		n--; 
		slen--; 
		tlen--; 
	} 
	if (!n || !slen && !tlen) 
		return 0; 
	if (!slen) 
		return -1; 
	if (!tlen) 
		return 1; 
	return *(unsigned char *)s - *(unsigned char *)t; 
} 

imeth int String_im_gCompareNI(object self, object obj, int n)
{ String_iv_t *iv = GetIVs(String, self);
	char *s, *t; 
	int tlen, slen; 

	if (IsObj(obj)) { 
		ivType *iv2; 

		if (!gIsKindOf(obj, CLASS)) 
			gError(self, "CompareNI::String:  Arg 2 incorrect type.\n"); 
		iv2 = ivPtr(obj); 
		t = iv2->iStr; 
		if (iv2->iCalcLen) 
			iv2->iLen = strlen(t); 
		tlen = iv2->iLen; 
	} else { 
		t = (char *) obj; 
		tlen = t ? strlen(t) : 0; 
	} 
	UPDATE_LEN; 
	slen = iv->iLen; 
	s = iv->iStr; 
	while (n && slen && tlen && tolower(*s) == tolower(*t)) { 
		s++; 
		t++; 
		n--; 
		slen--; 
		tlen--; 
	} 
	if (!n || !slen && !tlen) 
		return 0; 
	if (!slen) 
		return -1; 
	if (!tlen) 
		return 1; 
	return tolower(*(unsigned char *)s) - tolower(*(unsigned char *)t); 
} 

imeth objrtn String_im_gStringRepValue(object self)
{ String_iv_t *iv = GetIVs(String, self);
	return vSprintf(String, "\"%s\"", iv->iStr ? iv->iStr : "(null)"); 
} 

imeth int String_im_gPrintLength(object self, int t)
{ String_iv_t *iv = GetIVs(String, self);
	register int n=0; 
	int l=0; 
	char *s; 

	UPDATE_LEN; 
	if (!iv->iLen) 
		return(0); 
	for (s=iv->iStr ; *s && *s != '\n' ; ++s) 
		switch (*s) { 
		case '\t': 
		n += t - n % t; 
		break; 
		case '\b': 
		if (n) 
			--n; 
		break; 
		case '\r': 
		l = max(n, l); 
		n = 0; 
		break; 
		default: 
		if (isprint(*s)) 
			++n; 
		break; 
	} 
	return max(l, n); 
} 

#define more n 
#define next s++, n-- 

static int Val(char c, int b) 
{ 
	int n; 

	if (isdigit(c)) n = c - '0'; 
	else if (isalpha(c)) n = toupper(c) - ('A' - 10); 
	else return(-1); 
	if (n >= b) return(-1); 
	return(n); 
} 

imeth objrtn String_im_gProcess(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s, *d; 
	int a, i, n; 

	UPDATE_LEN; 
	s = d = iv->iStr; 
	for (n=iv->iLen ; more ; ) 
		if (*s != '\\') { 
		*d++ = *s; 
		next; 
	} else { 
		next; 
		if (!more) 
			break; 
		switch (*s) { 
			case 'N': 
			case 'n': 
			*d++ = '\n'; 
			next; 
			break; 
			case 'T': 
			case 't': 
			*d++ = '\t'; 
			next; 
			break; 
			case 'B': 
			case 'b': 
			*d++ = '\b'; 
			next; 
			break; 
			case 'R': 
			case 'r': 
			*d++ = '\r'; 
			next; 
			break; 
			case 'F': 
			case 'f': 
			*d++ = '\f'; 
			next; 
			break; 
			case 'E': 
			case 'e': 
			*d++ = 27; 
			next; 
			break; 
			case 'A': 
			case 'a': 
			*d++ = 7; 
			next; 
			break; 
			case 'V': 
			case 'v': 
			*d++ = '\v'; 
			next; 
			break; 
			case '^': 
			next; 
			if (!more) 
				goto end; 
			*d++ = tolower(*s) - ('a' - 1); 
			next; 
			break; 
			case 'X': 
			case 'x': 
			*d = '\0'; 
			for (i = 0, next ; more && (a = Val(*s, 16)) != -1 && i != 2; next, ++i) 
				*d = 16 * *d + a; 
			++d; 
			break; 
			case 'D': 
			case 'd': 
			*d = '\0'; 
			for (i = 0, next ; more && (a = Val(*s, 10)) != -1 && i != 3; next, ++i) 
				*d = 10 * *d + a; 
			++d; 
			break; 
			case '\0': 
			break; 
			default: 
			if (isdigit(*s)) { 
				*d = '\0'; 
				for (i = 0; more && (a = Val(*s, 8)) != -1 && i != 3; next, ++i) 
					*d = 8 * *d + a; 
				++d; 
				break; 
			} 
			*d++ = *s; 
			next; 
			break; 
		} 
	} 
	end: 
	*d = '\0'; 
	iv->iLen = d - iv->iStr; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gAppend(object self, object obj)
{ String_iv_t *iv = GetIVs(String, self);
	char *str; 
	int len, need; 

	if (!obj) 
		return self; 
	UPDATE_LEN; 
	len = get_string(obj, &str, "Append", 2); 
	need = iv->iLen + 1 + len; 
	if (need > iv->iSize) { 
		if (iv->iBlksz == 1) 
			iv->iBlksz = ABS; 
		SETSIZE(need); 
		iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); 
	} 
	memcpy(iv->iStr + iv->iLen, str, len); 
	iv->iLen += len; 
	iv->iStr[iv->iLen] = '\0'; 
	return self; 
} 

imeth int String_im_gWrite(object self, char *buf, unsigned len)
{ String_iv_t *iv = GetIVs(String, self);
	int need; 

	UPDATE_LEN; 
	need = iv->iLen + 1 + len; 
	if (need > iv->iSize) { 
		if (iv->iBlksz == 1) 
			iv->iBlksz = ABS; 
		SETSIZE(need); 
		iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); 
	} 
	memcpy(iv->iStr + iv->iLen, buf, len); 
	iv->iLen += len; 
	iv->iStr[iv->iLen] = '\0'; 
	return len; 
} 

imeth int String_im_gRead(object self, char *buf, unsigned n)
{ String_iv_t *iv = GetIVs(String, self);
	int len; 

	UPDATE_LEN; 
	len = n > (unsigned) iv->iLen ? iv->iLen : (int) n; 
	memcpy(buf, iv->iStr, len); 
	memmove(iv->iStr, iv->iStr+len, iv->iLen-len+1); 
	iv->iLen -= len; 
	FREE_UNUSED; 
	return len; 
} 

imeth char * String_im_gGets(object self, char *buf, int n)
{ String_iv_t *iv = GetIVs(String, self);
	int len; 

	UPDATE_LEN; 
	if (!iv->iLen) 
		return NULL; 
	if (n <= 0) 
		return NULL; 
	if (n-- == 1) { 
		*buf = '\0'; 
		return buf; 
	} 
	for (len=0 ; len < iv->iLen && iv->iStr[len++] != '\n' ; ); 
	memcpy(buf, iv->iStr, len); 
	memmove(iv->iStr, iv->iStr+len, iv->iLen-len+1); 
	iv->iLen -= len; 
	FREE_UNUSED; 
	buf[len] = '\0'; 
	return buf; 
} 

imeth long String_im_gAdvance(object self, long n)
{ String_iv_t *iv = GetIVs(String, self);
	int len; 

	UPDATE_LEN; 
	len = n > (long) iv->iLen ? iv->iLen : (int) n; 
	memmove(iv->iStr, iv->iStr+len, iv->iLen-len+1); 
	iv->iLen -= len; 
	FREE_UNUSED; 
	return (long) len; 
} 

imeth long String_im_gPosition(object self)
{ 
	USE(self); 
	return 0L; 
} 

imeth long String_im_gLength(object self)
{ String_iv_t *iv = GetIVs(String, self);
	UPDATE_LEN; 
	return (long) iv->iLen; 
} 

imeth int String_im_gEndOfStream(object self)
{ String_iv_t *iv = GetIVs(String, self);
	UPDATE_LEN; 
	return !iv->iLen; 
} 

cvmeth objrtn String_cvm_vSprintf(object self, va_list _rest_)
{ 
	char * fmt = va_arg(_rest_, char *);

#line 569 "string.d"
	char buf[256]; 
	MAKE_REST(fmt); 

	vsprintf(buf, fmt, _rest_); 
	return gNewWithStr(self, buf); 
} 

#line 585 "string.c"

static	objrtn	String_cfm_vSprintf(object self, ...)
{
	va_list	_rest_;
	va_start(_rest_, self);
	return String_cvm_vSprintf(self, _rest_);
}



#line 576 "string.d"
ivmeth objrtn String_ivm_vBuild(object self, va_list _rest_)
{ String_iv_t *iv = GetIVs(String, self);char * f = va_arg(_rest_, char *);
	object obj; 
	char *str, *pbuf; 
	va_list ap; 
	int len, argn, tlen; 
	static char fun[] = "Build"; 
	MAKE_REST(f); 
#line 588 "string.d"
	UPDATE_LEN; 
	if (f) 
		tlen = get_string((object) f, &str, fun, 2); 
	else 
		tlen = iv->iLen; 
	ASSIGN_VA_LIST(ap, _rest_); 
	for (argn=3 ; obj = va_arg(ap, object) ; ) 
		tlen += get_string(obj, &str, fun, argn++); 
#line 600 "string.d"
	if (tlen >= iv->iSize) { 
		if (iv->iBlksz == 1 && !f) 
			iv->iBlksz = ABS; 
		SETSIZE(tlen + 1); 
		iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); 
	} 
#line 610 "string.d"
	pbuf = iv->iStr; 
	if (f) { 
		len = get_string((object)f, &str, fun, 2); 
		if (len) 
			memcpy(pbuf, str, len); 
		pbuf += len; 
	} else 
		pbuf += iv->iLen; 
	for (argn=3 ; obj = GetArg(object) ; ) { 
		len = get_string(obj, &str, fun, argn++); 
		if (len) { 
			memcpy(pbuf, str, len); 
			pbuf += len; 
		} 
	} 
	*pbuf = '\0'; 
	iv->iLen = tlen; 
	return self; 
} 

#line 642 "string.c"

static	objrtn	String_ifm_vBuild(object self, ...)
{
	va_list	_rest_;
	va_start(_rest_, self);
	return String_ivm_vBuild(self, _rest_);
}



#line 630 "string.d"
cvmeth objrtn String_cvm_vBuild(object self, va_list _rest_)
{ 
	object obj; 
	char *str, *pbuf; 
	va_list ap; 
	int len, argn, tlen=0; 
	static char fun[] = "Build"; 
	object newObj = oSuper(String_c, gNew, self)(self); 
	ivType *iv = ivPtr(newObj); 
	MAKE_REST(self); 




	ASSIGN_VA_LIST(ap, _rest_); 
	for (argn=2 ; obj = va_arg(ap, object) ; ) 
		tlen += get_string(obj, &str, fun, argn++); 



	iv->iBlksz = 1; 
	SETSIZE(tlen + 1); 
	iv->iStr = (char *) MA_malloc(iv->iSize, &iv->iStr); 




	pbuf = iv->iStr; 
	for (argn=2 ; obj = GetArg(object) ; ) { 
		len = get_string(obj, &str, fun, argn++); 
		if (len) { 
			memcpy(pbuf, str, len); 
			pbuf += len; 
		} 
	} 
	*pbuf = '\0'; 
	iv->iLen = tlen; 
	return newObj; 
} 

#line 694 "string.c"

static	objrtn	String_cfm_vBuild(object self, ...)
{
	va_list	_rest_;
	va_start(_rest_, self);
	return String_cvm_vBuild(self, _rest_);
}


#line 670 "string.d"
static int get_string(object obj, char **str, char *fun, int argn) 
{ 
	ivType *iv2; 
	char buf[80]; 

	if (!obj) { 
		*str = ""; 
		return 0; 
	} else if (!IsObj(obj)) { 
		*str = (char *) obj; 
		return strlen((char *) obj); 
	} 
	if (!gIsKindOf(obj, CLASS)) { 
		sprintf(buf, "%s::String:  Arg %d incorrect type.\n", fun, argn); 
		gError(Dynace, buf); 
	} 
	iv2 = ivPtr(obj); 
	*str = iv2->iStr; 
	return iv2->iCalcLen ? (iv2->iLen=strlen(iv2->iStr)) : iv2->iLen; 
} 

imeth char String_im_gCharValueAt(object self, int i)
{ String_iv_t *iv = GetIVs(String, self);
	UPDATE_LEN; 
	if (i < 0 || i > iv->iLen) 
		gError(self, "CharValue::String:  Index out of range.\n"); 
	return iv->iStr[i]; 
} 

imeth objrtn String_im_gChangeCharAt(object self, int i, int c)
{ String_iv_t *iv = GetIVs(String, self);
	UPDATE_LEN; 
	if (i < 0 || i > iv->iLen) 
		gError(self, "ChangeCharAt::String:  Index out of range.\n"); 
	if (i == iv->iLen) { 
		char buf[2]; 
		buf[0] = c; 
		buf[1] = '\0'; 
		return gAppend(self, (object) buf); 
	} 
	iv->iStr[i] = c; 
	return self; 
} 

imeth objrtn String_im_gToLower(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s; 
	int len; 

	UPDATE_LEN; 
	s = iv->iStr; 
	len = iv->iLen; 
	for ( ; len-- ; s++) 
		*s = tolower(*s); 
	return self; 
} 

imeth objrtn String_im_gToUpper(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s; 
	int len; 

	UPDATE_LEN; 
	s = iv->iStr; 
	len = iv->iLen; 
	for ( ; len-- ; s++) 
		*s = toupper(*s); 
	return self; 
} 

imeth objrtn String_im_gSubString(object self, int beg, int num)
{ String_iv_t *iv = GetIVs(String, self);
	object obj = oSuper(String_c, gNew, CLASS)(CLASS); 
	ivType *iv2 = ivPtr(obj); 

	UPDATE_LEN; 
	if (beg < 0) 
		beg = iv->iLen + beg; 
	if (num < 0) { 
		beg += num + 1; 
		num = -num; 
	} 

	if (beg >= iv->iLen || beg < 0) 
		num = 0; 
	else { 
		int n = iv->iLen - beg; 
		num = num < n ? num : n; 
	} 
	iv2->iBlksz = 1; 
	SETSIZE(num+1); 
	iv2->iLen = num; 
	iv2->iStr = (char *) MA_malloc(iv2->iSize, &iv2->iStr); 
	if (num) 
		memcpy(iv2->iStr, iv->iStr+beg, num); 
	iv2->iStr[num] = '\0'; 
	return obj; 
} 

imeth objrtn String_im_gTake(object self, int n)
{ String_iv_t *iv = GetIVs(String, self);
	int i, len; 
	char *s; 

	UPDATE_LEN; 
	len = n < 0 ? -n : n; 
	if (len == iv->iLen) 
		return self; 
	if (len >= iv->iSize) { 
		SETSIZE(len + 1); 
		iv->iStr = (char *) MA_realloc(iv->iStr, iv->iSize); 
	} 
	s = iv->iStr; 
	if (n >= 0) { 
		for (i=iv->iLen ; i < len ; i++) 
			s[i] = ' '; 
		goto end; 
	} 
	if (iv->iLen < len) { 
		n = len - iv->iLen; 
		memmove(s + n, s, iv->iLen); 
		for (i = 0; i < n ; i++) 
			s[i] = ' '; 
		goto end; 
	} 
	memmove(s, s + (iv->iLen - len), len); 
	end: 
	s[len] = '\0'; 
	iv->iLen = len; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gDrop(object self, int n)
{ String_iv_t *iv = GetIVs(String, self);
	int an; 

	if (!n) 
		return self; 
	UPDATE_LEN; 
	an = n < 0 ? -n : n; 
	if (an >= iv->iLen) 
		iv->iLen = 0; 
	else { 
		if (n > 0) 
			memmove(iv->iStr, iv->iStr + n, iv->iLen - n); 
		iv->iLen -= an; 
	} 
	iv->iStr[iv->iLen] = '\0'; 
	FREE_UNUSED; 
	return self; 
} 

#define ISspace(c) ((c) == ' ' || (c) == '\t' || (c) == '\n' || (c) == '\r') 

imeth objrtn String_im_gStripLeft(object self)
{ String_iv_t *iv = GetIVs(String, self);
	int i, n; 
	char *s = iv->iStr; 

	UPDATE_LEN; 
	for (i=0, n=iv->iLen ; n && ISspace(s[i]) ; ++i, --n); 
	if (!i) 
		return self; 
	if (n) 
		memmove(s, s + i, n); 
	iv->iLen = n; 
	s[n] = '\0'; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gStripRight(object self)
{ String_iv_t *iv = GetIVs(String, self);
	int n; 
	char *s = iv->iStr; 

	UPDATE_LEN; 
	for (n = iv->iLen - 1 ; n >= 0 && ISspace(s[n]) ; n--); 
	s[iv->iLen = n + 1] = '\0'; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gStripCenter(object self)
{ String_iv_t *iv = GetIVs(String, self);
	int i, n; 
	char *s = iv->iStr; 

	UPDATE_LEN; 
	for (i=0, n=iv->iLen ; n && ISspace(s[i]) ; ++i, --n); 
	if (n && i) 
		memmove(s, s + i, n); 
	for (--n ; n >= 0 && ISspace(s[n]) ; n--); 
	s[iv->iLen = n + 1] = '\0'; 
	FREE_UNUSED; 
	return self; 
} 

imeth objrtn String_im_gJustifyLeft(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s = iv->iStr; 
	int n, i; 

	UPDATE_LEN; 
	n = iv->iLen; 
	for (i=0 ; i < n && ISspace(s[i]) ; ++i); 
	if (!i) 
		return self; 
	memmove(s, s + i, n-i); 
	for (i=n-i ; i < n ; ) 
		s[i++] = ' '; 
	return self; 
} 

imeth objrtn String_im_gJustifyRight(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s = iv->iStr; 
	int n, i, p; 

	UPDATE_LEN; 
	n = iv->iLen; 
	for (i=n-1 ; i >= 0 && ISspace(s[i]) ; --i); 
	p = n - (i + 1); 
	if (!p) 
		return self; 
	memmove(s + p, s, n-p); 
	for (i=0 ; i < p ; ) 
		s[i++] = ' '; 
	return self; 
} 

imeth objrtn String_im_gJustifyCenter(object self)
{ String_iv_t *iv = GetIVs(String, self);
	char *s = iv->iStr; 
	int n, left, right, left2, p, i; 

	UPDATE_LEN; 
	n = iv->iLen; 
	for (left=0 ; left < n && ISspace(s[left]) ; ++left); 
	for (right=0, i=n-1 ; i >= 0 && ISspace(s[i]) ; --i, ++right); 
	left2 = (left + right) / 2; 
	if (left2 == left) 
		return self; 
	if (left2 < left) { 
		p = left - left2; 
		memmove(s, s + p, n - p); 
		for (i=n-(p+1) ; i < n ; ) 
			s[i--] = ' '; 
	} else { 
		p = left2 - left; 
		memmove(s + p, s, n - p); 
		for (i=0 ; i < p ; ) 
			s[i++] = ' '; 
	} 
	return self; 
} 

imeth int String_im_gEqual(object self, object obj)
{ String_iv_t *iv = GetIVs(String, self);
	char *str; 
	int len; 

	if (EQ(self, obj)) 
		return 1; 
	if (IsObj(obj)) { 
		ivType *iv2; 
		if (NEQ(ClassOf(self), ClassOf(obj))) 
			return 0; 
		iv2 = ivPtr(obj); 
		if (iv2->iCalcLen) 
			iv2->iLen = strlen(iv2->iStr); 
		len = iv2->iLen; 
		str = iv2->iStr; 
	} else { 
		str = (char *) obj; 
		len = str ? strlen(str) : 0; 
	} 
	UPDATE_LEN; 
	if (iv->iLen != len) 
		return 0; 
	if (len) 
		return memcmp(iv->iStr, str, len) ? 0 : 1; 
	else 
		return 1; 
} 

imeth objrtn String_im_gCopy(object self)
{ 
	return gNewWithObj(ClassOf(self), self); 
} 


#line 998 "string.c"

objrtn	String_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (String_c) {
		LEAVECRITICALSECTION(cs);
		return String_c;
	}
	INHIBIT_THREADER;
	Stream_initialize();
	if (String_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return String_c;
	}
	String_c = gNewClass(Class, "String", sizeof(String_iv_t), 0, Stream, END);
	cMethodFor(String, gNewWithStr, New);
	cMethodFor(String, gNewWithInt, String_cm_gNewWithInt);
	cMethodFor(String, gNew, String_cm_gNew);
	cMethodFor(String, gNewWithObj, String_cm_gNewWithObj);
	cvMethodFor(String, vBuild, String_cvm_vBuild, String_cfm_vBuild);
	cvMethodFor(String, vSprintf, String_cvm_vSprintf, String_cfm_vSprintf);
	iMethodFor(String, gCompareNI, String_im_gCompareNI);
	iMethodFor(String, gAppend, String_im_gAppend);
	iMethodFor(String, gChangeStrValue, String_im_gChangeStrValue);
	iMethodFor(String, gPosition, String_im_gPosition);
	iMethodFor(String, gTake, String_im_gTake);
	iMethodFor(String, gLength, String_im_gLength);
	iMethodFor(String, gWrite, String_im_gWrite);
	iMethodFor(String, gCompare, String_im_gCompare);
	iMethodFor(String, gEndOfStream, String_im_gEndOfStream);
	iMethodFor(String, gCompareN, String_im_gCompareN);
	iMethodFor(String, gPrintLength, String_im_gPrintLength);
	iMethodFor(String, gCompareI, String_im_gCompareI);
	iMethodFor(String, gToLower, String_im_gToLower);
	iMethodFor(String, gAdvance, String_im_gAdvance);
	iMethodFor(String, gSize, String_im_gSize);
	ivMethodFor(String, vBuild, String_ivm_vBuild, String_ifm_vBuild);
	iMethodFor(String, gChangeCharAt, String_im_gChangeCharAt);
	iMethodFor(String, gCharValueAt, String_im_gCharValueAt);
	iMethodFor(String, gDispose, String_im_gDispose);
	iMethodFor(String, gProcess, String_im_gProcess);
	iMethodFor(String, gStripCenter, String_im_gStripCenter);
	iMethodFor(String, gEqual, String_im_gEqual);
	iMethodFor(String, gToUpper, String_im_gToUpper);
	iMethodFor(String, gJustifyRight, String_im_gJustifyRight);
	iMethodFor(String, gGets, String_im_gGets);
	iMethodFor(String, gDrop, String_im_gDrop);
	iMethodFor(String, gGCDispose, String_im_gDispose);
	iMethodFor(String, gJustifyLeft, String_im_gJustifyLeft);
	iMethodFor(String, gStringRepValue, String_im_gStringRepValue);
	iMethodFor(String, gJustifyCenter, String_im_gJustifyCenter);
	iMethodFor(String, gHash, String_im_gHash);
	iMethodFor(String, gChangeValue, ChangeValue);
	iMethodFor(String, gCopy, String_im_gCopy);
	iMethodFor(String, gSubString, String_im_gSubString);
	iMethodFor(String, gDeepDispose, String_im_gDispose);
	iMethodFor(String, gRead, String_im_gRead);
	iMethodFor(String, gDeepCopy, String_im_gCopy);
	iMethodFor(String, gStringValue, String_im_gStringValue);
	iMethodFor(String, gStripLeft, String_im_gStripLeft);
	iMethodFor(String, gStripRight, String_im_gStripRight);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return String_c;
}



