

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 16 "file.d"
#include <sys/types.h> 
#if !defined(vms) && !defined(__MWERKS__) 
#include <sys/stat.h> 
#endif 
#ifdef sparc 
#include <unistd.h> 
#endif 

#define	CLASS	File_c
#define	ivType	File_iv_t

#include "generics.h"

object	File_c;


#line 34 "file.c"
typedef struct  _File_iv_t  {
	object iName;
	FILE * iFP;
}	File_iv_t;



#line 31 "file.d"
cmeth objrtn File_cm_gNew(object self)
{ 
	return gShouldNotImplement(self, "gNew"); 
} 

cmeth objrtn File_cm_gOpenFile(object self, char *name, char *mode)
{ 
	object obj; 
	ivType *iv; 
	FILE *fp; 

	if (IsObj((object) name)) 
		name = gStringValue((object) name); 
	if (IsObj((object) mode)) 
		mode = gStringValue((object) mode); 
	fp = fopen(name, mode); 
	if (!fp) 
		return NULL; 
	obj = oSuper(File_c, gNew, self)(self); 
	iv = ivPtr(obj); 
	iv->iName = gNewWithStr(String, name); 
	iv->iFP = fp; 
	return obj; 
} 

static objrtn StreamObject(object self, char *name, FILE *fp)
{ 
	object obj; 
	ivType *iv; 

	obj = oSuper(File_c, gNew, self)(self); 
	iv = ivPtr(obj); 
	iv->iName = gNewWithStr(String, name); 
	iv->iFP = fp; 
	return obj; 
} 

imeth objrtn File_im_gDispose(object self)
{ File_iv_t *iv = GetIVs(File, self);
	fclose(iv->iFP); 
	gDispose(iv->iName); 
	oSuper(File_c, gDispose, self)(self); 
	return NULL; 
} 

imeth int File_im_gRead(object self, char *buf, unsigned n)
{ File_iv_t *iv = GetIVs(File, self);
	return fread(buf, 1, n, iv->iFP); 
} 

imeth int File_im_gWrite(object self, char *buf, unsigned n)
{ File_iv_t *iv = GetIVs(File, self);
	return fwrite(buf, 1, n, iv->iFP); 
} 

imeth char * File_im_gGets(object self, char *buf, int sz)
{ File_iv_t *iv = GetIVs(File, self);

	return fgets(buf, sz, iv->iFP); 
} 

imeth long File_im_gAdvance(object self, long n)
{ File_iv_t *iv = GetIVs(File, self);
	int r = fseek(iv->iFP, n, SEEK_CUR); 
	return r ? 0L : n; 
} 

imeth long File_im_gRetreat(object self, long n)
{ File_iv_t *iv = GetIVs(File, self);
	int r = fseek(iv->iFP, -n, SEEK_CUR); 
	return r ? 0L : n; 
} 

imeth long File_im_gSeek(object self, long n)
{ File_iv_t *iv = GetIVs(File, self);
	int r = fseek(iv->iFP, n, SEEK_SET); 
	return r ? 0L : n; 
} 

imeth long File_im_gPosition(object self)
{ File_iv_t *iv = GetIVs(File, self);

	return ftell(iv->iFP); 
} 

imeth long File_im_gLength(object self)
{ File_iv_t *iv = GetIVs(File, self);
#if !defined(vms) && !defined(__MWERKS__) 
		struct stat sb; 
	int r; 

	r = fstat(fileno(iv->iFP), &sb); 
	return r ? -1L : sb.st_size; 
#else 
		long sav = ftell(iv->iFP); 
	long len; 

	fseek(iv->iFP, 0L, SEEK_END); 
	len = ftell(iv->iFP); 
	fseek(iv->iFP, sav, SEEK_SET); 
	return len; 
#endif 
	} 

imeth char * File_im_gName(object self)
{ File_iv_t *iv = GetIVs(File, self);
	return gStringValue(iv->iName); 
} 

imeth int File_im_gEndOfStream(object self)
{ File_iv_t *iv = GetIVs(File, self);
	return feof(iv->iFP); 
} 

imeth void * File_im_gPointerValue(object self)
{ File_iv_t *iv = GetIVs(File, self);
	return (void *) iv->iFP; 
} 

static void class_init(void) 
{ 
	String; 
	stdoutStream_o = StreamObject(CLASS, "stdout", stdout); 
	stderrStream_o = StreamObject(CLASS, "stderr", stderr); 
	stdinStream_o = StreamObject(CLASS, "stdin", stdin); 
	traceStream_o = stdoutStream_o; 
} 

#line 171 "file.c"

objrtn	File_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (File_c) {
		LEAVECRITICALSECTION(cs);
		return File_c;
	}
	INHIBIT_THREADER;
	Stream_initialize();
	if (File_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return File_c;
	}
	File_c = gNewClass(Class, "File", sizeof(File_iv_t), 0, Stream, END);
	cMethodFor(File, gNew, File_cm_gNew);
	cMethodFor(File, gOpenFile, File_cm_gOpenFile);
	iMethodFor(File, gRetreat, File_im_gRetreat);
	iMethodFor(File, gPosition, File_im_gPosition);
	iMethodFor(File, gLength, File_im_gLength);
	iMethodFor(File, gWrite, File_im_gWrite);
	iMethodFor(File, gEndOfStream, File_im_gEndOfStream);
	iMethodFor(File, gSeek, File_im_gSeek);
	iMethodFor(File, gPointerValue, File_im_gPointerValue);
	iMethodFor(File, gAdvance, File_im_gAdvance);
	iMethodFor(File, gDispose, File_im_gDispose);
	iMethodFor(File, gName, File_im_gName);
	iMethodFor(File, gGets, File_im_gGets);
	iMethodFor(File, gGCDispose, File_im_gDispose);
	iMethodFor(File, gDeepDispose, File_im_gDispose);
	iMethodFor(File, gRead, File_im_gRead);

	class_init();

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return File_c;
}



