


/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */




defclass  Dictionary : Set  {
 init:	init_class;
};


#include "set1.h"


#define LTYPE	1	/*  lookup type	*/

static	gLookup_t	Lookup;		/*  locally cached  */

imeth	gAddValue, <vAdd> (key, value)
{
	ChkArg(key, 2);
	ChkArgNul(value, 3);
	return Lookup(self, key, HT_ADD, 0, LTYPE, value);
}

imeth	gFindValue, <vFindValue> (key)
{
	object	x;

	ChkArg(key, 2);
	x = Lookup(self, key, HT_FIND, 0, LTYPE, NULL);
	return x ? gValue(x) : x;
}

imeth	gFind, <vFind> (key)
{
	ChkArg(key, 2);
	return Lookup(self, key, HT_FIND, 0, LTYPE, NULL);
}

imeth	gChangeValueWithObj, <vChangeValue> (key, val)
{
	object	x;
	ChkArg(key, 2);
	ChkArgNul(val, 3);
	x = Lookup(self, key, HT_FIND, 0, LTYPE, NULL);
	return x ? gChangeValue(x, val) : x;
}

imeth	gFindAddValue, <vFindAdd> (key, value)
{
	ChkArg(key, 2);
	ChkArgNul(value, 3);
	return Lookup(self, key, HT_FINDADD, 0, LTYPE, value);
}

imeth	object	gDispose()
{
	return gDispose1(self);
}

imeth	object	gDisposeAllNodes()
{
	return gDisposeAllNodes1(self);
}

imeth	gRemoveObj, <vRemove> (key)
{
	ChkArg(key, 2);
	return Lookup(self, key, HT_DELETE, 1, LTYPE, NULL);
}

imeth	gDeepDisposeObj, gDisposeObj (key)
{
	ChkArg(key, 2);
	return Lookup(self, key, HT_DELETE, 2, LTYPE, NULL);
}

static	void	init_class(void)
{
	Lookup = imcPointer(Set, gLookup);
}



/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


