

/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */




#include <stdio.h>
#include <sys/time.h>
#include <signal.h>


#ifdef TEST
int   _tick_count = 10000;
#else
extern int   _tick_count;
#endif

static  void  catch_timer(int sig)
{
	(void) sig;  /*  avoid compiler warning  */
	if (_tick_count)
		_tick_count--;
	signal(SIGVTALRM, catch_timer);
}


void _start_timer(void)
{
	struct itimerval tval;

	signal(SIGVTALRM, catch_timer);
	tval.it_interval.tv_sec = 0L;
	tval.it_interval.tv_usec = 54645L; /*  ~ 18/sec (single clock tick  */
	tval.it_value = tval.it_interval;
	setitimer(ITIMER_VIRTUAL, &tval, NULL);
}


#ifdef TEST

main()
{
	int n;
	long i;

	_start_timer();
	for (n=0 ; n++ != 10 ; )  {
		fprintf(stderr, "Timer = %d\n", _tick_count);
		for (i=0L ; i++ != 1000000 ; );
	}
	return(0);
}

#endif



/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



